/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRebaseResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.DelegatingProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.StatusCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

public class RebaseCommand
extends GitCommand {
    private final String revision;
    private GitRebaseResult result;
    private final ProgressMonitor monitor;
    private final GitClient.RebaseOperationType operation;

    public RebaseCommand(Repository repository, GitClassFactory gitFactory, String revision, GitClient.RebaseOperationType operation, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revision = revision;
        this.operation = operation;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.RebaseCommand command = new Git(repository).rebase();
        if (this.operation == GitClient.RebaseOperationType.BEGIN) {
            Ref ref = null;
            try {
                ref = repository.getRef(this.revision);
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
            if (ref == null) {
                command.setUpstream(Utils.findCommit(repository, this.revision));
            } else {
                command.setUpstream((AnyObjectId)ref.getTarget().getObjectId());
                command.setUpstreamName(ref.getName());
            }
        }
        command.setOperation(RebaseCommand.getOperation(this.operation));
        command.setProgressMonitor((org.eclipse.jgit.lib.ProgressMonitor)new DelegatingProgressMonitor(this.monitor));
        try {
            RebaseResult res = command.call();
            this.result = this.createResult(res);
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("git rebase ");
        if (this.operation == GitClient.RebaseOperationType.BEGIN) {
            sb.append(this.revision);
        } else {
            sb.append(this.operation.toString());
        }
        return sb.toString();
    }

    public GitRebaseResult getResult() {
        return this.result;
    }

    static RebaseCommand.Operation getOperation(GitClient.RebaseOperationType operation) {
        return RebaseCommand.Operation.valueOf((String)operation.name());
    }

    private GitRebaseResult createResult(RebaseResult res) {
        String currHead;
        Repository repository = this.getRepository();
        File workTree = repository.getWorkTree();
        try {
            currHead = repository.resolve("HEAD").name();
        }
        catch (IOException ex) {
            currHead = "HEAD";
        }
        List<File> conflicts = res.getStatus() == RebaseResult.Status.STOPPED ? this.getConflicts(res.getCurrentCommit()) : Collections.emptyList();
        return this.getClassFactory().createRebaseResult(res, conflicts, this.getFailures(res), currHead);
    }

    private List<File> getConflicts(RevCommit currentCommit) {
        List<File> conflicts;
        try {
            Repository repository = this.getRepository();
            GitRevisionInfo info = this.getClassFactory().createRevisionInfo(currentCommit, repository);
            Map<File, GitRevisionInfo.GitFileInfo> modifiedFiles = info.getModifiedFiles();
            StatusCommand cmd = new StatusCommand(repository, "HEAD", modifiedFiles.keySet().toArray(new File[modifiedFiles.keySet().size()]), this.getClassFactory(), new DelegatingGitProgressMonitor(this.monitor), new StatusListener(){

                @Override
                public void notifyStatus(GitStatus status) {
                }
            });
            cmd.execute();
            Map<File, GitStatus> statuses = cmd.getStatuses();
            conflicts = new ArrayList<File>(statuses.size());
            for (Map.Entry<File, GitStatus> e : statuses.entrySet()) {
                if (!e.getValue().isConflict()) continue;
                conflicts.add(e.getKey());
            }
        }
        catch (GitException ex) {
            Logger.getLogger(RebaseCommand.class.getName()).log(Level.INFO, null, ex);
            conflicts = Collections.emptyList();
        }
        return conflicts;
    }

    private List<File> getFailures(RebaseResult result) {
        ArrayList<File> files;
        block5: {
            List failures;
            File workDir;
            block6: {
                block4: {
                    files = new ArrayList<File>();
                    workDir = this.getRepository().getWorkTree();
                    if (result.getStatus() != RebaseResult.Status.CONFLICTS) break block4;
                    List conflicts = result.getConflicts();
                    if (conflicts == null) break block5;
                    for (String conflict : conflicts) {
                        files.add(new File(workDir, conflict));
                    }
                    break block5;
                }
                if (result.getStatus() != RebaseResult.Status.FAILED) break block6;
                Map obstructions = result.getFailingPaths();
                if (obstructions == null) break block5;
                for (Map.Entry failure : obstructions.entrySet()) {
                    files.add(new File(workDir, (String)failure.getKey()));
                }
                break block5;
            }
            if (result.getStatus() == RebaseResult.Status.UNCOMMITTED_CHANGES && (failures = result.getUncommittedChanges()) != null) {
                for (String conflict : failures) {
                    files.add(new File(workDir, conflict));
                }
            }
        }
        return Collections.unmodifiableList(files);
    }
}

