/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetCommonAncestorCommand
extends GitCommand {
    private final String[] revisions;
    private GitRevisionInfo revision;

    public GetCommonAncestorCommand(Repository repository, GitClassFactory gitFactory, String[] revisions, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        RevWalk walk = null;
        try {
            if (this.revisions.length == 0) {
                this.revision = null;
            } else if (this.revisions.length == 1) {
                this.revision = this.getClassFactory().createRevisionInfo(Utils.findCommit(repository, this.revisions[0]), repository);
            } else {
                walk = new RevWalk(repository);
                for (String rev : this.revisions) {
                    walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, rev)));
                }
                walk.setRevFilter(RevFilter.MERGE_BASE);
                Iterator it = walk.iterator();
                if (it.hasNext()) {
                    this.revision = this.getClassFactory().createRevisionInfo((RevCommit)it.next(), repository);
                }
                if (it.hasNext()) {
                    this.revision = null;
                }
                if (this.revision == null) {
                    DummyMerger merger = new DummyMerger(repository);
                    RevCommit base = merger.getBaseCommit(Utils.findCommit(repository, this.revisions[0]), Utils.findCommit(repository, this.revisions[1]));
                    for (int i = 2; base != null && i < this.revisions.length; ++i) {
                        base = merger.getBaseCommit(base, Utils.findCommit(repository, this.revisions[i]));
                    }
                    if (base != null) {
                        this.revision = this.getClassFactory().createRevisionInfo(base, repository);
                    }
                }
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (walk != null) {
                walk.release();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git merge-base ");
        for (String s : this.revisions) {
            sb.append(s).append(' ');
        }
        return sb.toString();
    }

    public GitRevisionInfo getRevision() {
        return this.revision;
    }

    private class DummyMerger
    extends RecursiveMerger {
        private DummyMerger(Repository repository) {
            super(repository);
        }

        protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
            return super.getBaseCommit(a, b);
        }
    }
}

