/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.IO;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class AddCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public AddCommand(Repository repository, GitClassFactory gitFactory, File[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git add");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = null;
            ObjectInserter inserter = repository.newObjectInserter();
            ObjectReader or = repository.newObjectReader();
            try {
                cache = repository.lockDirCache();
                DirCacheBuilder builder = cache.builder();
                TreeWalk treeWalk = new TreeWalk(repository);
                List<String> relativePaths = Utils.getRelativePaths(repository.getWorkTree(), this.roots);
                if (!relativePaths.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.createFromStrings(relativePaths));
                }
                treeWalk.setRecursive(false);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                String lastAddedFile = null;
                WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                boolean autocrlf = opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE;
                boolean checkExecutable = Utils.checkExecutable(repository);
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    WorkingTreeIterator f = (WorkingTreeIterator)treeWalk.getTree(1, WorkingTreeIterator.class);
                    if (f != null && treeWalk.getTree(0, DirCacheIterator.class) == null && f.isEntryIgnored() || path.equals(lastAddedFile)) continue;
                    if (f != null) {
                        File file = new File(repository.getWorkTree().getAbsolutePath() + File.separator + path);
                        DirCacheEntry entry = new DirCacheEntry(path);
                        entry.setLastModified(f.getEntryLastModified());
                        int fm = f.getEntryFileMode().getBits();
                        long sz = f.getEntryLength();
                        Path p = Paths.get(file.getAbsolutePath(), new String[0]);
                        if (Utils.isFromNested(fm)) {
                            entry.setFileMode(FileMode.fromBits((int)fm));
                            entry.setLength(sz);
                            entry.setObjectId((AnyObjectId)f.getEntryObjectId());
                        } else if (Files.isSymbolicLink(p)) {
                            Path link = Utils.getLinkPath(p);
                            entry.setFileMode(FileMode.SYMLINK);
                            entry.setLength(0);
                            BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                            if (attrs != null) {
                                entry.setLastModified(attrs.lastModifiedTime().toMillis());
                            }
                            entry.setObjectId((AnyObjectId)inserter.insert(3, Constants.encode((String)link.toString())));
                        } else {
                            if ((f.getEntryFileMode().getBits() & 0x4000) == 16384) {
                                treeWalk.enterSubtree();
                                continue;
                            }
                            if (!checkExecutable) {
                                fm &= 0xFFFFFFB6;
                            }
                            entry.setFileMode(FileMode.fromBits((int)fm));
                            try (InputStream in = f.openEntryStream();){
                                if (autocrlf) {
                                    ByteBuffer buf = IO.readWholeStream((InputStream)in, (int)((int)sz));
                                    entry.setObjectId((AnyObjectId)inserter.insert(3, buf.array(), buf.position(), buf.limit() - buf.position()));
                                } else {
                                    entry.setObjectId((AnyObjectId)inserter.insert(3, sz, in));
                                }
                                entry.setLength(sz);
                            }
                        }
                        DirCacheIterator it = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                        if (it == null || !it.getDirCacheEntry().getObjectId().equals((AnyObjectId)entry.getObjectId())) {
                            this.listener.notifyFile(file, path);
                        }
                        builder.add(entry);
                        lastAddedFile = path;
                        continue;
                    }
                    DirCacheIterator c = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                    builder.add(c.getDirCacheEntry());
                }
                if (!this.monitor.isCanceled()) {
                    inserter.flush();
                    builder.commit();
                }
            }
            finally {
                inserter.release();
                or.release();
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }
}

