/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl.push;

import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationChangedListener;
import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.client.configuration.api.ConfigurationProvider;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.communication.api.ClientListener;
import de.proveo.idm.remote.server.communication.api.CommunicationConstants;
import de.proveo.idm.remote.server.communication.api.ConnectionStatistics;
import de.proveo.idm.remote.server.communication.api.ServletConnection;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteMapAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.push.ClientConnectionWatchdog;
import de.proveo.idm.remote.server.efm4_6.impl.push.ConnectionReader;
import de.proveo.idm.remote.server.push.api.DataPreparationUtil;
import de.proveo.idm.remote.server.push.api.DataStorage;
import de.proveo.idm.remote.server.push.api.DataStorageProxy;
import de.proveo.idm.remote.server.push.api.PushConnection;
import de.proveo.util.concurrent.ExtConcurrentHashMap;
import de.proveo.util.unit.MapClientStampUtil;
import java.beans.PropertyChangeListener;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class PushConnectionImpl
implements PushConnection,
ClientListener,
ConfigurationChangedListener,
Observer {
    private static final Logger log = Logger.getLogger(PushConnectionImpl.class.getName());
    private static final long RECONNECT_ERROR_WAITTIME = 120000L;
    private static final long RECONNECT_MINIMUM_LAST_CONNECT = 10000L;
    private static final int RECONNECT_MAXIMUM = 5;
    private Map<String, String> servletParameters = null;
    private ConnectionStatistics connectionStatistics = null;
    private ServletConnection servletConnection = null;
    private ObjectInputStream objectInputStream = null;
    private ConnectionReader connectionReader = null;
    private ClientConnectionWatchdog watchdog = null;
    private volatile boolean reconnecting = false;
    private volatile boolean started = false;
    private long lastSuccessfulConnect = 0L;
    private int reconnectTries = 0;
    private long reconnectWaitTime = 1000L;
    private int reconnectLongTimePeriodeTries = 0;
    private Configuration configuration = null;
    private final RemoteMapAdapterImpl mapAdapter;
    private final DataStorageProxy dataStorageProxy;
    private final EFMServer server;

    public PushConnectionImpl(RemoteMapAdapterImpl mapAdapter, DataStorageProxy dataStorage) {
        this.mapAdapter = mapAdapter;
        this.dataStorageProxy = dataStorage;
        this.server = dataStorage.getServer();
        this.connectionStatistics = new ConnectionStatistics();
        ConfigurationProvider cp = this.server.getConfigurationProvider();
        this.configuration = cp.getActiveConfiguration();
    }

    private void _stopPushConnection() {
        if (this.connectionReader != null) {
            this.connectionReader.disconnect();
            this.connectionReader = null;
        }
        if (this.servletConnection != null) {
            this.servletConnection.close();
            this.servletConnection = null;
        }
    }

    public void configurationChanged(Configuration oldConfig, Configuration newConfig) {
        this.configuration = newConfig;
    }

    private void createConnectionReader(ObjectInputStream objectInputStream, ClientListener clientListener) {
        if (this.connectionReader != null) {
            this.connectionReader.disconnect();
            this.connectionReader = null;
        }
        if (this.watchdog == null) {
            this.watchdog = new ClientConnectionWatchdog(this);
            this.dataStorageProxy.getDataStorage().addPropertyChangeListener((PropertyChangeListener)this.watchdog);
            this.watchdog.start();
        }
        this.connectionReader = new ConnectionReader(this, objectInputStream, this.watchdog);
        if (clientListener != null) {
            this.connectionReader.addClientListener(clientListener);
        }
        this.connectionReader.start();
        this.lastSuccessfulConnect = System.currentTimeMillis();
    }

    public ConnectionStatistics getConnectionStatistics() {
        return this.connectionStatistics;
    }

    protected long getLastSuccessfulConnectionTimestamp() {
        return this.lastSuccessfulConnect;
    }

    private String getTopicSelectors() {
        boolean topicSelectorStands;
        boolean topicSelectorErrorMessages;
        String method = "getTopicSelectors(): ";
        String topicSelectors = "";
        Set interests = this.dataStorageProxy.getConsumersInterests();
        boolean topicSelectorUnits = interests.contains(DataStorage.ConsumerInterest.UNITS);
        boolean topicSelectorNotifies = interests.contains(DataStorage.ConsumerInterest.NOTIFIES);
        boolean topicSelectorUseEvents = interests.contains(DataStorage.ConsumerInterest.OPERATORS);
        boolean topicSelectorUnitsMessages = interests.contains(DataStorage.ConsumerInterest.UNITS_ADDITIONAL_DATA);
        if (!topicSelectorUnits && (topicSelectorNotifies || topicSelectorUseEvents || topicSelectorUnitsMessages)) {
            log.info("DataType units not selected but notifies, operators or unit messages are selected, also select units otherwise this won't make any sense.");
            topicSelectorUnits = true;
        }
        if (topicSelectorUnits) {
            log.log(Level.FINE, "{0}Adding observable topic selector: units", method);
            topicSelectors = "units";
        }
        if (topicSelectorNotifies) {
            log.log(Level.FINE, "{0}Adding observable topic selector: notify_messages", method);
            topicSelectors = topicSelectors.length() == 0 ? "notify_messages" : topicSelectors + ",notify_messages";
        }
        if (topicSelectorUseEvents) {
            log.log(Level.FINE, "{0}Adding observable topic selector: use_messages", method);
            topicSelectors = topicSelectors.length() == 0 ? "use_messages" : topicSelectors + ",use_messages";
        }
        if (topicSelectorUnitsMessages) {
            log.log(Level.FINE, "{0}Adding observable topic selector: infoman_messages", method);
            topicSelectors = topicSelectors.length() == 0 ? "infoman_messages" : topicSelectors + ",infoman_messages";
        }
        if (topicSelectorErrorMessages = interests.contains(DataStorage.ConsumerInterest.SERVER_ERROR_MESSAGES)) {
            log.log(Level.FINE, "{0}Adding observable topic selector: server_errors", method);
            topicSelectors = topicSelectors.length() == 0 ? "server_errors" : topicSelectors + ",server_errors";
        }
        if (topicSelectorStands = interests.contains(DataStorage.ConsumerInterest.STANDS)) {
            log.log(Level.FINE, "{0}Adding observable topic selector: stands", method);
            topicSelectors = topicSelectors.length() == 0 ? "stands" : topicSelectors + ",stands";
        }
        if (topicSelectors.trim().length() == 0) {
            log.log(Level.WARNING, "{0}No observable topic selectors configured! You won''t receive any information!", method);
        }
        log.log(Level.INFO, "{0}Built topic selector: {1}", new Object[]{method, topicSelectors});
        return topicSelectors;
    }

    private void initConnection(Map<String, String> servletParameters) throws Exception {
        String method = "initConnection(): ";
        if (this.connectionReader != null) {
            this.connectionReader.disconnect();
        }
        if (this.servletConnection != null) {
            this.servletConnection.close();
        }
        URL serverURL = new URL(this.server.getURL());
        String protocol = serverURL.getProtocol();
        int port = serverURL.getPort();
        if ("https".equals(protocol) && (port == 80 || port == 8080)) {
            log.log(Level.WARNING, "{0}https (SSL) and port {1} are uncommon ! Mistake in properties ?", new Object[]{method, port});
        }
        String servletPath = "datain/observableClient";
        URL url = new URL(serverURL.getProtocol(), serverURL.getHost(), serverURL.getPort(), "/" + servletPath);
        this.servletConnection = new ServletConnection(url);
        this.servletConnection.connect();
        log.log(Level.INFO, "{0}setup ObjectInputStream with parameters for client side filter", method);
        this.objectInputStream = this.servletConnection.getObjectInputStream(servletParameters);
        this.createConnectionReader(this.objectInputStream, this);
    }

    public void onEvent(Map eventMap) {
        String method = "onEvent(): ";
        if (!this.started) {
            log.log(Level.FINE, "{0}Received event while connection was stopped!", method);
            return;
        }
        String dataType = (String)eventMap.get("DataType");
        if (dataType.equals("units")) {
            log.log(Level.FINE, "{0}information for ALL units received", method);
            this.updateAllUnitsData(eventMap);
        } else if (dataType.equals("SingleUnitEvent")) {
            log.log(Level.FINE, "{0}information for single unit received", method);
            this.updateSingleUnitEvent(eventMap);
        } else if (dataType.equals("unit")) {
            log.log(Level.FINE, "{0}bulk information for single unit received (mini-bulk)", method);
            this.updateSingleUnitBulkEvent(eventMap);
        } else if (dataType.equals("data_type_stands")) {
            log.log(Level.FINE, "{0}information for all stands received", method);
            this.updateAllStandsData(eventMap);
        } else if (dataType.equals("data_type_SingleStandEvent")) {
            log.log(Level.FINE, "{0}Incoming single stand event", method);
            this.updateSingleStandData(eventMap);
        } else if (dataType.equals("data_type_SinglGSEAllocationEventUPDATE")) {
            log.log(Level.FINE, "{0}Incoming single GSE update event", method);
            this.updateSingleStandData(eventMap);
        } else if (dataType.equals("data_type_SinglGSEAllocationEventDELETE")) {
            log.log(Level.FINE, "{0}Incoming single GSE delete event", method);
            this.updateSingleStandData(eventMap);
        } else if (dataType.equals("data_type_SinglStaffAllocationEventUPDATE")) {
            log.log(Level.FINE, "{0}Incoming single staff update event", method);
            this.updateSingleStandData(eventMap);
        } else if (dataType.equals("data_type_SinglStaffAllocationEventDELETE")) {
            log.log(Level.FINE, "{0}Incoming single staff delete event", method);
            this.updateSingleStandData(eventMap);
        } else if (dataType.equals("data_type_server_errors")) {
            log.log(Level.FINE, "{0}Incoming general error event", method);
            this.updateGeneralErrors(eventMap);
        } else if (dataType.equals("data_type_server_messages")) {
            log.log(Level.FINE, "{0}Incoming server message", method);
            this.updateServerMessages(eventMap);
        } else {
            log.log(Level.WARNING, "{0}received unknown data type: ''{1}'' !", new Object[]{method, dataType});
        }
    }

    public void onServerTime(long serverTime) {
        if (!this.started) {
            log.fine("Received server time while connection was stopped!");
            return;
        }
        this.server.updateServerTime(serverTime);
        this.connectionStatistics.addPingEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectPushConnection() {
        String method = "reconnectPushConnection(): ";
        if (this.reconnecting) {
            log.log(Level.INFO, "{0}reconnect is already running, break.", method);
            return;
        }
        this.reconnecting = true;
        this._stopPushConnection();
        if (!this.started) {
            this.reconnecting = false;
            this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.NOT_CONNECTED);
            log.log(Level.INFO, "{0}Connection was stopped, stop trying to reconnect!", method);
            return;
        }
        this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.WAITING_FOR_RECONNECT);
        long now = System.currentTimeMillis();
        if (now - this.lastSuccessfulConnect > 10000L) {
            log.log(Level.INFO, "{0}Normal reconnect: Last successful reconnect was {1}s ago.", new Object[]{method, (now - this.lastSuccessfulConnect) / 1000L});
            if (this.reconnectTries > 1) {
                this.reconnectWaitTime = 1000L;
            }
            this.reconnectTries = 0;
        } else {
            if (this.lastSuccessfulConnect == 0L) {
                log.log(Level.WARNING, "{0}Critical reconnect: Never ever had a successful connection!!! {1} reconnect(s) till a long time period for the next reconnect!", new Object[]{method, 5 - this.reconnectTries});
            } else if (5 - this.reconnectTries > 0) {
                log.log(Level.WARNING, "{0}Critical reconnect: Last successful connect was {1}s ago! {2} reconnect(s) till a long time period for the next reconnect!", new Object[]{method, (now - this.lastSuccessfulConnect) / 1000L, 5 - this.reconnectTries});
            }
            this.reconnectWaitTime = (long)(this.reconnectTries + 1) * 1000L;
        }
        if (this.reconnectTries != 0 || this.reconnectWaitTime != 1000L) {
            this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.RECONNECT_FAILED);
        }
        ++this.reconnectTries;
        if (5 - this.reconnectTries <= 0) {
            log.log(Level.WARNING, "{0}Could not get a connection after {1} reconnects. Set reconnect wait time to {2}!", new Object[]{method, 5 + this.reconnectLongTimePeriodeTries, 120L});
            ++this.reconnectLongTimePeriodeTries;
            this.reconnectWaitTime = 120000L;
        } else {
            this.reconnectLongTimePeriodeTries = 0;
        }
        log.log(Level.INFO, "{0}trying to reconnect in {1}s ...", new Object[]{method, this.reconnectWaitTime / 1000L});
        try {
            try {
                Thread.sleep(this.reconnectWaitTime);
                if (this.reconnectWaitTime < 60000L) {
                    this.reconnectWaitTime += 1000L;
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.RECONNECTING);
            Credentials credentials = this.server.getIDMCredentials();
            this.servletParameters = this.mapAdapter.getServletParameters(this.configuration, this.server.getRemoteMapAdapter().getClientDateUtil(), this.getTopicSelectors(), credentials.getUsername(), credentials.getPassword());
            this.servletParameters.put("reconnectTries", Long.toString(this.connectionStatistics.getServerReconnects()));
            long timestamp = System.currentTimeMillis();
            this.servletParameters.put("reconnectTime", Long.toString(timestamp));
            this.servletParameters.put("reconnectTimeHumanReadable", this.server.getRemoteMapAdapter().getClientDateUtil().getDateTime(timestamp));
            if (!this.started) {
                this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.NOT_CONNECTED);
                log.log(Level.INFO, "{0}Connection was stopped, stop trying to reconnect!", method);
                return;
            }
            this.initConnection(this.servletParameters);
            log.log(Level.INFO, "{0}reconnect successful.", method);
            this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.RECONNECTED);
            this.reconnectWaitTime = 1000L;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, method + "reconnect NOT successful! Runs into:", e);
            this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.RECONNECT_FAILED);
        }
        finally {
            this.reconnecting = false;
            if (this.started && (this.connectionReader == null || !this.connectionReader.isAlive())) {
                this.createConnectionReader(this.objectInputStream, this);
            }
        }
        log.log(Level.INFO, "{0}ServletConnection created.", method);
    }

    public void startPushConnection() throws Exception {
        String method = "startPushConnection(): ";
        this.stopPushConnection();
        this.started = true;
        ConfigurationProvider cp = this.server.getConfigurationProvider();
        cp.addConfigurationChangedListener((ConfigurationChangedListener)this);
        cp.addConfigurationObserver((Observer)this);
        this.configuration = cp.getActiveConfiguration();
        Credentials credentials = this.server.getIDMCredentials();
        this.servletParameters = this.mapAdapter.getServletParameters(this.configuration, this.server.getRemoteMapAdapter().getClientDateUtil(), this.getTopicSelectors(), credentials.getUsername(), credentials.getPassword());
        this.initConnection(this.servletParameters);
        this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.CONNECTED);
        log.log(Level.INFO, "{0}ServletConnection created.", method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPushConnection() {
        block14: {
            this.started = false;
            if (this.watchdog != null) {
                this.dataStorageProxy.getDataStorage().removePropertyChangeListener((PropertyChangeListener)this.watchdog);
                this.watchdog.cancel(true);
                this.watchdog = null;
            }
            ConfigurationProvider cp = this.server.getConfigurationProvider();
            cp.removeConfigurationChangedListener((ConfigurationChangedListener)this);
            cp.removeConfigurationObserver((Observer)this);
            Credentials credentials = this.server.getIDMCredentials();
            String clientId = (String)this.configuration.getValue(ConfigurationParameters.PARAM_TEMP_WWT_CLIENT_ID);
            if (this.servletConnection != null && credentials != null && clientId != null && clientId.trim().length() != 0) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("username", credentials.getUsername());
                parameters.put("password", new String(credentials.getPassword()));
                parameters.put("clientId", clientId);
                parameters.put("jaas", "true");
                parameters.put("logout", "true");
                try {
                    ByteArrayInputStream in;
                    block15: {
                        Object response;
                        String path = "datain/login";
                        if (!path.startsWith("/")) {
                            path = "/" + path;
                        }
                        if ((response = this.server.getRemoteMapAdapter().executeServletCallObject(path, parameters)) == null) {
                            log.warning("JAAS logout response is empty!");
                            break block14;
                        }
                        String xmlResponse = response.toString().trim();
                        if (xmlResponse.length() == 0) {
                            log.warning("JAAS logout response is empty!");
                            break block14;
                        }
                        log.log(Level.FINE, "Logout response content: {0}", xmlResponse);
                        in = null;
                        try {
                            in = new ByteArrayInputStream(xmlResponse.getBytes("utf-8"));
                            XMLDecoder decoder = new XMLDecoder(in);
                            HashMap responseMap = (HashMap)decoder.readObject();
                            if (responseMap == null) {
                                log.warning("XMLDecoder could not get the logout HashMap!");
                                break block15;
                            }
                            log.info("Received a new logout response.");
                            if (responseMap.isEmpty()) {
                                log.warning("Logout Response (HashMap) does not contain any data.");
                                break block15;
                            }
                            if (!responseMap.containsKey("LogoutSuccessful")) break block15;
                            boolean logoutSuccess = (Boolean)responseMap.get("LogoutSuccessful");
                            if (logoutSuccess) {
                                log.info("Successfully logged out map client from server.");
                                break block15;
                            }
                            log.warning("Logging out map client from server failed.");
                        }
                        catch (Exception ex) {
                            try {
                                log.log(Level.WARNING, "Could not deserialize logout response", ex);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block14;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Logout for map runs into", ex);
                }
            }
        }
        this._stopPushConnection();
        this.dataStorageProxy.setConnectionStatus(CommunicationConstants.ConnectionStatus.NOT_CONNECTED);
        this.lastSuccessfulConnect = 0L;
        this.servletParameters = null;
        this.connectionStatistics.reset();
        this.server.resetServerTime();
    }

    @Override
    public void update(Observable o, Object arg) {
        Parameter param;
        if (arg != null && arg instanceof Parameter && (param = (Parameter)arg).equals(ConfigurationParameters.PARAM_UNIT_LOCAL_KEEPALIVE_TIMEOUT)) {
            long keepaliveTimeout;
            long customKeepaliveTimeout = (Long)this.configuration.getValue(ConfigurationParameters.PARAM_UNIT_LOCAL_KEEPALIVE_TIMEOUT);
            if (customKeepaliveTimeout > 0L) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Custom keepalive timeout found of {1} minutes found", customKeepaliveTimeout);
                }
                keepaliveTimeout = customKeepaliveTimeout * 60L * 1000L;
            } else {
                if (log.isLoggable(Level.INFO)) {
                    log.info("No custom keepalive timeout found, use server-side definition");
                }
                keepaliveTimeout = (Long)this.configuration.getValue(ConfigurationParameters.PARAM_TEMP_SERVER_INFOMAN_KEEPALIVE_TIMEOUT);
            }
            this.configuration.setValue(ConfigurationParameters.PARAM_TEMP_KEEPALIVE_TIMEOUT, (Object)keepaliveTimeout);
        }
    }

    private synchronized void updateAllStandsData(Map<String, Map<String, Object>> allStandEventsMap) {
        String method = "updateAllStandsData(): ";
        this.updateServerConfiguration(allStandEventsMap);
        Map<String, Object> tmpllStandsData = allStandEventsMap.get("ALL_STANDS");
        ExtConcurrentHashMap receivedStandsData = tmpllStandsData != null && tmpllStandsData instanceof Map ? new ExtConcurrentHashMap(tmpllStandsData) : new ExtConcurrentHashMap();
        if (receivedStandsData.isEmpty()) {
            log.log(Level.WARNING, "{0}received empty stands list from server.", method);
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}received a new complete stands list from observer. (size {1})", new Object[]{method, receivedStandsData.size()});
        }
        ArrayList<Map> dataList = new ArrayList<Map>();
        for (String standId : receivedStandsData.keySet()) {
            Map standData = (Map)receivedStandsData.get((Object)standId);
            dataList.add(standData);
        }
        this.dataStorageProxy.setData(DataStorage.DataType.STAND, dataList);
        this.connectionStatistics.addAllStandsEvent();
    }

    private synchronized void updateAllUnitsData(Map allUnitEventsMap) {
        String method = "updateAllUnitsData(): ";
        this.updateServerConfiguration(allUnitEventsMap);
        Map<String, Map<String, String>> requestedSchemas = this.mapAdapter.getXMLSchemasMap();
        Iterator<String> schemasIte = requestedSchemas.keySet().iterator();
        while (schemasIte.hasNext()) {
            String xml = null;
            String schema = schemasIte.next();
            if (allUnitEventsMap.containsKey(schema)) {
                xml = (String)allUnitEventsMap.get(schema);
            }
            if (xml != null) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "{0}Got xml schema ''{1}''", new Object[]{method, schema});
                }
                if (schema.equals("http://proveo.de/xml/fleet-management/statemodel-1.0")) {
                    this.dataStorageProxy.updateStatusModels(xml);
                    continue;
                }
                if (schema.equals("http://proveo.de/xml/fleet-management/statemodel-layer-mapping-1.0")) {
                    this.dataStorageProxy.updateStatusModelSVGMapping(xml);
                    continue;
                }
                if (schema.equals("http://proveo.de/xml/fleet-management/measurement-1.0")) {
                    this.dataStorageProxy.updateMeasurements(xml);
                    continue;
                }
                log.log(Level.WARNING, "Received xml for unknown schema: {0}", schema);
                continue;
            }
            log.log(Level.WARNING, "{0}bulk data does not contain xml for schema ''{1}''", new Object[]{method, schema});
        }
        Object tmpAllStamps = allUnitEventsMap.get("Stamps");
        ExtConcurrentHashMap receivedUnitData = tmpAllStamps != null && tmpAllStamps instanceof Map ? new ExtConcurrentHashMap((Map)tmpAllStamps) : new ExtConcurrentHashMap();
        String unitTreeXML = (String)allUnitEventsMap.get("unitTreeXML");
        if (unitTreeXML != null) {
            List unitData;
            Map unitTreeMap = DataPreparationUtil.createUnitTreeMapFromXml((String)unitTreeXML);
            if (unitTreeMap != null && (unitData = this.dataStorageProxy.getDataStorage().getBulkData(DataStorage.DataType.UNIT)) != null && !unitData.isEmpty()) {
                this.dataStorageProxy.fireTreeUpdated(unitTreeMap);
            }
        } else {
            log.log(Level.WARNING, "{0}bulk data does not contain an unit tree.", method);
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "{0}received data for {1} units.", new Object[]{method, receivedUnitData.size()});
        }
        ArrayList<ExtConcurrentHashMap> unitDataList = new ArrayList<ExtConcurrentHashMap>();
        for (Long unitId : receivedUnitData.keySet()) {
            Map unitData = (Map)receivedUnitData.get((Object)unitId);
            long stampUnitId = MapClientStampUtil.getUnitId((Map)unitData);
            if (stampUnitId != unitId) {
                log.log(Level.WARNING, "{0}Unit ID in data and the one given as the key are not the same!!! Data={1}/Key={2}. Unit data will not be added to complete data!", new Object[]{method, stampUnitId, unitId});
                continue;
            }
            TreeMap stampNotifies = DataPreparationUtil.prepareNotifyEvents((long)unitId, (Map)unitData);
            MapClientStampUtil.setNotifys((Map)unitData, (Map)stampNotifies);
            unitDataList.add(new ExtConcurrentHashMap(unitData));
        }
        receivedUnitData.clear();
        this.dataStorageProxy.setData(DataStorage.DataType.UNIT, unitDataList);
        this.connectionStatistics.addAllUnitsEvent();
    }

    private synchronized void updateGeneralErrors(Map eventMap) {
        this.dataStorageProxy.updateData(DataStorage.DataType.SERVER_ERROR_MSG, eventMap);
        this.connectionStatistics.addGeneralErrorEvent();
    }

    private synchronized void updateServerConfiguration(Map bulkDataMap) {
        long observableNotifiesMaximumPerUnitPerDay;
        long keepaliveTimeout;
        long serversideKeepaliveTimeout;
        String method = "updateServerConfiguration(): ";
        if (bulkDataMap.containsKey("RTS_Version")) {
            this.connectionStatistics.setServerVersion((String)bulkDataMap.get("RTS_Version"));
        }
        if (bulkDataMap.containsKey("Java_Version")) {
            this.connectionStatistics.setServerJavaVersion((String)bulkDataMap.get("Java_Version"));
        }
        if (bulkDataMap.containsKey("ServerInfomanKeepaliveTimeout")) {
            serversideKeepaliveTimeout = (Long)bulkDataMap.get("ServerInfomanKeepaliveTimeout");
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "{0}eventMap of all units contains server-side infomanKeepaliveTimeout definition: {1}", new Object[]{method, serversideKeepaliveTimeout});
            }
        } else {
            log.log(Level.WARNING, "{0}eventMap of all units does not contain server-side infomanKeepaliveTimeout definition!", method);
            serversideKeepaliveTimeout = 10800000L;
        }
        this.configuration.setValue(ConfigurationParameters.PARAM_TEMP_SERVER_INFOMAN_KEEPALIVE_TIMEOUT, (Object)serversideKeepaliveTimeout);
        long customKeepaliveTimeout = (Long)this.configuration.getValue(ConfigurationParameters.PARAM_UNIT_LOCAL_KEEPALIVE_TIMEOUT);
        if (customKeepaliveTimeout > 0L) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "{0}custom keepalive timeout found of {1} minutes found", new Object[]{method, customKeepaliveTimeout});
            }
            keepaliveTimeout = customKeepaliveTimeout * 60L * 1000L;
        } else {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "{0}no custom keepalive timeout found, use server-side definition", method);
            }
            keepaliveTimeout = serversideKeepaliveTimeout;
        }
        this.configuration.setValue(ConfigurationParameters.PARAM_TEMP_KEEPALIVE_TIMEOUT, (Object)keepaliveTimeout);
        if (bulkDataMap.containsKey("ServerObservableNotifiesMaximumPerUnitPerDay")) {
            observableNotifiesMaximumPerUnitPerDay = ((Integer)bulkDataMap.get("ServerObservableNotifiesMaximumPerUnitPerDay")).intValue();
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "{0}eventMap of all units contains observable notifies maximumPerUnitPerDay definition: {1}", new Object[]{method, observableNotifiesMaximumPerUnitPerDay});
            }
        } else {
            log.log(Level.WARNING, "{0}eventMap of all units does not contain observable notifies maximumPerUnitPerDay definition!", method);
            observableNotifiesMaximumPerUnitPerDay = (Long)ConfigurationParameters.PARAM_TEMP_SERVER_OBSERVABLE_NOTIFIES_MAXIMUM_PER_UNIT_PER_DAY.getDefaultValue();
        }
        this.configuration.setValue(ConfigurationParameters.PARAM_TEMP_SERVER_OBSERVABLE_NOTIFIES_MAXIMUM_PER_UNIT_PER_DAY, (Object)observableNotifiesMaximumPerUnitPerDay);
    }

    private synchronized void updateServerMessages(Map eventMap) {
        String method = "updateServerMessages(): ";
        if (!eventMap.containsKey("ServerMessage")) {
            log.log(Level.WARNING, "{0}received event type 'SERVER_MESSAGE' does not contain key ''{1}''! Break.", new Object[]{method, "ServerMessage"});
            return;
        }
        this.dataStorageProxy.updateData(DataStorage.DataType.SERVER_ERROR_MSG, eventMap);
        this.connectionStatistics.addServerMessageEvent();
    }

    private synchronized void updateSingleStandData(Map eventMap) {
        String method = "updateSingleStandData(): ";
        this.dataStorageProxy.updateData(DataStorage.DataType.STAND, eventMap);
        this.connectionStatistics.addSingleStandEvent();
    }

    private void updateSingleUnitBulkEvent(Map eventMap) {
        String method = "updateSingleUnitBulkEvent(): ";
        Map dataMap = (Map)eventMap.get("Stamp");
        if (dataMap != null) {
            if (dataMap.get("EventType") == null) {
                dataMap.put("EventType", "unit");
            }
            this.updateSingleUnitEvent(dataMap);
        } else {
            Long unitId = null;
            Object tmp = eventMap.get("UnitId");
            if (tmp != null) {
                unitId = (Long)tmp;
            }
            log.log(Level.INFO, "{0}received single unit bulk event does not contain data! Removing unit with unitId ''{1}'' ...", new Object[]{method, unitId});
            if (unitId != null) {
                this.dataStorageProxy.removeDataByIdentifier(DataStorage.DataType.UNIT, Long.toString(unitId));
                this.connectionStatistics.addSingleUnitEvent();
            } else {
                log.log(Level.WARNING, "{0}Could not remove single unit, because no unitId in stamp found!", method);
            }
        }
        String unitTreeXML = (String)eventMap.get("unitTreeXML");
        if (unitTreeXML != null) {
            List unitData;
            Map unitTreeMap = DataPreparationUtil.createUnitTreeMapFromXml((String)unitTreeXML);
            if (unitTreeMap != null && (unitData = this.dataStorageProxy.getDataStorage().getBulkData(DataStorage.DataType.UNIT)) != null && !unitData.isEmpty()) {
                this.dataStorageProxy.fireTreeUpdated(unitTreeMap);
            }
        } else {
            log.log(Level.WARNING, "{0}single unit bulk event does not contain an unit tree!", method);
        }
    }

    private void updateSingleUnitEvent(Map eventMap) {
        String method = "updateSingleUnitEvent(): ";
        String eventType = (String)eventMap.get("EventType");
        if (eventType == null) {
            log.log(Level.WARNING, "{0}received single event does not contain an event type!", method);
            return;
        }
        boolean notifyEvent = eventType.equals("data_type_notification_event");
        if (notifyEvent) {
            eventMap = DataPreparationUtil.prepareNotifyEvent((Map)eventMap);
            this.connectionStatistics.addInfomanAlertEvent();
        }
        this.dataStorageProxy.updateData(DataStorage.DataType.UNIT, eventMap);
        this.connectionStatistics.addSingleUnitEvent();
    }
}

