/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl.push;

import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import de.proveo.idm.remote.server.communication.api.CommunicationConstants;
import de.proveo.idm.remote.server.efm4_6.impl.push.PushConnectionImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientConnectionWatchdog
extends Thread
implements ClientWatchdog,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(ClientConnectionWatchdog.class.getName());
    private static final long EXPECTED_PING_RECEIVE_TIME = 30000L;
    private static final long DEFAULT_CHECK_INTERVAL = 60000L;
    private static final long DEFAULT_CONNECTION_TIMEOUT = 90000L;
    private final Object lock = new Object();
    private long checkInterval = 60000L;
    private long connectionTimeout = 90000L;
    private volatile boolean shouldStop = false;
    private volatile boolean idling = false;
    private long lastEventReceived = -1L;
    private PushConnectionImpl pushConnection;

    public ClientConnectionWatchdog(PushConnectionImpl pushConnection) {
        super("ClientConnectionWatchdog");
        this.pushConnection = pushConnection;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("DataStorageImpl.connectionStatus".equals(propName)) {
            CommunicationConstants.ConnectionStatus connectionStatus = CommunicationConstants.ConnectionStatus.NOT_CONNECTED;
            Object newVal = evt.getNewValue();
            if (newVal != null) {
                try {
                    connectionStatus = CommunicationConstants.ConnectionStatus.valueOf((String)newVal.toString());
                }
                catch (Exception ex) {
                    connectionStatus = CommunicationConstants.ConnectionStatus.NOT_CONNECTED;
                }
            }
            if (CommunicationConstants.ConnectionStatus.CONNECTED.equals((Object)connectionStatus)) {
                this.lastEventReceived = System.currentTimeMillis();
            }
        }
    }

    public void onPingReceived(long timestamp) {
        if (this.shouldStop || !this.isAlive() || this.isInterrupted()) {
            return;
        }
        this.lastEventReceived = timestamp;
        this.pushConnection.getConnectionStatistics().addPingEvent();
    }

    public void onEventReceived(long timestamp) {
        if (this.shouldStop || !this.isAlive() || this.isInterrupted()) {
            return;
        }
        this.lastEventReceived = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionError(Throwable ex) {
        if (this.shouldStop || !this.isAlive() || this.isInterrupted()) {
            return;
        }
        log.log(Level.WARNING, "Will reconnect, because connection runs into", ex);
        Object object = this.lock;
        synchronized (object) {
            this.idling = true;
        }
        log.info("Reconnect polling ...");
        this.pushConnection.reconnectPushConnection();
        log.info("Polling reconnected.");
        object = this.lock;
        synchronized (object) {
            this.idling = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMissingEvent() {
        if (this.shouldStop || !this.isAlive() || this.isInterrupted()) {
            return;
        }
        log.warning("Will reconnect, because of an missing event!");
        Object object = this.lock;
        synchronized (object) {
            this.idling = true;
        }
        log.info("Reconnect polling ...");
        this.pushConnection.reconnectPushConnection();
        log.info("Polling reconnected.");
        object = this.lock;
        synchronized (object) {
            this.idling = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean force) {
        this.shouldStop = true;
        if (!this.idling) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        if (force) {
            this.interrupt();
        }
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String method = this.getName() + ".run(): ";
        log.log(Level.INFO, "{0} started.", method);
        this.shouldStop = false;
        while (!this.shouldStop) {
            try {
                boolean i;
                Thread.sleep(this.checkInterval);
                Object object = this.lock;
                synchronized (object) {
                    i = this.idling;
                }
                if (!i) {
                    this.checkConnection();
                    continue;
                }
                object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException ie) {
                log.log(Level.INFO, method + "Watchdog runs while sleeping or waiting into", ie);
            }
        }
        log.log(Level.INFO, "{0}was stopped.", method);
    }

    private void checkConnection() {
        String method = "checkConnection(): ";
        if (this.shouldStop || !this.isAlive() || this.isInterrupted()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.lastEventReceived != -1L && now - this.lastEventReceived > this.connectionTimeout) {
            log.log(Level.WARNING, "{0}Connection inactive! Last Ping was {1}s ago! Perform reconnect ...", new Object[]{method, (now - this.lastEventReceived) / 1000L});
            this.pushConnection.reconnectPushConnection();
            log.info("Reconnect performed.");
        }
    }
}

