/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.idm.remote.server.communication.api.ClientListener;
import de.proveo.idm.remote.server.communication.api.ConnectionStatistics;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteMapAdapterImpl;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayClientListener
implements ClientListener {
    private static final Log log = LogFactory.getLog(ReplayClientListener.class);
    private RemoteMapAdapterImpl remoteMapAdapter;
    private ConnectionStatistics connectionStatistics;

    public ReplayClientListener(RemoteMapAdapterImpl remoteMapAdapter, ConnectionStatistics connectionStatistics) {
        this.remoteMapAdapter = remoteMapAdapter;
        this.connectionStatistics = connectionStatistics;
    }

    public void onEvent(Map eventMap) {
        log.info((Object)"Received replay data.");
        this.remoteMapAdapter.setReplayData(eventMap);
    }

    public void onServerTime(long serverTime) {
        this.remoteMapAdapter.getServer().updateServerTime(serverTime);
        if (this.connectionStatistics != null) {
            this.connectionStatistics.addPingEvent();
        }
    }
}

