/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.remote.server.api.RemoteOperatorAdapter;
import de.proveo.idm.remote.server.efm4_6.impl.EFMServer4_6;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteMapAdapterImpl;
import de.proveo.util.useuser.LicenseBean;
import de.proveo.util.useuser.LicenseTypeBean;
import de.proveo.util.useuser.UseUserTreeNodeBean;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class RemoteOperatorAdapterImpl
implements RemoteOperatorAdapter {
    private static final Logger log = Logger.getLogger(RemoteOperatorAdapterImpl.class.getName());
    private EFMServer4_6 server;

    public RemoteOperatorAdapterImpl(EFMServer4_6 server) {
        this.server = server;
    }

    public UseUserTreeNodeBean getOperators() throws Exception {
        return this.server.getUseUserWebService().getAllUseUsers();
    }

    public UseUserTreeNodeBean getOperatorById(long operatorId) throws Exception {
        return this.server.getUseUserWebService().getUseUserById(operatorId);
    }

    public void deleteLicense(int licenseId) throws Exception {
        this.server.getUseUserWebService().deleteLicense(licenseId);
    }

    public void createLicenseForOperator(long useUserId, LicenseBean licenseBean) throws Exception {
        this.server.getUseUserWebService().createLicenseForUseUser(useUserId, licenseBean);
    }

    public void drawLicense(LicenseBean license) throws Exception {
        license.setRevoked(true);
        this.server.getUseUserWebService().updateLicense(license);
    }

    public List<LicenseTypeBean> getLicenseTypes() throws Exception {
        return this.server.getUseUserWebService().getLicenseTypes();
    }

    public void createOperator(UseUserTreeNodeBean useUser, long useUserGroupId) throws Exception {
        this.server.getUseUserWebService().createUseUser(useUser, useUserGroupId);
    }

    public void deleteOperator(long operatorId) throws Exception {
        this.server.getUseUserWebService().deleteUseUser(operatorId);
    }

    public void createOperatorGroup(UseUserTreeNodeBean useUserGroup) throws Exception {
        this.server.getUseUserWebService().createUseUserGroup(useUserGroup);
    }

    public void deleteOperatorGroup(long useUserGroupId) throws Exception {
        this.server.getUseUserWebService().deleteUseGroup(useUserGroupId);
    }

    public void editOperator(UseUserTreeNodeBean useUser) throws Exception {
        this.server.getUseUserWebService().updateUseUser(useUser);
    }

    public void editOperatorGroup(UseUserTreeNodeBean useUserGroup) throws Exception {
        this.server.getUseUserWebService().updateUseGroup(useUserGroup);
    }

    public void insertOperatorIntoGroup(long useUserId, long groupId) throws Exception {
        this.server.getUseUserWebService().setUseUserIntoGroup(useUserId, groupId);
    }

    public void removeOperatorFromGroup(long useUserId, long groupId) throws Exception {
        this.server.getUseUserWebService().deleteUseUserFromGroup(useUserId, groupId);
    }

    public String validateUseUser(UseUserTreeNodeBean useUser, boolean update) throws Exception {
        String result;
        if (this.isCapabilityFullfilled(this.server.getCapabilities())) {
            result = this.server.getUseUserWebService().validateUseUser(useUser, update);
        } else {
            UseUserTreeNodeBean node = this.server.getUseUserWebService().getAllUseUsers();
            result = this.validate(node, useUser, update);
        }
        result = this.getUseUserMessage(result, useUser);
        return result;
    }

    private String getUseUserMessage(String message, UseUserTreeNodeBean node) {
        if (message == null) {
            return null;
        }
        if ("name".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_NAME") + " " + node.getName();
        }
        if ("personalNumber".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_PERS_NUMBER") + " " + node.getPersonnelNo();
        }
        if ("personalNumberDeleted".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_PERS_NUMBER_DELETED") + " " + node.getPersonnelNo();
        }
        if ("key".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_USE_USER_KEY") + " " + node.getKeyId();
        }
        if ("keyDeleted".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_USE_USER_KEY_DELETED") + " " + node.getKeyId();
        }
        if ("keyName".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_KEY_AND_NAME") + " " + node.getName() + " " + node.getKeyId();
        }
        if ("keyNameDeleted".equals(message)) {
            return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.DUPLICATED_KEY_AND_NAME_DELETED") + " " + node.getName() + " " + node.getKeyId();
        }
        return NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteOperatorAdapterImpl.UNKNOWN");
    }

    private boolean isCapabilityFullfilled(Collection<Capability> capabilities) {
        return capabilities != null && capabilities.contains(Capability.USEUSER_VALIDATION);
    }

    private String validate(UseUserTreeNodeBean node, UseUserTreeNodeBean check, boolean update) {
        if (node == null) {
            return null;
        }
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            return this.compare(node, check, update);
        }
        for (UseUserTreeNodeBean nodeBuffer : node.getChildren()) {
            String res = this.validate(nodeBuffer, check, update);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private String compare(UseUserTreeNodeBean node1, UseUserTreeNodeBean node2, boolean update) {
        if (update && node1.getId() == node2.getId()) {
            return null;
        }
        if (node1.getName() != null && node1.getName().equals(node2.getName())) {
            return "name";
        }
        if (node1.getPersonnelNo() != null && node1.getPersonnelNo().equals(node2.getPersonnelNo())) {
            return "personalNumber";
        }
        if (node1.getKeyId() != null && node1.getKeyId().equals(node2.getKeyId())) {
            return "key";
        }
        return null;
    }
}

