/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.idm.core.gui.navigation.api.Connectable;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.exceptions.NotConnectedException;
import de.proveo.idm.core.gui.navigation.api.exceptions.VersionNotPresentException;
import de.proveo.idm.remote.server.api.AbstractRemoteInfoman;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.impl.RemoteDeviceIdImpl;
import de.proveo.idm.remote.server.efm4_6.impl.EFMServer4_6;
import de.proveo.idm.remote.server.efm4_6.impl.InfomanSetupValueAdapter;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class RemoteInfomanImpl
extends AbstractRemoteInfoman
implements Connectable {
    private EFMServer4_6 server;

    public RemoteInfomanImpl(EFMServer4_6 server, long unitId, String name, String serialNo, Device.DeviceType deviceType) {
        super(name);
        this.server = server;
        this.deviceType = deviceType;
        this.id = new RemoteDeviceIdImpl(unitId, serialNo);
    }

    public AbstractRemoteInfoman clone() throws CloneNotSupportedException {
        RemoteInfomanImpl clone = new RemoteInfomanImpl(this.server, this.getUnitId(), this.name, this.getSerialNumber(), this.getDeviceType());
        clone.actionPath = this.actionPath;
        clone.description = this.description;
        clone.iconBase = this.iconBase;
        return clone;
    }

    public synchronized SortedMap<String, Object> getEnv() throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        InfomanSetupValue value = this.getSetup();
        InfomanSetupValueAdapter adapter = new InfomanSetupValueAdapter(value);
        List<DatasyncMetainfoValue> metaInfos = adapter.getMetainfos();
        for (DatasyncMetainfoValue info : metaInfos) {
            map.put(info.getKey(), info.getValue());
        }
        return map;
    }

    public DatasyncResourceValue getConfiguration() throws Exception {
        return new InfomanSetupValueAdapter(this.getSetup());
    }

    public String getSoftwareVersion() throws NotConnectedException, VersionNotPresentException {
        try {
            String sv = this.getSetup().getSoftwareVersion();
            if (sv != null && StringUtils.startsWithIgnoreCase((CharSequence)sv, (CharSequence)"V")) {
                sv = StringUtils.removeStart((String)sv, (String)"V");
            }
            return sv;
        }
        catch (Exception ex) {
            throw new VersionNotPresentException("Could not fetch version of Infoman", (Throwable)ex);
        }
    }

    public EFMServer getServer() {
        return this.server;
    }

    private synchronized InfomanSetupValue getSetup() throws Exception {
        return this.server.getConfiguration(this.getUnitId());
    }

    public void forceACLUpdate() throws Exception {
        this.server.forceAclUpdate(this.getUnitId());
    }

    public String getIPAddress() throws Exception {
        return this.server.getIpAddress(this.getUnitId());
    }
}

