/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4_6.impl;

import com.jcraft.jsch.Session;
import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.domain.values.admin.ObjectNodeBean;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.EFMServerUnitAdministration;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteMapAdapter;
import de.proveo.idm.remote.server.api.RemoteOperatorAdapter;
import de.proveo.idm.remote.server.api.RemotePathAdapter;
import de.proveo.idm.remote.server.api.RemoteRoutingAdapter;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.api.impl.AbstractEFMServer;
import de.proveo.idm.remote.server.api.impl.HttpClient4Factory;
import de.proveo.idm.remote.server.api.impl.HttpClientFactory;
import de.proveo.idm.remote.server.api.impl.RemoteDeviceIdImpl;
import de.proveo.idm.remote.server.api.impl.ZeroConfUnitImpl;
import de.proveo.idm.remote.server.communication.api.ServerTime;
import de.proveo.idm.remote.server.efm4_6.impl.LoginResponseAdapter;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteInfomanImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteMapAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteOperatorAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemotePathAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteRoutingAdapterImpl;
import de.proveo.idm.remote.server.efm4_6.impl.RemoteUpdateAdapterImpl;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.util.connection.LoginResponse;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.rest.interfaces.ApplicationWebServiceClient;
import de.proveo.util.rest.interfaces.DatasyncWebServiceClient;
import de.proveo.util.rest.interfaces.PathWebServiceClient;
import de.proveo.util.rest.interfaces.RoutingWebServiceClient;
import de.proveo.util.rest.interfaces.UnitWebServiceClient;
import de.proveo.util.rest.interfaces.UseUserWebServiceClient;
import de.proveo.util.unit.tree.UnitTreeNodeBean;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallFactory;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCClient;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.openide.util.NbBundle;

public class EFMServer4_6
extends AbstractEFMServer {
    private static final Logger log = Logger.getLogger(EFMServer4_6.class.getName());
    private static final String ADMIN_INTERFACE = "/admin";
    private static final String DATASYNC_INTERFACE = "/datasync";
    private ServerTime serverTime = new ServerTime();
    private PathWebServiceClient pathWebService;
    private UnitWebServiceClient unitWebService = null;
    private UseUserWebServiceClient useUserWebService = null;
    private ApplicationWebServiceClient appWebService = null;
    private DatasyncWebServiceClient datasyncWebService = null;
    private RemoteOperatorAdapterImpl operatorAdapter;
    private RemotePathAdapterImpl pathAdapter;
    private RoutingWebServiceClient routingWebService = null;
    private RemoteUpdateAdapterImpl updateAdapter = null;
    private RemoteMapAdapterImpl mapAdapter = null;
    private RemoteRoutingAdapterImpl routingAdapter = null;
    private UnitAdminWrapper unitAdminWrapper = null;

    public EFMServer4_6(EFMServerData serverData) {
        super(serverData);
        this.capabilities.add(Capability.UNIT_OVERVIEW);
        this.capabilities.add(Capability.TASK_OVERVIEW);
        this.capabilities.add(Capability.RESOURCE_OVERVIEW);
        this.capabilities.add(Capability.SOFTWARE_OVERVIEW);
        this.capabilities.add(Capability.ZERO_CONF);
        this.capabilities.add(Capability.EDIT_CONFIGURATION);
        this.capabilities.add(Capability.UPDATE_SOFTWARE_FOR_DEVICE);
        this.capabilities.add(Capability.MANAGE_INFOMAN_CALLBACK);
        this.capabilities.add(Capability.INFOMAN_STATUS_PAGE);
        this.capabilities.add(Capability.MAPPING);
        this.capabilities.add(Capability.MAP_AREAS);
        this.capabilities.add(Capability.MAP_DATA);
        this.capabilities.add(Capability.MAP_REPLAY);
    }

    public SortedMap<String, String> getEnv() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UnitTreeElement getUnits() throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        UnitTreeNodeBean tree = null;
        try {
            tree = this.getUnitWebServiceClient().getInstalledUnits();
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
        }
        if (tree != null) {
            return this.createUnitTree(tree);
        }
        return null;
    }

    public long getServerTime() {
        return this.serverTime.getServerTime();
    }

    public String getTimeZoneID() {
        String timeZoneId;
        if (this.appWebService == null) {
            return TimeZone.getDefault().getID();
        }
        try {
            timeZoneId = this.appWebService.getTimeZoneID();
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "Failed to get timezone ID from server, connection seems to be broken, logging off", ex);
            this.logoff();
            timeZoneId = TimeZone.getDefault().getID();
        }
        return timeZoneId;
    }

    public List<ZeroConfUnit> getNotInstalledUnits() throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        ArrayList<ZeroConfUnit> zeroconfUnits = new ArrayList<ZeroConfUnit>();
        List list = null;
        try {
            list = this.getUnitWebServiceClient().getNotInstalledDevices();
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
        }
        if (list != null) {
            for (ObjectNodeBean node : list) {
                TreeMap attributes = new TreeMap(node.getAttributes());
                RemoteDeviceIdImpl id = new RemoteDeviceIdImpl((String)attributes.get("hardwareSerialNumber"));
                ZeroConfUnitImpl unit = new ZeroConfUnitImpl((EFMServer)this, (RemoteDeviceId)id, attributes);
                zeroconfUnits.add((ZeroConfUnit)unit);
            }
        }
        return zeroconfUnits;
    }

    public GPSPosition getZeroConfPositionById(int id) throws Exception {
        EFMServer4_6.checkLogin(this.getUnitWebServiceClient());
        if (this.capabilities != null && this.capabilities.contains(Capability.NOT_INSTALLED_POSITIONS)) {
            ObjectNodeBean node = null;
            try {
                node = this.getUnitWebServiceClient().getNotInstalledUnitById(id);
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Lost connection to server", ex);
                this.logoff();
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            }
            if (node != null) {
                TreeMap attributes = new TreeMap(node.getAttributes());
                String gga = (String)attributes.get("ggaRec");
                String rmc = (String)attributes.get("rmcRec");
                if (gga != null && gga.startsWith("$GPGGA")) {
                    return new GPSPosition(rmc, gga);
                }
            }
        }
        return null;
    }

    public RemoteMapAdapter getRemoteMapAdapter() {
        if (this.mapAdapter == null) {
            this.mapAdapter = new RemoteMapAdapterImpl(this);
        }
        return this.mapAdapter;
    }

    public RemoteRoutingAdapter getRemoteRoutingAdapter() {
        if (this.routingAdapter == null) {
            this.routingAdapter = new RemoteRoutingAdapterImpl(this);
        }
        return this.routingAdapter;
    }

    public RemoteUpdateAdapter getRemoteUpdateAdapter() {
        if (this.updateAdapter == null) {
            this.updateAdapter = new RemoteUpdateAdapterImpl(this, this.loginCredentials);
        }
        return this.updateAdapter;
    }

    public RemoteOperatorAdapter getRemoteOperatorAdapter() {
        if (this.operatorAdapter == null) {
            this.operatorAdapter = new RemoteOperatorAdapterImpl(this);
        }
        return this.operatorAdapter;
    }

    public RemotePathAdapter getRemotePathAdapter() {
        if (this.pathAdapter == null) {
            this.pathAdapter = new RemotePathAdapterImpl(this);
        }
        return this.pathAdapter;
    }

    protected UnitWebServiceClient getUnitWebServiceClient() throws Exception {
        return this.unitWebService;
    }

    protected UseUserWebServiceClient getUseUserWebService() {
        return this.useUserWebService;
    }

    protected DatasyncWebServiceClient getDatasyncWebServiceClient() {
        return this.datasyncWebService;
    }

    protected RoutingWebServiceClient getRoutingWebService() {
        return this.routingWebService;
    }

    protected PathWebServiceClient getPathWebServiceClient() {
        return this.pathWebService;
    }

    public synchronized IDMLoginResponse login(Credentials credentials) throws Exception {
        this.loginCredentials = credentials;
        if (this.loginCredentials == null) {
            return null;
        }
        URL connectionURL = this.getConnectionURL();
        org.apache.http.client.HttpClient client = HttpClient4Factory.createHttpsClient((URL)connectionURL, (Credentials)this.loginCredentials);
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine(client);
        ResteasyClient restClient = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        ResteasyWebTarget targetAdmin = restClient.target(connectionURL.toString() + ADMIN_INTERFACE);
        ResteasyWebTarget targetDatasync = restClient.target(connectionURL.toString() + DATASYNC_INTERFACE);
        this.routingWebService = (RoutingWebServiceClient)targetAdmin.proxy(RoutingWebServiceClient.class);
        this.unitWebService = (UnitWebServiceClient)targetAdmin.proxy(UnitWebServiceClient.class);
        this.appWebService = (ApplicationWebServiceClient)targetAdmin.proxy(ApplicationWebServiceClient.class);
        this.useUserWebService = (UseUserWebServiceClient)targetAdmin.proxy(UseUserWebServiceClient.class);
        this.routingWebService = (RoutingWebServiceClient)targetAdmin.proxy(RoutingWebServiceClient.class);
        this.pathWebService = (PathWebServiceClient)targetAdmin.proxy(PathWebServiceClient.class);
        this.datasyncWebService = (DatasyncWebServiceClient)targetDatasync.proxy(DatasyncWebServiceClient.class);
        if (this.unitWebService != null && this.datasyncWebService != null && this.appWebService != null) {
            char[] passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(this.loginCredentials.getPassword())).toCharArray();
            HashMap<String, Object> callValues = new HashMap<String, Object>();
            callValues.put("username", this.loginCredentials.getUsername());
            callValues.put("password", passwordHash);
            LoginResponse response = (LoginResponse)this.executeCall("Login", callValues);
            if (log.isLoggable(Level.FINE)) {
                ToStringBuilder dump = new ToStringBuilder((Object)response);
                dump.append("accessPermitted", response.isAccessPermitted());
                dump.append("firstName", (Object)response.getFirstName());
                dump.append("lastName", (Object)response.getLastName());
                dump.append("username", (Object)response.getUsername());
                dump.append("portalPermissions", (Object)response.getPortalPermissions());
                log.log(Level.FINE, "login() {0}", dump.toString());
            }
            this.loginResponse = new LoginResponseAdapter(response);
            boolean supportsAdditionalFeatures = false;
            if (this.useUserWebService != null) {
                try {
                    this.useUserWebService.getLicenseTypes();
                    supportsAdditionalFeatures = true;
                }
                catch (Exception ex) {
                    supportsAdditionalFeatures = false;
                }
            }
            if (supportsAdditionalFeatures) {
                this.capabilities.add(Capability.OPERATOR_OVERVIEW);
                this.capabilities.add(Capability.CANCEL_TASK);
                this.capabilities.add(Capability.EDIT_TASK);
                this.capabilities.add(Capability.CREATE_BATCH_TASK);
                this.capabilities.add(Capability.UPLOAD_RESOURCE);
            }
            if (this.routingWebService != null) {
                try {
                    this.routingWebService.isAlive();
                    this.capabilities.add(Capability.ROUTING);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            boolean accessPermitted = true;
            try {
                this.unitWebService.getAvailableSoftware();
            }
            catch (ClientResponseFailure ex) {
                ClientResponse resp = ex.getResponse();
                int status = resp.getStatus();
                if (status != 200) {
                    accessPermitted = false;
                }
            }
            catch (Throwable ex) {
                log.log(Level.INFO, "Login runs into", ex);
                accessPermitted = false;
            }
            if (this.loginResponse.isAccessPermitted() != accessPermitted) {
                log.log(Level.WARNING, "Login via REST and XML-RPC differ: REST={0} XML-RPC={1}", new Object[]{accessPermitted, this.loginResponse.isAccessPermitted()});
                accessPermitted = false;
            }
            this.loginResponse.setAccessPermitted(accessPermitted);
            this.unitAdminWrapper = new UnitAdminWrapper(this.unitWebService);
        }
        if (this.loginResponse.isAccessPermitted()) {
            Configuration configuration = this.getConfigurationProvider().getActiveConfiguration();
            long applicationStartTime = System.currentTimeMillis();
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_VERSION, (Object)NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString("CTL_MainWindow_Title"));
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_START_TIME, (Object)applicationStartTime);
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_OS_NAME, (Object)(System.getProperty(ConfigurationParameters.PARAM_TEMP_OS_NAME.getKey()) + ", " + System.getProperty("os.version")));
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_OS_USER_NAME, (Object)System.getProperty("user.name"));
            InetAddress i = null;
            try {
                i = InetAddress.getLocalHost();
                configuration.setValue(ConfigurationParameters.PARAM_TEMP_OS_HOST_NAME, (Object)i.getHostName());
            }
            catch (UnknownHostException ex) {
                log.log(Level.WARNING, "Couldn't get local host network information!", ex);
            }
            log.log(Level.INFO, "hostname/IP={0}", i);
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_JAVA_RUNTIME_VERSION, (Object)System.getProperty(ConfigurationParameters.PARAM_TEMP_JAVA_RUNTIME_VERSION.getKey()));
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_JAVA_HOME, (Object)System.getProperty(ConfigurationParameters.PARAM_TEMP_JAVA_HOME.getKey()));
            String starttimeString = "[START_TIME]";
            long starttime = (Long)configuration.getValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_START_TIME);
            if (starttime > 0L) {
                starttimeString = Long.toString(starttime);
            }
            String wwtClientId = (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_OS_HOST_NAME) + "_";
            wwtClientId = wwtClientId + (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_OS_USER_NAME) + "_";
            wwtClientId = wwtClientId + starttimeString;
            configuration.setValue(ConfigurationParameters.PARAM_TEMP_WWT_CLIENT_ID, (Object)wwtClientId);
            if (this.pathWebService != null) {
                try {
                    this.pathWebService.getGraphs();
                    this.capabilities.add(Capability.WAY_PATH);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (VersionsCompareUtil.isVersionGreater((String)this.appWebService.getVersion(), (String)"4.8.0-dev")) {
                    this.capabilities.add(Capability.INFOMANEFM_CONFIG_UPDATE);
                }
            }
            if (VersionsCompareUtil.isVersionGreater((String)this.appWebService.getVersion(), (String)"4.8.1")) {
                this.capabilities.add(Capability.NOT_INSTALLED_POSITIONS);
            }
            if (VersionsCompareUtil.isVersionGreater((String)this.appWebService.getVersion(), (String)"4.8.9")) {
                this.capabilities.add(Capability.USEUSER_VALIDATION);
            }
        }
        return this.loginResponse;
    }

    @Deprecated
    protected Object executeCall(String method, Map<String, Object> callValues) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Object value = null;
        try {
            ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(thisLoader);
            URL connectionURL = this.getConnectionURL();
            String uriPath = "datain/simpleXML-RPC";
            String uriString = (connectionURL.toString().endsWith("/") ? connectionURL.toString() : connectionURL.toString() + "/") + uriPath;
            SimpleXMLRPCClient client = new SimpleXMLRPCClient(uriString);
            HttpClient httpClient = client.getHttpClient();
            HttpClientFactory.configureHttpClient((HttpClient)httpClient, (String)connectionURL.getProtocol(), (String)connectionURL.getHost(), (int)connectionURL.getPort(), (int)this.serverURL.getPort(), (String)uriPath, (int)60000, (int)60000);
            client.setRequestCompression(false);
            client.setAcceptCompression(false);
            SimpleXMLRPCCall call = SimpleXMLRPCCallFactory.createCall();
            call.setMethod(method);
            for (String key : callValues.keySet()) {
                call.addParameter(key, callValues.get(key));
            }
            value = client.execute(call);
        }
        catch (ConnectTimeoutException ex) {
            ConnectException e = new ConnectException(ex.getMessage());
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        finally {
            if (original != null) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return value;
    }

    public synchronized void logoff() {
        super.logoff();
        this.updateAdapter = null;
        this.mapAdapter = null;
        this.datasyncWebService = null;
        this.unitWebService = null;
        this.useUserWebService = null;
        this.appWebService = null;
        this.routingWebService = null;
    }

    protected UnitTreeElement createUnitTree(UnitTreeNodeBean unitNode) {
        UnitTreeElement parent;
        if (!unitNode.isBasic()) {
            String unitName = unitNode.getUnitName();
            parent = new UnitTreeElement((Object)unitName);
            List children = unitNode.getChildren();
            if (children != null) {
                ArrayList<UnitTreeElement> group = new ArrayList<UnitTreeElement>();
                for (UnitTreeNodeBean childUnitNode : children) {
                    UnitTreeElement childTreeNode = this.createUnitTree(childUnitNode);
                    group.add(childTreeNode);
                }
                parent.setChildren(group);
            }
        } else {
            String serialNo = unitNode.getSerial();
            serialNo = serialNo == null ? "" : serialNo.trim();
            String devType = unitNode.getDeviceType();
            Device.DeviceType deviceType = Device.DeviceType.nameOf((String)(devType = devType == null ? "" : devType.trim()));
            if (deviceType == null) {
                deviceType = Device.DeviceType.INFOMAN;
            }
            RemoteInfomanImpl infoman = new RemoteInfomanImpl(this, unitNode.getUnitId(), unitNode.getUnitName(), serialNo, deviceType);
            String icon = UnitTreeElement.lookupIconBase(EFMServer4_6.class, (String)unitNode.getImageName(), (Device.DeviceType)deviceType);
            parent = new UnitTreeElement((Object)infoman, icon);
            this.units.add(infoman);
        }
        return parent;
    }

    private static void checkLogin(UnitWebServiceClient client) throws IllegalStateException {
        if (client == null) {
            throw new IllegalStateException("Client is null! Perform a login first");
        }
    }

    public String getURL() {
        URL url;
        try {
            url = this.getConnectionURL();
        }
        catch (Exception ex) {
            url = null;
        }
        if (url != null) {
            return url.toString();
        }
        return "";
    }

    public EFMServerUnitAdministration getUnitAdministration() {
        return this.unitAdminWrapper;
    }

    public String getUnitPosition(long unitId) throws Exception {
        try {
            return this.getUnitWebServiceClient().getUnitPosition(unitId);
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            throw ex;
        }
    }

    public boolean isUnitVisibleOnMap(long unitId) throws Exception {
        try {
            return Boolean.parseBoolean(this.getUnitWebServiceClient().isUnitVisibleOnMap(unitId));
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            throw ex;
        }
    }

    public InfomanSetupValue getConfiguration(long unitId) throws Exception {
        try {
            return this.getUnitWebServiceClient().getConfiguration(unitId);
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            throw ex;
        }
    }

    public String getIpAddress(long unitId) throws Exception {
        try {
            return this.getUnitWebServiceClient().getUnitIpAddress(unitId);
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            throw ex;
        }
    }

    public void forceAclUpdate(long unitId) throws Exception {
        try {
            this.getUnitWebServiceClient().forceACLUpdate(unitId);
        }
        catch (IOException ex) {
            log.log(Level.INFO, "Lost connection to server", ex);
            this.logoff();
            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.connectionLost.title"));
            throw ex;
        }
    }

    protected URL getConnectionURL() throws Exception {
        if (this.tunnel != null && !this.tunnel.isEmpty()) {
            if (this.connection == null || !this.connection.isConnected()) {
                Session session;
                boolean sessionReconnected = false;
                if (this.connection != null && (session = this.connection.getSession()) != null) {
                    try {
                        session.connect();
                        sessionReconnected = true;
                    }
                    catch (Exception ex) {
                        sessionReconnected = false;
                    }
                }
                if (!sessionReconnected) {
                    this.connection = new SSHConnection();
                    this.connection.addTunnel(this.tunnel);
                    this.connection.establishTunnel(this.serverURL.toString());
                }
            }
            return new URL(this.serverURL.getProtocol(), "localhost", this.connection.getConnectionPort(), this.serverURL.getFile());
        }
        return this.serverURL;
    }

    public void updateServerTime(long st) {
        this.serverTime.updateServerTime(st, false);
    }

    public void resetServerTime() {
        this.serverTime.reset();
    }

    class UnitAdminWrapper
    implements EFMServerUnitAdministration {
        private final UnitWebServiceClient unitWebServiceClient;

        public UnitAdminWrapper(UnitWebServiceClient unitWebServiceClient) {
            this.unitWebServiceClient = unitWebServiceClient;
        }

        public void setIMEI(long unitId, String imei) {
            this.unitWebServiceClient.setIMEI(unitId, imei);
        }

        public void setSerialNumber(long unitId, String serialNumber) {
            this.unitWebServiceClient.setSerialNumber(unitId, serialNumber);
        }

        public void assignToUnit(Device.DeviceType unitType, String serialNumber, long unidId) {
            this.unitWebServiceClient.assignToUnit(unitType.toString(), serialNumber, unidId);
        }

        public void setCallbackFlag(long unitId) {
            this.unitWebServiceClient.setCallbackFlag(unitId);
        }
    }
}

