/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.ui.options.HistoryOptionsPanel;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class HistoryOptionsController
extends OptionsPanelController
implements DocumentListener,
ActionListener,
VCSOptionsKeywordsProvider {
    private final HistoryOptionsPanel panel = new HistoryOptionsPanel();
    private boolean noLabelValue;
    private String daysValue;
    private String increments;

    public HistoryOptionsController() {
        this.panel.warningLabel.setVisible(false);
        this.panel.olderThanDaysTextField.getDocument().addDocumentListener(this);
        this.panel.daysIncrementTextField.getDocument().addDocumentListener(this);
        this.panel.keepForeverRadioButton.addActionListener(this);
        this.panel.removeOlderRadioButton.addActionListener(this);
        this.panel.loadAllRadioButton.addActionListener(this);
        this.panel.loadIncrementsRadioButton.addActionListener(this);
    }

    public void update() {
        this.daysValue = String.valueOf(HistorySettings.getInstance().getTTL());
        this.panel.olderThanDaysTextField.setText(this.daysValue);
        this.increments = String.valueOf(HistorySettings.getInstance().getIncrements());
        this.panel.daysIncrementTextField.setText(this.increments);
        this.noLabelValue = !HistorySettings.getInstance().getCleanUpLabeled();
        this.panel.noLabelCleanupCheckBox.setSelected(this.noLabelValue);
        if (HistorySettings.getInstance().getKeepForever()) {
            this.panel.keepForeverRadioButton.setSelected(true);
        } else {
            this.panel.removeOlderRadioButton.setSelected(true);
        }
        if (HistorySettings.getInstance().getLoadAll()) {
            this.panel.loadAllRadioButton.setSelected(true);
        } else {
            this.panel.loadIncrementsRadioButton.setSelected(true);
        }
        this.updateForeverState();
        this.updateLoadAllState();
    }

    public void applyChanges() {
        if (!this.isValid()) {
            return;
        }
        if (this.panel.keepForeverRadioButton.isSelected()) {
            HistorySettings.getInstance().setKeepForever(true);
            HistorySettings.getInstance().setTTL(Integer.parseInt(this.daysValue));
            HistorySettings.getInstance().setCleanUpLabeled(!this.noLabelValue);
        } else {
            HistorySettings.getInstance().setKeepForever(false);
            HistorySettings.getInstance().setTTL(Integer.parseInt(this.panel.olderThanDaysTextField.getText()));
            HistorySettings.getInstance().setCleanUpLabeled(!this.panel.noLabelCleanupCheckBox.isSelected());
        }
        if (this.panel.loadAllRadioButton.isSelected()) {
            HistorySettings.getInstance().setLoadAll(true);
            HistorySettings.getInstance().setIncrements(Integer.parseInt(this.increments));
        } else {
            HistorySettings.getInstance().setLoadAll(false);
            HistorySettings.getInstance().setIncrements(Integer.parseInt(this.panel.daysIncrementTextField.getText()));
        }
    }

    public void cancel() {
    }

    public boolean isValid() {
        boolean valid = true;
        try {
            if (!this.panel.keepForeverRadioButton.isSelected()) {
                Integer.parseInt(this.panel.olderThanDaysTextField.getText());
            }
            if (this.panel.loadIncrementsRadioButton.isSelected()) {
                Integer.parseInt(this.panel.daysIncrementTextField.getText());
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        this.panel.warningLabel.setVisible(!valid);
        return valid;
    }

    public boolean isChanged() {
        String ttl = Long.toString(HistorySettings.getInstance().getTTL());
        String increments = Long.toString(HistorySettings.getInstance().getIncrements());
        return !ttl.equals(this.panel.olderThanDaysTextField.getText()) || !increments.equals(this.panel.daysIncrementTextField.getText()) || this.panel.noLabelCleanupCheckBox.isSelected() != !HistorySettings.getInstance().getCleanUpLabeled() || this.panel.keepForeverRadioButton.isSelected() != HistorySettings.getInstance().getKeepForever() || this.panel.loadAllRadioButton.isSelected() != HistorySettings.getInstance().getLoadAll();
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.localhistory.options.LocalHistoryOptionsController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.keepForeverRadioButton || e.getSource() == this.panel.removeOlderRadioButton) {
            this.updateForeverState();
        } else if (e.getSource() == this.panel.loadAllRadioButton || e.getSource() == this.panel.loadIncrementsRadioButton) {
            this.updateLoadAllState();
        }
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    private void updateForeverState() {
        if (this.panel.keepForeverRadioButton.isSelected()) {
            this.panel.olderThanDaysTextField.setEnabled(false);
            this.panel.noLabelCleanupCheckBox.setEnabled(false);
            this.panel.noLabelCleanupCheckBox.setEnabled(false);
            this.noLabelValue = this.panel.noLabelCleanupCheckBox.isSelected();
            this.daysValue = this.panel.olderThanDaysTextField.getText();
            this.panel.noLabelCleanupCheckBox.setSelected(false);
            this.panel.olderThanDaysTextField.setText("");
        } else {
            this.panel.olderThanDaysTextField.setEnabled(true);
            this.panel.noLabelCleanupCheckBox.setEnabled(true);
            this.panel.noLabelCleanupCheckBox.setSelected(this.noLabelValue);
            this.panel.olderThanDaysTextField.setText(this.daysValue);
        }
    }

    private void updateLoadAllState() {
        if (this.panel.loadAllRadioButton.isSelected()) {
            this.panel.loadAllRadioButton.setSelected(true);
            this.panel.loadIncrementsRadioButton.setSelected(false);
            this.panel.daysIncrementTextField.setEnabled(false);
            this.increments = this.panel.daysIncrementTextField.getText();
            this.panel.daysIncrementTextField.setText("");
        } else {
            this.panel.daysIncrementTextField.setText(this.increments);
            this.panel.loadAllRadioButton.setSelected(false);
            this.panel.loadIncrementsRadioButton.setSelected(true);
            this.panel.daysIncrementTextField.setEnabled(true);
        }
    }
}

