/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultivalueMap<K, V> {
    private HashMap<K, Object> mContainer = new HashMap();

    public void put(K key, V value) {
        Object oldValue = this.mContainer.get(key);
        if (oldValue == null) {
            this.mContainer.put(key, value);
        } else if (oldValue instanceof List) {
            List valueList = (List)List.class.cast(oldValue);
            if (!valueList.contains(value)) {
                valueList.add(value);
            }
        } else {
            ArrayList<Object> newList = new ArrayList<Object>();
            this.mContainer.put(key, newList);
            newList.add(oldValue);
            newList.add(value);
        }
    }

    public List<V> get(K key) {
        Object values = this.mContainer.get(key);
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        if (values instanceof List) {
            return (List)List.class.cast(values);
        }
        return Collections.singletonList(values);
    }

    public boolean containsKey(K key) {
        return this.mContainer.containsKey(key);
    }

    public boolean isEmpty() {
        return this.mContainer.isEmpty();
    }

    public static class BidirectionalGraph<I> {
        private Graph<I> mForward = new Graph();
        private Graph<I> mBackward = new Graph();
        private Set<I> mRoots = null;

        public void put(I from, I to) {
            this.mForward.put(from, to);
            this.mBackward.put(to, from);
        }

        public List<I> getTo(I key) {
            return this.mForward.get(key);
        }

        public List<I> getFrom(I key) {
            return this.mBackward.get(key);
        }

        public boolean containsKey(I key) {
            return this.mForward.containsKey(key) || this.mBackward.containsKey(key);
        }

        public boolean isEmpty() {
            return this.mForward.isEmpty();
        }

        public Set<I> getRoots(I startItem, boolean recalculate) {
            if (this.mRoots == null) {
                recalculate = true;
            }
            if (recalculate) {
                this.mRoots = Utils.getTreeRoots(this, startItem);
            }
            return this.mRoots;
        }
    }

    public static class Graph<I>
    extends MultivalueMap<I, I> {
    }

    public static class Utils {
        public static <I> Set<I> getTreeLeafs(Graph<I> source, I startItem) {
            HashSet leafs = new HashSet();
            HashSet processedItems = new HashSet();
            Utils.populateLeafs(source, startItem, leafs, processedItems);
            return leafs;
        }

        private static <I> void populateLeafs(Graph<I> source, I startItem, Set<I> leafs, Set<I> processedItems) {
            List children = source.get(startItem);
            if (children.isEmpty()) {
                leafs.add(startItem);
            }
            processedItems.add(startItem);
            for (Object child : children) {
                if (processedItems.contains(child)) continue;
                Utils.populateLeafs(source, child, leafs, processedItems);
            }
        }

        public static <I> Set<I> collectAllSubItems(Graph<I> source, I startItem) {
            HashSet result = new HashSet();
            Utils.populateAllSubItems(source, startItem, result);
            return result;
        }

        public static <I> void populateAllSubItems(Graph<I> source, I startItem, Set<I> result) {
            result.add(startItem);
            List children = source.get(startItem);
            for (Object child : children) {
                if (result.contains(child)) continue;
                Utils.populateAllSubItems(source, child, result);
            }
        }

        public static <I> Set<I> getTreeRoots(BidirectionalGraph<I> source, I startItem) {
            HashSet leafs = new HashSet();
            HashSet processedItems = new HashSet();
            Path<I> iterationStack = new Path<I>(startItem);
            Utils.populateRoots(source, iterationStack, leafs, processedItems);
            return leafs;
        }

        private static <I> void populateRoots(BidirectionalGraph<I> source, Path<I> iterationStack, Set<I> leafs, Set<I> processedItems) {
            I startItem = iterationStack.getItem();
            processedItems.add(startItem);
            List<I> referencesToStartItem = source.getFrom(startItem);
            if (referencesToStartItem.isEmpty()) {
                leafs.add(startItem);
            }
            for (I referenceToStartItem : referencesToStartItem) {
                if (!processedItems.contains(referenceToStartItem)) {
                    Path<I> path = new Path<I>(iterationStack, referenceToStartItem);
                    Utils.populateRoots(source, path, leafs, processedItems);
                    continue;
                }
                if (!iterationStack.containsInPath(referenceToStartItem)) continue;
                leafs.add(referenceToStartItem);
            }
        }

        public static <I> void populateAllSubItems(BidirectionalGraph<I> source, I startItem, I excludeItem, Set<I> result) {
            if (startItem == excludeItem) {
                return;
            }
            result.add(startItem);
            List<I> children = source.getTo(startItem);
            for (I child : children) {
                if (result.contains(child)) continue;
                Utils.populateAllSubItems(source, child, excludeItem, result);
            }
        }

        private static class Path<I> {
            private I mItem;
            private Path<I> mParentPath;

            public Path(I item) {
                this.mItem = item;
            }

            public Path(Path<I> parentPath, I item) {
                this.mItem = item;
                this.mParentPath = parentPath;
            }

            public I getItem() {
                return this.mItem;
            }

            public boolean containsInPath(I item) {
                if (item == this.mItem) {
                    return true;
                }
                if (this.mParentPath != null) {
                    return this.mParentPath.containsInPath(item);
                }
                return false;
            }
        }
    }
}

