/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class RemoteInfoDialog
extends JPanel {
    private static final String LAST_SELECTED_HOST = "lastSelectedHost";
    private JRadioButton btnKnownHosts;
    private JRadioButton btnNewHost;
    private ButtonGroup buttonGroup1;
    private JComboBox cbKnownHosts;
    private JTextField hostField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel pnlConnectionInfo;
    private JTextField portField;
    private JTextField userField;
    private ExecutionEnvironment last;

    public RemoteInfoDialog(String user) {
        this.initComponents();
        this.userField.setText(user);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.cbKnownHosts = new JComboBox();
        this.btnKnownHosts = new JRadioButton();
        this.btnNewHost = new JRadioButton();
        this.pnlConnectionInfo = new JPanel();
        this.jLabel1 = new JLabel();
        this.userField = new JTextField();
        this.jLabel2 = new JLabel();
        this.hostField = new JTextField();
        this.jLabel3 = new JLabel();
        this.portField = new JTextField();
        this.buttonGroup1.add(this.btnKnownHosts);
        this.btnKnownHosts.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btnKnownHosts, (String)NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.btnKnownHosts.text"));
        this.btnKnownHosts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RemoteInfoDialog.this.btnKnownHostsItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.btnNewHost);
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewHost, (String)NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.btnNewHost.text"));
        this.btnNewHost.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RemoteInfoDialog.this.btnNewHostItemStateChanged(evt);
            }
        });
        this.pnlConnectionInfo.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RemoteInfoDialog.class, (String)"NewHostInfoTitle")));
        this.jLabel1.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.jLabel1.text"));
        this.userField.setText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.userField.text"));
        this.userField.setToolTipText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.userField.toolTipText"));
        this.userField.setInputVerifier(new NonEmpty());
        this.jLabel2.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.jLabel2.text"));
        this.hostField.setText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.hostField.text"));
        this.hostField.setToolTipText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.hostField.toolTipText"));
        this.hostField.setInputVerifier(new NonEmpty());
        this.jLabel3.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.jLabel3.text"));
        this.portField.setColumns(4);
        this.portField.setText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.portField.text"));
        this.portField.setToolTipText(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.portField.toolTipText"));
        this.portField.setInputVerifier(new IntVerifier(this.portField));
        GroupLayout pnlConnectionInfoLayout = new GroupLayout(this.pnlConnectionInfo);
        this.pnlConnectionInfo.setLayout(pnlConnectionInfoLayout);
        pnlConnectionInfoLayout.setHorizontalGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 324, Short.MAX_VALUE).addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectionInfoLayout.createSequentialGroup().addContainerGap().addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userField, -1, 226, Short.MAX_VALUE).addComponent(this.hostField, -1, 226, Short.MAX_VALUE).addComponent(this.portField, -2, -1, -2)).addContainerGap())));
        pnlConnectionInfoLayout.setVerticalGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 117, Short.MAX_VALUE).addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConnectionInfoLayout.createSequentialGroup().addContainerGap().addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.userField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlConnectionInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.portField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        this.userField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.userField.AccessibleContext.accessibleName"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.hostField.AccessibleContext.accessibleName"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteInfoDialog.class, (String)"RemoteInfoDialog.portField.AccessibleContext.accessibleName"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlConnectionInfo, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnKnownHosts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKnownHosts, 0, 224, Short.MAX_VALUE)).addComponent(this.btnNewHost)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbKnownHosts, -2, -1, -2).addComponent(this.btnKnownHosts)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNewHost).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlConnectionInfo, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnKnownHostsItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.selectMode(true);
        }
    }

    private void btnNewHostItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.selectMode(false);
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        if (this.btnKnownHosts.isSelected()) {
            this.last = (ExecutionEnvironment)this.cbKnownHosts.getSelectedItem();
        } else {
            if (this.userField.getText().isEmpty() || this.hostField.getText().isEmpty()) {
                return null;
            }
            int port = 22;
            if (!this.portField.getText().isEmpty()) {
                try {
                    port = Integer.valueOf(this.portField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.last = ExecutionEnvironmentFactory.createNew((String)this.userField.getText(), (String)this.hostField.getText(), (int)port);
        }
        Preferences prefs = NbPreferences.forModule(RemoteInfoDialog.class);
        prefs.put(LAST_SELECTED_HOST, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.last));
        return this.last;
    }

    private void fillHosts() {
        this.cbKnownHosts.removeAllItems();
        for (ExecutionEnvironment ee : ConnectionManager.getInstance().getRecentConnections()) {
            this.cbKnownHosts.addItem(ee);
        }
        boolean hasKnown = this.cbKnownHosts.getItemCount() > 0;
        this.btnKnownHosts.setEnabled(hasKnown);
        if (hasKnown) {
            if (this.last != null) {
                this.cbKnownHosts.setSelectedItem(this.last);
            }
            this.btnKnownHosts.setSelected(true);
        } else {
            this.btnNewHost.setSelected(true);
        }
        this.selectMode(hasKnown);
    }

    private void selectMode(boolean knownHosts) {
        Component[] components;
        this.cbKnownHosts.setEnabled(knownHosts);
        for (Component component : components = this.pnlConnectionInfo.getComponents()) {
            component.setEnabled(!knownHosts);
        }
    }

    public void init() {
        Preferences prefs;
        String eeID;
        if (this.last == null && !(eeID = (prefs = NbPreferences.forModule(RemoteInfoDialog.class)).get(LAST_SELECTED_HOST, "")).isEmpty()) {
            this.last = ExecutionEnvironmentFactory.fromUniqueID((String)eeID);
        }
        this.fillHosts();
    }

    private static final class IntVerifier
    extends InputVerifier {
        private final JTextField tf;

        public IntVerifier(JTextField tf) {
            this.tf = tf;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                Integer.valueOf(this.tf.getText());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
        }
    }

    private static final class NonEmpty
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            if (input instanceof JTextComponent) {
                JTextComponent tf = (JTextComponent)input;
                return !tf.getText().isEmpty();
            }
            return true;
        }
    }
}

