/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.config.impl.type;

import de.proveo.infoman.config.impl.type.JavaLangTypeWrapper;
import de.proveo.infoman.config.impl.type.JavaNetTypeWrapper;
import de.proveo.infoman.config.impl.type.JavaUtilTypeWrapper;
import de.proveo.infoman.config.impl.type.Type;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeFactory {
    private static final String[] packages = new String[]{"java.lang", "java.util", "java.net", TypeFactory.class.getPackage().getName()};

    protected TypeDescription parse(String typeDescription) {
        TypeDescription description = null;
        if (typeDescription != null) {
            description = new TypeDescription();
            Scanner scanner = new Scanner(typeDescription).useDelimiter("[\\[\\]]");
            int i = 0;
            while (scanner.hasNext()) {
                switch (i) {
                    case 0: {
                        description.className = scanner.next();
                        break;
                    }
                    case 1: {
                        description.options = scanner.next();
                    }
                }
                ++i;
            }
        }
        return description;
    }

    protected Type createInstance(String className) throws IllegalArgumentException {
        Type type;
        block11: {
            String clazz;
            if (className == null) {
                return null;
            }
            type = null;
            String string = clazz = className.contains(".") ? className : this.resolveClassName(className);
            if (clazz != null) {
                try {
                    Class<?> c = Class.forName(clazz, false, TypeFactory.class.getClassLoader());
                    Class<?>[] interfaces = c.getInterfaces();
                    boolean isTypeImplemented = false;
                    for (int i = 0; !isTypeImplemented && i < interfaces.length; ++i) {
                        isTypeImplemented = interfaces[i].getName().equals(Type.class.getName());
                    }
                    if (isTypeImplemented) {
                        type = (Type)c.newInstance();
                        break block11;
                    }
                    if (c.getName().contains("java.lang")) {
                        type = new JavaLangTypeWrapper(c);
                        break block11;
                    }
                    if (c.getName().contains("java.util")) {
                        type = new JavaUtilTypeWrapper(c);
                        break block11;
                    }
                    if (c.getName().contains("java.net")) {
                        type = new JavaNetTypeWrapper(c);
                        break block11;
                    }
                    throw new IllegalArgumentException("This type is not supported: " + c.getName());
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(TypeFactory.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(TypeFactory.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(TypeFactory.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return type;
    }

    private String resolveClassName(String className) {
        boolean classExists = false;
        String clazz = null;
        for (int i = 0; !classExists && i < packages.length; ++i) {
            clazz = (packages[i].endsWith(".") ? packages[i] : packages[i] + ".") + className;
            try {
                Class<?> c = Class.forName(clazz, false, TypeFactory.class.getClassLoader());
                classExists = true;
                continue;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        return classExists ? clazz : null;
    }

    public Type create(String typeDescription) throws Exception {
        TypeDescription description = this.parse(typeDescription);
        Type type = this.createInstance(description.className);
        if (type != null) {
            type.setOptions(description.options);
        }
        return type;
    }

    protected class TypeDescription {
        String className;
        String options;

        protected TypeDescription() {
        }
    }
}

