/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.config.impl;

import de.proveo.infoman.config.definition.DefaultList;
import de.proveo.infoman.config.definition.Enum;
import de.proveo.infoman.config.definition.Property;
import de.proveo.infoman.config.definition.Validation;
import de.proveo.infoman.config.impl.type.JavaLangTypeWrapper;
import de.proveo.infoman.config.impl.type.Type;
import de.proveo.infoman.config.impl.type.TypeCache;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public final class PropertyElementWrapper {
    public static final PropertyElementWrapper INSTANCE = new PropertyElementWrapper();

    private PropertyElementWrapper() {
    }

    public Object getElementValue(Property prop, String elementName) {
        QName qName = new QName(elementName);
        List<Object> propertyContents = prop.getContent();
        for (Object propertyContent : propertyContents) {
            JAXBElement jaxbElement;
            if (!(propertyContent instanceof JAXBElement) || !(jaxbElement = (JAXBElement)propertyContent).getName().equals(qName)) continue;
            return jaxbElement.getValue();
        }
        return null;
    }

    public Object getElement(Property prop, Class element) {
        List<Object> propertyContents = prop.getContent();
        for (Object propertyContent : propertyContents) {
            if (!element.isInstance(propertyContent)) continue;
            return propertyContent;
        }
        return null;
    }

    public Type getType(Property prop) throws Exception {
        Object obj = this.getElementValue(prop, "type");
        if (obj != null) {
            return TypeCache.INSTANCE.get((String)obj);
        }
        return new JavaLangTypeWrapper(String.class);
    }

    public Type getType(String className) throws Exception {
        if (className != null) {
            return TypeCache.INSTANCE.get(className);
        }
        return new JavaLangTypeWrapper(String.class);
    }

    public Enum getEnum(Property prop) {
        Object obj = this.getElement(prop, Enum.class);
        if (obj != null) {
            return (Enum)obj;
        }
        return null;
    }

    public Validation getValidation(Property prop) {
        Object obj = this.getElement(prop, Validation.class);
        if (obj != null) {
            return (Validation)obj;
        }
        return null;
    }

    public Object getDefaultValue(Property prop) {
        return this.getElementValue(prop, "defaultValue");
    }

    public List<String> getDefaultList(Property prop) {
        Object obj = this.getElement(prop, DefaultList.class);
        if (obj != null) {
            return ((DefaultList)obj).getValue();
        }
        return null;
    }
}

