/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.config;

import de.proveo.infoman.config.definition.DefaultList;
import de.proveo.infoman.config.definition.Enum;
import de.proveo.infoman.config.definition.Group;
import de.proveo.infoman.config.definition.InfomanConfig;
import de.proveo.infoman.config.definition.IsNecessary;
import de.proveo.infoman.config.definition.Property;
import de.proveo.infoman.config.definition.Validation;
import de.proveo.infoman.config.impl.InstanceCache;
import de.proveo.infoman.config.impl.IsNecessaryTag;
import de.proveo.infoman.config.impl.type.AbstractTypeWrapper;
import de.proveo.infoman.config.impl.type.Type;
import de.proveo.infoman.config.impl.type.TypeCache;
import de.proveo.infoman.config.impl.validation.EnumValidationHelper;
import de.proveo.infoman.config.impl.validation.ValidationError;
import de.proveo.infoman.config.impl.validation.ValidationErrorImpl;
import de.proveo.infoman.config.impl.validation.ValidationHelper;
import de.proveo.infoman.config.impl.validation.ValidationHelperFactory;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class ConfigUtil {
    public static final String REGEXP_PREFIX = "regexp:";
    public static final String LIST_COLUMN_SEPARATOR = ",";
    public static final String LIST_KEY_WORD_SEPARATOR = ":";
    public static final String LIST_KEY_WORDS_SEPARATOR = ";";
    public static final String LIST_KEY_WORD_VALUE_SEPARATOR = "=";
    public static final String LIST_KEY_WORD_UNIQUE = "unique";
    public static final String LIST_KEY_WORD_KEY_INDEX = "keyIndex";
    public static final String LIST_KEY_WORD_KEY_SUFFIX = "keySuffix";
    public static final String LIST_KEY_WORD_SIZE = "size";
    public static final String LIST_KEY_WORD_VALUE_SMALL = "small";
    public static final String LIST_KEY_WORD_VALUE_MEDIUM = "medium";
    public static final String LIST_KEY_WORD_VALUE_LARGE = "large";
    public static final String LIST_KEY_WORD_VALUE_FILL = "fill";
    PrintWriter out;
    Properties configCache;
    Properties config;
    InstanceCache instanceCache;
    List<ValidationError> validationErrors;
    private static final String GROUP_BORDER = "# -----------------------------------------------------------------------------";
    private static final QName tagNameDescription = new QName("description");
    private static final QName tagNameDefaultValue = new QName("defaultValue");
    private static final QName tagNameType = new QName("type");
    private static final QName tagNameEnum = new QName("enum");
    private final ValidationHelperFactory validationFactory = new ValidationHelperFactory();

    public synchronized void writeDefault(InfomanConfig configSyntax, PrintWriter out) {
        this.write(configSyntax, null, out);
    }

    public synchronized void write(InfomanConfig configSyntax, Properties config, PrintWriter out) {
        this.init(out, config);
        this.addHeader(configSyntax);
        List<Group> groups = configSyntax.getGroup();
        for (Group group : groups) {
            this.addTopGroup(group);
        }
    }

    protected void init(PrintWriter out, Properties config) {
        this.out = out;
        this.configCache = new Properties();
        this.config = config;
        this.instanceCache = new InstanceCache();
        this.validationErrors = new ArrayList<ValidationError>();
    }

    protected void addDescription(String description) {
        if (description != null) {
            this.out.println();
            Iterator<String> it = this.trimDescription(description).iterator();
            while (it.hasNext()) {
                this.out.print("# ");
                this.out.println(it.next());
            }
        }
    }

    protected void addTopGroup(Group group) {
        this.out.println(GROUP_BORDER);
        this.out.println("#");
        this.out.print("# ");
        this.out.println(group.getName());
        this.out.println("#");
        this.out.println(GROUP_BORDER);
        this.addGroup(group);
        this.out.println();
    }

    protected void addGroup(Group group) {
        this.addGroup(group, null);
    }

    protected String getPropertyStartWith(Properties properties, String startsWith) {
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(startsWith)) continue;
            return key;
        }
        return null;
    }

    protected Object[] buildFormatParameter(int indexNumber, Object value) {
        Object[] arr = new Object[indexNumber + 1];
        arr[indexNumber] = value;
        return arr;
    }

    protected int getCountIndexedKey(String key, int indexNumber, Map<String, String> keyReplace) {
        String keyToTest;
        key = this.applyKeyReplaceMap(keyReplace, key);
        boolean startsWith = false;
        if (key.endsWith("*")) {
            key = key.substring(0, key.length() - 1);
            startsWith = true;
        }
        int index = 0;
        do {
            keyToTest = MessageFormat.format(key, this.buildFormatParameter(indexNumber, index));
            keyToTest = startsWith ? this.getPropertyStartWith(this.config, keyToTest) : this.config.getProperty(keyToTest);
            if (keyToTest == null) continue;
            ++index;
        } while (keyToTest != null);
        return index;
    }

    protected Map<String, String> initKeyReplaceMap(Map<String, String> kayReplace) {
        if (kayReplace == null) {
            kayReplace = new HashMap<String, String>();
        }
        return kayReplace;
    }

    protected void addGroup(Group group, Map<String, String> keyReplace) {
        List<Object> groupsOrProperties = group.getGroupOrProperty();
        for (Object groupOrProperty : groupsOrProperties) {
            if (groupOrProperty instanceof Group) {
                Group subgroup = (Group)groupOrProperty;
                Boolean multipleIndex = subgroup.isMultipleIndex();
                if (this.config != null && multipleIndex != null && multipleIndex.booleanValue()) {
                    keyReplace = this.initKeyReplaceMap(keyReplace);
                    int count = this.getCountIndexedKey(subgroup.getCount(), subgroup.getIndex().intValue(), keyReplace);
                    for (int index = 0; index < count; ++index) {
                        keyReplace.put("{" + subgroup.getIndex().intValue() + "}", new Integer(index).toString());
                        this.addGroup(subgroup, keyReplace);
                    }
                    continue;
                }
                this.addGroup(subgroup, keyReplace);
                continue;
            }
            Property property = (Property)groupOrProperty;
            Boolean multiple = property.isMultipleAlias();
            Boolean multipleIndex = property.isMultipleIndex();
            if (multiple != null && multiple.booleanValue()) {
                this.addMultipleAliasProperty(property);
                continue;
            }
            if (this.config != null && multipleIndex != null && multipleIndex.booleanValue()) {
                keyReplace = this.initKeyReplaceMap(keyReplace);
                int count = this.getCountIndexedKey(property.getCount(), property.getIndex().intValue(), keyReplace);
                String replaceKey = "{" + property.getIndex().intValue() + "}";
                for (int index = 0; index < count; ++index) {
                    keyReplace.put(replaceKey, new Integer(index).toString());
                    try {
                        this.addSingleProperty(property, keyReplace);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ConfigUtil.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                keyReplace.remove(replaceKey);
                continue;
            }
            if (this.isRegularExprKey(property.getKey()) && this.config != null) {
                String regexpr = this.extractRegExp(property.getKey());
                ArrayList<String> filterdKeys = new ArrayList<String>();
                Set<Object> keys = this.config.keySet();
                for (Object object : keys) {
                    String kStr = (String)object;
                    if (!this.isMatching(kStr, regexpr)) continue;
                    filterdKeys.add(kStr);
                }
                Collections.sort(filterdKeys);
                if (!filterdKeys.isEmpty()) {
                    this.out.println();
                }
                for (String string : filterdKeys) {
                    this.out.print(string);
                    this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                    this.out.println(this.config.getProperty(string));
                }
                continue;
            }
            try {
                this.addSingleProperty(property, keyReplace);
            }
            catch (Exception ex) {
                Logger.getLogger(ConfigUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected boolean isRegularExprKey(String key) {
        return key.startsWith(REGEXP_PREFIX);
    }

    protected String extractRegExp(String key) {
        return key.substring(REGEXP_PREFIX.length());
    }

    protected boolean isMatching(String key, String regexp) {
        return key.matches(regexp);
    }

    protected List<String> trimDescription(String description) {
        description = description.trim();
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(description, "\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken().trim());
        }
        return lines;
    }

    protected String replaceKeyAlias(String value) {
        int begin = value.indexOf(123);
        int end = value.indexOf(125, begin);
        if (begin > -1 && end > -1) {
            String aliasKey = value.substring(begin + 1, end);
            if (aliasKey.endsWith("[]")) {
                throw new IllegalArgumentException("[]");
            }
            String aliasValue = this.configCache.getProperty(aliasKey);
            if (aliasValue != null) {
                StringBuilder replacedKey = new StringBuilder(value.substring(0, begin));
                replacedKey.append(aliasValue);
                replacedKey.append(value.substring(end + 1));
                return replacedKey.toString();
            }
            return value;
        }
        return value;
    }

    protected String getOverwritten(String key, String defaultValue) {
        if (this.config == null) {
            return null;
        }
        String value = this.config.getProperty(key);
        if (value == null) {
            return null;
        }
        value = value.trim();
        if (defaultValue != null && defaultValue.equals(value)) {
            return null;
        }
        return value;
    }

    public Map<String, String> getOverwrittenByKeyPattern(Pattern keyPattern, String defaultValue) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        Iterator<Object> ite = this.config.keySet().iterator();
        while (ite.hasNext()) {
            String key = ite.next().toString();
            Matcher matcher = keyPattern.matcher(key);
            if (!matcher.matches()) continue;
            ret.put(key, this.getOverwritten(key, defaultValue));
        }
        return ret;
    }

    protected void addSingleProperty(Property property) throws Exception {
        this.addSingleProperty(property, null);
    }

    protected void addSingleProperty(Property property, Map keyReplace) throws Exception {
        block27: {
            List<String> defaultListValues;
            String defaultValue;
            String key;
            String description;
            block28: {
                block29: {
                    block26: {
                        description = null;
                        key = property.getKey();
                        key = this.applyKeyReplaceMap(keyReplace, key);
                        key = this.replaceKeyAlias(key);
                        defaultValue = null;
                        defaultListValues = null;
                        Object type = null;
                        Class c = null;
                        String options = null;
                        List<Object> propertyContents = property.getContent();
                        for (Object propertyContent : propertyContents) {
                            IsNecessary xml;
                            IsNecessaryTag tag;
                            if (propertyContent instanceof JAXBElement) {
                                JAXBElement jaxbElement = (JAXBElement)propertyContent;
                                if (jaxbElement.getName().equals(tagNameDescription)) {
                                    description = (String)jaxbElement.getValue();
                                    continue;
                                }
                                if (jaxbElement.getName().equals(tagNameDefaultValue)) {
                                    defaultValue = (String)jaxbElement.getValue();
                                    continue;
                                }
                                if (!jaxbElement.getName().equals(tagNameType)) continue;
                                String typeDescription = (String)jaxbElement.getValue();
                                type = TypeCache.INSTANCE.get(typeDescription);
                                continue;
                            }
                            if (propertyContent instanceof DefaultList) {
                                defaultListValues = ((DefaultList)propertyContent).getValue();
                                continue;
                            }
                            if (!(propertyContent instanceof IsNecessary) || (tag = (IsNecessaryTag)this.instanceCache.get(Class.forName((xml = (IsNecessary)propertyContent).getClazz()))).isNecessary(this.config, key)) continue;
                            return;
                        }
                        if (type != null) {
                            if (type instanceof AbstractTypeWrapper) {
                                AbstractTypeWrapper typeWrapper = (AbstractTypeWrapper)type;
                                c = typeWrapper.getWrappedClass();
                                options = typeWrapper.getOptions();
                            } else {
                                c = type.getClass();
                            }
                        }
                        if (c == null || !c.equals(List.class) || this.config == null) break block26;
                        int keyIndex = -1;
                        ArrayList<String> keySuffixes = new ArrayList<String>();
                        if (options != null && (options.contains(LIST_KEY_WORD_KEY_SUFFIX) || options.contains(LIST_KEY_WORD_KEY_INDEX))) {
                            String[] columns = StringUtils.split((String)options, (String)LIST_COLUMN_SEPARATOR);
                            for (int i = 0; i < columns.length; ++i) {
                                String column = columns[i];
                                if (column.contains(LIST_KEY_WORD_KEY_INDEX) && column.contains("Integer:") && keyIndex == -1) {
                                    keyIndex = i;
                                }
                                if (!column.contains(LIST_KEY_WORD_KEY_SUFFIX)) continue;
                                String keySuffix = StringUtils.substringAfter((String)column, (String)":keySuffix=");
                                if (keySuffix.contains(LIST_KEY_WORD_SEPARATOR)) {
                                    keySuffix = StringUtils.split((String)keySuffix, (String)LIST_KEY_WORD_SEPARATOR)[0];
                                }
                                keySuffixes.add(keySuffix);
                            }
                        }
                        if (keyIndex != -1) {
                            String keyPattern = key + ".\\d+";
                            keyPattern = StringUtils.replace((String)keyPattern, (String)".", (String)"\\.");
                            Map<String, String> properties = this.getOverwrittenByKeyPattern(Pattern.compile(keyPattern), defaultValue);
                            for (String lKey : properties.keySet()) {
                                String overwritten = properties.get(lKey);
                                this.out.print(lKey);
                                this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                                this.out.println(overwritten);
                                this.configCache.setProperty(lKey, overwritten);
                                if (keySuffixes.isEmpty()) continue;
                                for (String keySuffix : keySuffixes) {
                                    String sKey = lKey + keySuffix;
                                    overwritten = this.getOverwritten(sKey, null);
                                    if (overwritten == null) continue;
                                    this.out.print(sKey);
                                    this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                                    this.out.println(overwritten);
                                    this.configCache.setProperty(sKey, overwritten);
                                }
                            }
                        } else {
                            int index = 0;
                            String lKey = key + "." + index;
                            String overwritten = this.getOverwritten(lKey, null);
                            while (overwritten != null) {
                                this.out.print(lKey);
                                this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                                this.out.println(overwritten);
                                this.configCache.setProperty(lKey, overwritten);
                                if (!keySuffixes.isEmpty()) {
                                    for (String keySuffix : keySuffixes) {
                                        String sKey = lKey + keySuffix;
                                        overwritten = this.getOverwritten(sKey, null);
                                        if (overwritten == null) continue;
                                        this.out.print(sKey);
                                        this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                                        this.out.println(overwritten);
                                        this.configCache.setProperty(sKey, overwritten);
                                    }
                                }
                                lKey = key + "." + ++index;
                                overwritten = this.getOverwritten(lKey, null);
                            }
                        }
                        break block27;
                    }
                    if (defaultValue != null || defaultListValues != null) break block28;
                    if (this.config != null) break block29;
                    this.addDescription(description);
                    this.out.print("# ");
                    this.out.print(key);
                    this.out.println(LIST_KEY_WORD_VALUE_SEPARATOR);
                    break block27;
                }
                String overwritten = this.getOverwritten(key, null);
                if (overwritten == null) break block27;
                this.addDescription(description);
                this.out.print(key);
                this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                this.out.println(overwritten);
                this.validate(property, overwritten);
                break block27;
            }
            if (defaultValue != null && defaultListValues == null) {
                String value = defaultValue.trim();
                String overwritten = this.getOverwritten(key, value);
                if (overwritten != null) {
                    value = overwritten;
                }
                if (this.config == null || overwritten != null) {
                    this.addDescription(description);
                    this.out.print(key);
                    this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                    this.out.println(value);
                    this.validate(property, value);
                }
                this.configCache.setProperty(key, value);
            } else if (defaultListValues != null && this.config == null) {
                if (!defaultListValues.isEmpty()) {
                    this.addDescription(description);
                }
                for (int index = 0; index < defaultListValues.size(); ++index) {
                    defaultValue = defaultListValues.get(index).trim();
                    this.out.print(key);
                    this.out.print(".");
                    this.out.print(index);
                    this.out.print(LIST_KEY_WORD_VALUE_SEPARATOR);
                    this.out.println(defaultValue);
                    this.configCache.setProperty(key + "." + index, defaultValue);
                }
            }
        }
    }

    protected void addHeader(InfomanConfig config) {
        this.out.println("# Generated by ConfigPrinterUtil");
        if (this.config == null) {
            this.out.println("# Infoman Default Configuration. Don't modify this file!");
        }
        this.out.println();
    }

    protected void addMultipleAliasProperty(Property property) {
        if (this.config == null) {
            return;
        }
        String pattern = property.getKey().substring(0, property.getKey().length() - 1);
        Enumeration<?> en = this.config.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(pattern)) continue;
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put(property.getKey(), key);
            try {
                this.addSingleProperty(property, replace);
            }
            catch (Exception ex) {
                Logger.getLogger(ConfigUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected String applyKeyReplaceMap(Map<String, String> keyReplace, String key) {
        if (keyReplace == null || keyReplace.isEmpty()) {
            return key;
        }
        for (Map.Entry<String, String> entry : keyReplace.entrySet()) {
            key = StringUtils.replace((String)key, (String)entry.getKey(), (String)entry.getValue());
        }
        return key;
    }

    private void validate(Property property, String value) {
        try {
            Enum en = null;
            ValidationHelper validationHelper = null;
            Type type = null;
            List<Object> propertyContents = property.getContent();
            for (Object propertyContent : propertyContents) {
                if (propertyContent instanceof JAXBElement) {
                    JAXBElement jaxbElement = (JAXBElement)propertyContent;
                    if (!jaxbElement.getName().equals(tagNameEnum)) continue;
                    String typeDescription = (String)jaxbElement.getValue();
                    type = TypeCache.INSTANCE.get(typeDescription);
                    continue;
                }
                if (propertyContent instanceof Enum) {
                    en = (Enum)propertyContent;
                    continue;
                }
                if (!(propertyContent instanceof Validation)) continue;
                Validation validation = (Validation)propertyContent;
                validationHelper = this.validationFactory.create(validation);
            }
            if (en != null) {
                validationHelper = new EnumValidationHelper(en);
                validationHelper.validate(this.validationErrors, property, value);
            }
            if (type != null) {
                this.addValidationError(type.validate(value));
            }
            if (validationHelper != null) {
                validationHelper.validate(this.validationErrors, property, value);
            }
        }
        catch (Exception ex) {
            this.addValidationError(new ValidationErrorImpl(property.getKey(), value, ex));
        }
    }

    protected void addValidationError(ValidationError validationError) {
        if (validationError != null) {
            this.validationErrors.add(validationError);
        }
    }

    public boolean hasErrors() {
        return !this.validationErrors.isEmpty();
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }
}

