/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.swing.components;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationAdapter;
import com.jgoodies.animation.AnimationEvent;
import com.jgoodies.animation.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;

public final class AnimatedLabel
extends JPanel {
    public static final String PROPERTY_ANIMATED = "animated";
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_TEXT = "text";
    public static final int RIGHT = 4;
    public static final int CENTER = 0;
    public static final int LEFT = 2;
    public static final Color DEFAULT_BASE_COLOR = new Color(64, 64, 64);
    public static final int DEFAULT_FONT_EXTRA_SIZE = 8;
    private static final int DEFAULT_DURATION = 300;
    private static final int DEFAULT_ANIMATION_FPS = 30;
    private JLabel[] labels;
    private int foreground = 0;
    private int background = 1;
    private Color baseColor;
    private boolean animated;
    private final int orientation;
    private long duration;
    private final int fps;
    private Animation animation;
    private Animator animator;

    public AnimatedLabel() {
        this(DEFAULT_BASE_COLOR, 8, "");
    }

    public AnimatedLabel(Color baseColor, int fontExtraSize, String text) {
        this(baseColor, fontExtraSize, text, 2);
    }

    public AnimatedLabel(Color baseColor, int fontExtraSize, String text, int orientation) {
        this(baseColor, fontExtraSize, text, orientation, 300, 30);
    }

    public AnimatedLabel(Color baseColor, int fontExtraSize, String text, int orientation, int duration, int framesPerSecond) {
        super(null);
        this.baseColor = baseColor;
        this.orientation = orientation;
        this.duration = duration;
        this.fps = framesPerSecond;
        this.animated = true;
        this.initComponents(fontExtraSize);
        this.build();
        this.setTextImmediately(text);
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public Color getForeground() {
        return this.baseColor;
    }

    public synchronized String getText() {
        return this.labels[this.foreground].getText();
    }

    public void setAnimated(boolean animated) {
        boolean oldAnimated = animated;
        this.animated = animated;
        this.firePropertyChange(PROPERTY_ANIMATED, oldAnimated, animated);
    }

    public void setDuration(long newDuration) {
        long oldDuration = this.duration;
        this.duration = newDuration;
        this.animation = null;
        this.firePropertyChange(PROPERTY_DURATION, oldDuration, newDuration);
    }

    @Override
    public void setForeground(Color newForeground) {
        Color oldForeground = this.getForeground();
        this.baseColor = newForeground;
        this.firePropertyChange(PROPERTY_FOREGROUND, oldForeground, newForeground);
    }

    public synchronized void setText(String newText) {
        String oldText = this.getText();
        if (oldText.equals(newText)) {
            return;
        }
        if (!this.isAnimated()) {
            this.setTextImmediately(newText);
            return;
        }
        this.labels[this.background].setText(newText);
        this.foreground = 1 - this.foreground;
        this.background = 1 - this.background;
        if (this.animator != null) {
            this.animator.stop();
        }
        this.animator = new Animator(this.animation(), this.fps);
        this.animator.start();
        this.firePropertyChange(PROPERTY_TEXT, oldText, newText);
    }

    public void setTextImmediately(String newText) {
        String oldText = this.getText();
        this.labels[this.background].setText(newText);
        this.foreground = 1 - this.foreground;
        this.background = 1 - this.background;
        this.setAlpha(255, 0);
        this.firePropertyChange(PROPERTY_TEXT, oldText, newText);
    }

    private Animation animation() {
        if (this.animation == null) {
            this.animation = new BlendOverAnimation(this.duration);
            this.animation.addAnimationListener(new AnimationAdapter(){

                @Override
                public void animationStopped(AnimationEvent e) {
                    AnimatedLabel.this.setAlpha(255, 0);
                }
            });
        }
        return this.animation;
    }

    private void initComponents(int fontExtraSize) {
        this.labels = new JLabel[2];
        this.labels[this.foreground] = AnimatedLabel.createBoldLabel(fontExtraSize, this.getTranslucentColor(255));
        this.labels[this.background] = AnimatedLabel.createBoldLabel(fontExtraSize, this.getTranslucentColor(255));
    }

    private void build() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = this.anchor();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.labels[this.foreground], gbc);
        this.add((Component)this.labels[this.background], gbc);
    }

    private int anchor() {
        if (this.orientation == 4) {
            return 13;
        }
        if (this.orientation == 0) {
            return 10;
        }
        return 17;
    }

    private static JLabel createBoldLabel(int sizeIncrement, Color aForeground) {
        AntiAliasedLabel label = new AntiAliasedLabel("", 1, sizeIncrement);
        label.setForeground(aForeground);
        return label;
    }

    private Color getTranslucentColor(int alpha) {
        return new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), alpha);
    }

    private void setAlpha0(int foregroundAlpha, int backgroundAlpha) {
        this.labels[this.foreground].setForeground(this.getTranslucentColor(foregroundAlpha));
        this.labels[this.background].setForeground(this.getTranslucentColor(backgroundAlpha));
    }

    private void setAlpha(final int foregroundAlpha, final int backgroundAlpha) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setAlpha0(foregroundAlpha, backgroundAlpha);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AnimatedLabel.this.setAlpha0(foregroundAlpha, backgroundAlpha);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static final class AntiAliasedLabel
    extends JLabel {
        private final int fontExtraSize;
        private final int fontStyle;

        private AntiAliasedLabel(String text, int fontStyle, int fontExtraSize) {
            super(text);
            this.fontStyle = fontStyle;
            this.fontExtraSize = fontExtraSize;
            this.updateUI();
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldHint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g2);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHint);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Font font = this.getFont();
            if (0 == this.fontExtraSize) {
                if (font.getStyle() != this.fontStyle) {
                    this.setFont(new FontUIResource(font.deriveFont(this.fontStyle)));
                }
            } else {
                this.setFont(new FontUIResource(new Font(font.getName(), this.fontStyle, font.getSize() + this.fontExtraSize)));
            }
        }
    }

    private class BlendOverAnimation
    extends AbstractAnimation {
        public BlendOverAnimation(long duration) {
            super(duration, true);
        }

        @Override
        protected void applyEffect(long time) {
            int foregroundAlpha = (int)(255L * time / this.duration());
            int backgroundAlpha = 255 - foregroundAlpha;
            AnimatedLabel.this.setAlpha(foregroundAlpha, backgroundAlpha);
        }
    }
}

