/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.renderer.AbstractTextRenderer;
import com.jgoodies.common.base.Preconditions;
import java.awt.Graphics2D;

public final class BasicTextRenderer
extends AbstractTextRenderer {
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float space = 0.0f;

    public BasicTextRenderer(String text) {
        super(text);
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getSpace() {
        return this.space;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public void setSpace(float space) {
        this.space = space;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleX(float scaleX) {
        Preconditions.checkArgument((scaleX > 0.0f ? 1 : 0) != 0, (String)"scaleX must be positive.");
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        Preconditions.checkArgument((scaleY > 0.0f ? 1 : 0) != 0, (String)"scaleY must be positive.");
        this.scaleY = scaleY;
    }

    @Override
    public void render(Graphics2D g2, int width, int height) {
        this.ensureValidCache(g2);
        int glyphCount = this.cachedGlyphShapes.length;
        float totalSpace = (float)(glyphCount - 1) * this.space;
        float totalWidth = this.cachedTextWidth + totalSpace;
        float textHeight = this.getAdjustedAscent();
        float xOffset = this.getOffsetX() + ((float)width - totalWidth * this.scaleX) / 2.0f;
        float yOffset = this.getOffsetY() + ((float)height + textHeight * this.scaleY) / 2.0f - this.getAdjustedDescent();
        g2.setColor(this.getColor());
        g2.translate(xOffset, yOffset);
        g2.scale(this.scaleX, this.scaleY);
        for (int i = 0; i < glyphCount; ++i) {
            g2.fill(this.cachedGlyphShapes[i]);
            g2.translate(this.space, 0.0);
        }
        g2.scale(1.0f / this.scaleX, 1.0f / this.scaleY);
        g2.translate(-totalSpace - xOffset, -yOffset);
    }
}

