/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.wherenet.gps;

import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.ejb.geo.GeoOutFacadeRemote;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.io.IOException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GpsClientServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(GpsClientServlet.class);
    private GeoOutFacadeRemote geoOutFacade = null;

    public void destroy() {
        this.geoOutFacade = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InitialContext context = new InitialContext();
            this.geoOutFacade = (GeoOutFacadeRemote)context.lookup("rts/GeoOutFacade/remote");
        }
        catch (NamingException e) {
            log.error((Object)".", (Throwable)e);
        }
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String unitIDParam = request.getParameter("unitID");
        log.debug((Object)("UnitID = " + unitIDParam));
        long unitID = 0L;
        if (unitIDParam != null) {
            try {
                unitID = Long.parseLong(unitIDParam);
            }
            catch (NumberFormatException e) {
                log.error((Object)".", (Throwable)e);
            }
        }
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            if (this.geoOutFacade != null && unitID != 0L) {
                GeoStruct resultGeoStruct = null;
                resultGeoStruct = this.geoOutFacade.getNewestGeoEventFromCache(unitID);
                if (resultGeoStruct != null) {
                    String rmc = resultGeoStruct.getRmcRec();
                    log.debug((Object)("RMC: " + rmc));
                    String gga = resultGeoStruct.getGgaRec();
                    log.debug((Object)("GGA: " + gga));
                    GPSPosition position = new GPSPosition(rmc, gga, true);
                    StringBuilder result = new StringBuilder();
                    result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    result.append("<reponse>");
                    result.append("\t<input-param>\n");
                    result.append("\t\t<unitID>" + unitID + "</unitID>\n");
                    result.append("\t</input-param>\n");
                    result.append("\t<result>\n");
                    result.append("\t\t<rmc>" + rmc + "</rmc>\n");
                    result.append("\t\t<rmc-values>\n");
                    result.append("\t\t\t<time>" + position.getTimestamp() + "</time>\n");
                    result.append("\t\t\t<longitude-degree>" + position.getLongitudeArcDegree() + "</longitude-degree>\n");
                    result.append("\t\t\t<longitude-minute>" + position.getLongitudeArcMinute() + "</longitude-minute>\n");
                    result.append("\t\t\t<longitude-sec>" + position.getLongitudeArcSecond() + "</longitude-sec>\n");
                    result.append("\t\t\t<longitude-millisec>" + position.getLongitudeMSec() + "</longitude-millisec>\n");
                    result.append("\t\t\t<latitude-degree>" + position.getLatitudeArcDegree() + "</latitude-degree>\n");
                    result.append("\t\t\t<latitude-minute>" + position.getLatitudeArcMinute() + "</latitude-minute>\n");
                    result.append("\t\t\t<latitude-sec>" + position.getLatitudeArcSecond() + "</latitude-sec>\n");
                    result.append("\t\t\t<latitude-millisec>" + position.getLatitudeMSec() + "</latitude-millisec>\n");
                    result.append("\t\t\t<altitude>" + position.getAltitude() + "</altitude>\n");
                    result.append("\t\t\t<course>" + position.getCourse() + "</course>\n");
                    result.append("\t\t\t<latitude-indicator>" + position.getLatitudeIndicator() + "</latitude-indicator>\n");
                    result.append("\t\t\t<longitude-indicator>" + position.getLongitudeIndicator() + "</longitude-indicator>\n");
                    result.append("\t\t\t<speed>" + position.getSpeedMph() + "</speed>\n");
                    result.append("\t\t\t<tolerance>" + position.getTolerance() + "</tolerance>\n");
                    result.append("\t\t</rmc-values>\n");
                    result.append("\t\t<gga></gga>\n");
                    result.append("\t</result>\n");
                    result.append("</reponse>");
                    servletOutputStream.write(result.toString().getBytes());
                    servletOutputStream.flush();
                    servletOutputStream.close();
                } else {
                    StringBuilder result = new StringBuilder();
                    result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    result.append("<reponse>");
                    result.append("\t<input-param>\n");
                    result.append("\t\t<unitID>" + unitID + "</unitID>\n");
                    result.append("\t</input-param>\n");
                    result.append("\t<result>\n");
                    result.append("\t\tNo valid GPS data found with unidID " + unitID);
                    result.append("\t</result>\n");
                    result.append("</reponse>");
                    servletOutputStream.write(result.toString().getBytes());
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
            } else {
                StringBuilder result = new StringBuilder();
                result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                result.append("<reponse>");
                result.append("\t<input-param>\n");
                result.append("\t\t<unitID>" + unitID + "</unitID>\n");
                result.append("\t</input-param>\n");
                result.append("\t<result>\n");
                result.append("\t\tNo valid GPS data found with unidID " + unitID);
                result.append("\t</result>\n");
                result.append("</reponse>");
                servletOutputStream.write(result.toString().getBytes());
                servletOutputStream.flush();
                servletOutputStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Response outputStream not available.", (Throwable)e);
        }
    }
}

