/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.status;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.status.StatusLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.tomcat.util.modeler.Registry;

public class StatusServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(StatusServlet.class);
    protected MBeanServer mBeanServer = null;
    private StatusLocal status;
    private String ntpServer;
    private static final int DEFAULT_GOOD_THRESHOLD = 1000;
    private static final int DEFAULT_NOT_ACCEPTABLE_THRESHOLD = 5000;
    private int goodThreshold = 1000;
    private int notAcceptableThreshold = 5000;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String report = request.getParameter("report");
        log.debug((Object)("status report: " + report));
        if (report == null || report.length() == 0) {
            this.doStandardStatusReport(request, response);
        } else if (report.equals("memory")) {
            log.debug((Object)"memory report");
            this.doMemoryStatusReportFull(request, response);
        } else if (report.equals("memoryDetailed")) {
            log.debug((Object)"memoryDetailed report");
            this.doMemoryDetailedStatusReportFull(request, response);
        } else if (report.equals("threads")) {
            log.debug((Object)"thread report");
            this.doThreadStatusReportFull(request, response);
        } else if (report.equals("time")) {
            log.debug((Object)"time report");
            this.doTimeReportFull(request, response);
        }
    }

    protected void doStandardStatusReport(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.writeHeader(out);
            out.print("<p>EJBAccess: ");
            out.print(this.isEJBAccess());
            out.println("</p>");
            out.print("<p>EJBEntityRead: ");
            out.print(this.isEjbReadTest());
            out.println("</p>");
            out.print("<p>EJBEntityWrite: ");
            out.print(this.isEjbWriteTest());
            out.println("</p>");
            out.print("<p>EventServletPing: ");
            out.print(this.isEventServletPing());
            out.println("</p>");
            out.print("<p>EventEJBPing: ");
            out.print(this.isEventEJBPing());
            out.println("</p>");
            this.writeFooter(out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            out.close();
        }
    }

    protected void doMemoryDetailedStatusReport(PrintWriter out) throws ServletException, IOException {
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        long heapMax = heap.getMax();
        long heapInit = heap.getInit();
        long heapUsed = heap.getUsed();
        long heapCommitted = heap.getCommitted();
        long nonHeapMax = nonHeap.getMax();
        long nonHeapInit = nonHeap.getInit();
        long nonHeapUsed = nonHeap.getUsed();
        long nonHeapCommitted = nonHeap.getCommitted();
        out.print("<p><b>Heap</b></p>");
        out.print("<p>Max: ");
        out.print(heapMax);
        out.println("</p>");
        out.print("<p>Init: ");
        out.print(heapInit);
        out.println("</p>");
        out.print("<p>Used: ");
        out.print(heapUsed);
        out.println("</p>");
        out.print("<p>Committed: ");
        out.print(heapCommitted);
        out.println("</p>");
        out.print("<p><b>NonHeap</b></p>");
        out.print("<p>Max: ");
        out.print(nonHeapMax);
        out.println("</p>");
        out.print("<p>Init: ");
        out.print(nonHeapInit);
        out.println("</p>");
        out.print("<p>Used: ");
        out.print(nonHeapUsed);
        out.println("</p>");
        out.print("<p>Committed: ");
        out.print(nonHeapCommitted);
        out.println("</p>");
    }

    protected void doMemoryDetailedStatusReportFull(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.writeHeader(out);
            this.doMemoryDetailedStatusReport(out);
            this.writeFooter(out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            out.close();
        }
    }

    protected void doMemoryStatusReport(PrintWriter out) throws ServletException, IOException {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        out.print("<p>Total: ");
        out.print(totalMemory);
        out.println("</p>");
        out.print("<p>Max:   ");
        out.print(maxMemory);
        out.println("</p>");
        out.print("<p>Free:  ");
        out.print(freeMemory);
        out.println("</p>");
        out.print("<p>Used:  ");
        out.print(usedMemory);
        out.println("</p>");
    }

    protected void doMemoryStatusReportFull(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.writeHeader(out);
            this.doMemoryStatusReport(out);
            this.writeFooter(out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            out.close();
        }
    }

    protected void doThreadStatusReport(PrintWriter out) throws Exception {
        String queryString = "*:type=ThreadPool,*";
        ObjectName objectName = new ObjectName(queryString);
        Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            out.print("<p><b>");
            out.print(oi.getObjectName());
            out.println("</b></p>");
            out.print("<p>Max threads: ");
            out.print(this.mBeanServer.getAttribute(oi.getObjectName(), "maxThreads"));
            out.println("</p>");
            out.print("<p>Busy threads: ");
            out.print(this.mBeanServer.getAttribute(oi.getObjectName(), "currentThreadsBusy"));
            out.println("</p>");
        }
    }

    protected void doThreadStatusReportFull(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.writeHeader(out);
            this.doThreadStatusReport(out);
            this.writeFooter(out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "EFM Server Status Servlet";
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            InitialContext context = new InitialContext();
            this.status = (StatusLocal)context.lookup("rts/Status/local");
            this.mBeanServer = Registry.getServer();
            ConfigurationClient cc = new ConfigurationClient();
            this.ntpServer = cc.getParameter("statusServlet.time.ntpServer");
            this.goodThreshold = cc.getInteger("statusServlet.time.good");
            this.notAcceptableThreshold = cc.getInteger("statusServlet.time.notAcceptable");
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected boolean isEventServletPing() {
        try {
            URL url = new URL("http://localhost:8080/datain/e?p=servlet");
            return this.eventServletSuccessful(url);
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean eventServletSuccessful(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        if (connection.getContentLength() != 1) {
            throw new Exception("unexpected content length. url: " + url);
        }
        InputStream is = connection.getInputStream();
        if (is.read() != 1) {
            throw new Exception("unexpected ping response. url: " + url);
        }
        return true;
    }

    protected boolean isEventEJBPing() {
        try {
            URL url = new URL("http://localhost:8080/datain/e?p=ejb");
            return this.eventServletSuccessful(url);
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEJBAccess() {
        try {
            this.status.ping();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEjbReadTest() {
        try {
            this.status.ejbReadTest();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected boolean isEjbWriteTest() {
        try {
            this.status.ejbWriteTest();
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejbAccessTest into", (Throwable)ex);
            return false;
        }
    }

    protected void writeHeader(PrintWriter out) throws Exception {
        out.println("<html>");
        out.println("<head>");
        out.println("<title>EFM Server Status</title>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void writeFooter(PrintWriter out) throws Exception {
        out.println("</body>");
        out.println("</html>");
    }

    protected void doTimeReport(PrintWriter out) throws IOException {
        long currentTime = System.currentTimeMillis();
        out.print("<p>Current time:<br/>");
        out.print(new Date(currentTime));
        out.print("</p>");
        out.print("<p>Time(ms):<br/>");
        out.print(currentTime);
        out.print("</p>");
        if (StringUtils.trimToNull((String)this.ntpServer) != null) {
            NTPUDPClient ntpClient = new NTPUDPClient();
            InetAddress ntpServerAddress = InetAddress.getByName(this.ntpServer);
            TimeInfo timeInfo = ntpClient.getTime(ntpServerAddress);
            timeInfo.computeDetails();
            Long offsetValue = timeInfo.getOffset();
            Long delayValue = timeInfo.getDelay();
            String delay = delayValue == null ? "N/A" : delayValue.toString();
            Long offset = offsetValue == null ? 0L : offsetValue;
            out.print("<p>Clock offset(ms):<br/>");
            out.print(offset);
            out.print("</p>");
            out.print("<p>Roundtrip delay(ms):<br/>");
            out.print(delay);
            out.print("</p>");
            Date ntpServerTime = new Date(currentTime + offset);
            out.print("<p>NTP Server Time:<br/>");
            out.print(ntpServerTime);
            out.print("</p>");
            out.print("<p>NTP Server Time (ms):<br/>");
            out.print(currentTime + offset);
            out.print("</p>");
            OffsetState offsetState = this.getOffsetState(offset);
            switch (offsetState) {
                case GOOD: {
                    out.print("<p>Time quality:<br/>Perfect</p>");
                    break;
                }
                case ACCEPTABLE: {
                    out.print("<p>Time quality:<br/>Acceptable</p>");
                    break;
                }
                case NOT_ACCEPTABLE: {
                    out.print("<p>Time quality:<br/>Not acceptable</p>");
                }
            }
        }
    }

    protected OffsetState getOffsetState(Long offset) {
        if ((offset = Long.valueOf(Math.abs(offset))) < (long)this.goodThreshold) {
            return OffsetState.GOOD;
        }
        if (offset >= (long)this.notAcceptableThreshold) {
            return OffsetState.NOT_ACCEPTABLE;
        }
        return OffsetState.ACCEPTABLE;
    }

    protected void doTimeReportFull(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.writeHeader(out);
            this.doTimeReport(out);
            this.writeFooter(out);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            out.close();
        }
    }

    public static enum OffsetState {
        GOOD,
        NOT_ACCEPTABLE,
        ACCEPTABLE;

    }
}

