/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman;

import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeRemote;
import java.io.IOException;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanGeofServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(InfomanGeofServlet.class);
    private static final Log geoflog = LogFactory.getLog((String)"geoflog");
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final long serialVersionUID = 3233988243909211514L;
    private GeofencingUpdateFacadeRemote geofUpdateFacade;
    private String charsetName = "UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InitialContext context = new InitialContext();
            this.geofUpdateFacade = (GeofencingUpdateFacadeRemote)context.lookup("rts/GeofencingUpdateFacade/remote");
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to InfomanSetupFacade", (Throwable)ex);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String geof;
        long unitId;
        int geofVersion = 1;
        try {
            unitId = Long.parseLong(request.getParameter("u"));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            geoflog.error((Object)"runs into", (Throwable)ex);
            response.sendError(400, ex.getMessage());
            return;
        }
        try {
            geofVersion = Integer.parseInt(request.getParameter("gf"));
        }
        catch (NumberFormatException ex) {
            log.trace((Object)"No Geof Version Included");
        }
        if (geoflog.isDebugEnabled()) {
            geoflog.debug((Object)("Unit '" + unitId + "' requests Geofencing Areas"));
        }
        try {
            geof = geofVersion == 2 ? this.geofUpdateFacade.getUnitGeofAreasCsvV2(unitId) : this.geofUpdateFacade.getUnitGeofAreasCsvV1(unitId);
        }
        catch (Exception ex) {
            log.error((Object)("runs into " + ex.getMessage()));
            response.sendError(404, ex.getMessage());
            geoflog.error((Object)"runs into", (Throwable)ex);
            return;
        }
        if (geoflog.isDebugEnabled()) {
            geoflog.debug((Object)("GEOF for Unit '" + unitId + "length" + geof.length()));
            geoflog.debug((Object)("GEOF for Unit '" + unitId + "' -> " + geof));
        }
        response.setContentType("text/plain;charset=" + this.getCharsetName());
        ServletOutputStream out = response.getOutputStream();
        out.write(geof.getBytes(this.getCharsetName()));
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Provide the Access Geofencing Area List for an infoman";
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("parameter charsetName cannot be null");
        }
        this.charsetName = charsetName;
    }
}

