/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman;

import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserRemote;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanACLServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(InfomanACLServlet.class);
    private static final Log acllog = LogFactory.getLog((String)"acllog");
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final long serialVersionUID = 5629931036300147360L;
    private UnitUserRemote unitUser;
    private String charsetName = "UTF-8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InitialContext context = new InitialContext();
            this.unitUser = (UnitUserRemote)context.lookup("rts/UnitUser/remote");
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to InfomanSetupFacade", (Throwable)ex);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Set acl;
        long unitId;
        int maxACLSizeRequested;
        int permissionRequest = 0;
        try {
            maxACLSizeRequested = request.getIntHeader("prv-acl-max-size");
        }
        catch (NumberFormatException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            acllog.error((Object)"runs into", (Throwable)ex);
            response.sendError(400, ex.getMessage());
            return;
        }
        try {
            unitId = Long.parseLong(request.getParameter("u"));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            acllog.error((Object)"runs into", (Throwable)ex);
            response.sendError(400, ex.getMessage());
            return;
        }
        try {
            permissionRequest = Integer.parseInt(request.getParameter("perm"));
        }
        catch (NumberFormatException ex) {
            log.trace((Object)"No SCL requested");
        }
        if (acllog.isDebugEnabled()) {
            acllog.debug((Object)("Unit '" + unitId + "' requests ACL"));
        }
        try {
            acl = permissionRequest == 1 ? this.unitUser.getUserKeys(unitId, true) : this.unitUser.getUserKeys(unitId, false);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            acllog.error((Object)"runs into", (Throwable)ex);
            response.sendError(404, ex.getMessage());
            return;
        }
        if (acllog.isDebugEnabled()) {
            acllog.debug((Object)("ACL for Unit '" + unitId + "' size: " + acl.size()));
            acllog.debug((Object)("ACL for Unit '" + unitId + "' -> " + acl));
        }
        List<String> aclOut = this.sortACL(acl);
        if (maxACLSizeRequested > -1 && aclOut.size() > maxACLSizeRequested) {
            aclOut = aclOut.subList(0, maxACLSizeRequested);
            if (log.isWarnEnabled()) {
                log.warn((Object)("ACL truncated. unitId:" + unitId + " permissionRequest:" + permissionRequest + " maxACLSizeRequested:" + maxACLSizeRequested + " originalSize:" + acl.size()));
            }
        }
        response.setContentType("text/plain;charset=" + this.getCharsetName());
        ServletOutputStream out = response.getOutputStream();
        this.writeACL((OutputStream)out, aclOut);
        out.close();
    }

    protected void writeACL(OutputStream out, List<String> acl) throws IOException {
        for (String key : acl) {
            out.write(key.getBytes(this.getCharsetName()));
            out.write(10);
        }
    }

    protected List<String> sortACL(Set<String> acl) {
        ArrayList<String> aclOut = new ArrayList<String>(acl);
        Collections.sort(aclOut);
        return aclOut;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Provide the Access Control List for an infoman";
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("parameter charsetName cannot be null");
        }
        this.charsetName = charsetName;
    }
}

