/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressedEventServlet
extends AbstractEventServlet {
    private static final long serialVersionUID = 467528398303002495L;
    protected final Log log;

    public CompressedEventServlet() {
        this(LogFactory.getLog(CompressedEventServlet.class));
    }

    protected CompressedEventServlet(Log log) {
        this.log = log;
    }

    @Override
    protected MonitoringMBean createMonitoringMBean() throws Exception {
        return (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "CompressedEvents");
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.log.error((Object)"doGet(): calling with compressed data not allowed via GET !");
    }

    protected InputStream getContentStream(HttpServletRequest request) throws IOException {
        Object in = this.isRequestCompressed(request) ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
        return in;
    }

    protected boolean isDisabled() {
        return this.config.isHttpCompressedEventsDisabled();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Properties event;
        if (this.isDisabled()) {
            EventResponse eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
            this.sendResponse(eventResponse, new Properties(), response);
            return;
        }
        this.log.debug((Object)"doPost() POST mit komprimierten Daten verarbeiten...");
        this.getMonitoringMBean().increment();
        try {
            InputStream in = this.getContentStream(request);
            event = this.readEvent(in);
        }
        catch (IOException e) {
            event = new Properties();
            this.log.warn((Object)"doPost() runs into java.io.IOException while reading input stream", (Throwable)e);
        }
        EventResponse eventResponse = this.processEvent(request.getRemoteAddr(), event);
        this.sendResponse(eventResponse, event, response);
        this.log.debug((Object)"doPost() end");
    }

    public int getBinaryPayloadStart(byte[] event) {
        int length = event.length;
        for (int index = 0; index < length; ++index) {
            if (event[index] != 10 || index + 2 >= length || event[index + 1] != 10) continue;
            return index + 2;
        }
        return -1;
    }

    public Properties readEvent(InputStream in) throws IOException {
        ByteArrayInputStream eventIn;
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            if ((n = in.read(buffer)) <= -1) continue;
            out.write(buffer, 0, n);
        } while (n > -1);
        int index = this.getBinaryPayloadStart(out.toByteArray());
        byte[] binaryPayload = null;
        if (index == -1) {
            eventIn = new ByteArrayInputStream(out.toByteArray());
        } else {
            byte[] eventContent = new byte[index - 2];
            System.arraycopy(out.toByteArray(), 0, eventContent, 0, eventContent.length);
            eventIn = new ByteArrayInputStream(eventContent);
            binaryPayload = new byte[out.toByteArray().length - index];
            System.arraycopy(out.toByteArray(), index, binaryPayload, 0, binaryPayload.length);
        }
        Properties event = new Properties();
        event.load(eventIn);
        if (binaryPayload != null) {
            event.put("binary", binaryPayload);
        }
        return event;
    }
}

