/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.util;

import de.proveo.util.events.NotifyEvent;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.cache.DataCache;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationRemote;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionRemote;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFlightValue;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeRemote;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.xml.request.XmlRequestManager;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MapUtil {
    private static final Log log = LogFactory.getLog(MapUtil.class);
    private static MapUtil instance = null;
    private ConfigurationRemote configurationClient = null;
    private long infomanKeepaliveTimeoutMillis = 0L;
    private int observableNotifiesMaximumPerUnitPerDay = 0;
    private WwtVersionRemote wwtVersion = null;
    private String wwtImplVersion = null;
    private UnitTreeFacadeRemote unitTreeFacade = null;
    private String javaVersion = null;
    private static final ReentrantLock lock = new ReentrantLock();

    private MapUtil() {
        try {
            InitialContext context = new InitialContext();
            this.configurationClient = (ConfigurationRemote)context.lookup("rts/Configuration/remote");
            this.unitTreeFacade = (UnitTreeFacadeRemote)context.lookup("rts/UnitTreeFacade/remote");
            this.wwtVersion = (WwtVersionRemote)context.lookup("rts/WwtVersion/remote");
        }
        catch (NamingException e) {
            log.error((Object)"GSEDataLogic runs into NamingException: ", (Throwable)e);
        }
        this.javaVersion = System.getProperty("java.version");
        this.wwtImplVersion = this.wwtVersion.getVersionInfo("implVersion");
        long infomanKeepalvieTimeoutValue = Long.parseLong(this.getParameter("infoman.keepalive.timeout", "300"));
        this.infomanKeepaliveTimeoutMillis = infomanKeepalvieTimeoutValue * 60L * 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found infoman keepalive timeout '" + this.infomanKeepaliveTimeoutMillis + "'..."));
        }
        this.observableNotifiesMaximumPerUnitPerDay = Integer.parseInt(this.getParameter("observable.notifies.maximumPerUnitPerDay", "500"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found observable notifies maximumPerUnitPerDay '" + this.observableNotifiesMaximumPerUnitPerDay + "'..."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapUtil getInstance() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = new MapUtil();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    public Object deepClone(Serializable obj) {
        return SerializationUtils.clone((Serializable)obj);
    }

    public String getWwtImplVersion() {
        return this.wwtImplVersion;
    }

    public void addServerData(Map<String, Object> mcr) {
        MapUtil.getInstance().mapPutNullCheck(mcr, "Java_Version", this.javaVersion, false);
        MapUtil.getInstance().mapPutNullCheck(mcr, "RTS_Version", this.wwtImplVersion, false);
        MapUtil.getInstance().mapPutNullCheck(mcr, "ServerTimeZone", TimeZone.getDefault().getID(), false);
        MapUtil.getInstance().mapPutNullCheck(mcr, "ServerInfomanKeepaliveTimeout", this.infomanKeepaliveTimeoutMillis, false);
        MapUtil.getInstance().mapPutNullCheck(mcr, "ServerObservableNotifiesMaximumPerUnitPerDay", this.observableNotifiesMaximumPerUnitPerDay, false);
    }

    public void addXMLData(Map<String, Object> mcr, Map<String, Map<String, String>> namespaceAndParameters) {
        if (namespaceAndParameters != null && !namespaceAndParameters.isEmpty()) {
            XmlRequestManager xmlRequestManager = MapProxyFactory.getInstance().getXmlRequestManager();
            for (String namespace : namespaceAndParameters.keySet()) {
                Map<String, String> parameters;
                String xml = xmlRequestManager.handleRequest(namespace, parameters = namespaceAndParameters.get(namespace));
                if (xml == null) continue;
                MapUtil.getInstance().mapPutNullCheck(mcr, namespace, xml, false);
            }
        }
    }

    public void addTreeData(Map<String, Object> mcr, Set<Long> unitPermissions, long unitGroupId, boolean isAdmin) throws IOException, UnsupportedEncodingException {
        MapUtil.getInstance().mapPutNullCheck(mcr, "unitTreeXML", this.getUnitTree(unitPermissions, isAdmin, unitGroupId), false);
    }

    public void addReplayTreeData(Map<String, Object> mcr, Set<Long> unitPermissions, long unitGroupId, boolean isAdmin) throws IOException, UnsupportedEncodingException {
        MapUtil.getInstance().mapPutNullCheck(mcr, "unitTreeXML", this.getReplayUnitTree(unitPermissions, isAdmin, unitGroupId), false);
    }

    public Map<String, Object> createFittingUnitEventMap(SerializableEventWrapper eventWrapper) {
        String method = "createFittingUnitEventMap(): ";
        HashMap eventMap = null;
        String eventType = eventWrapper.get_typeOfEvent();
        if (eventType.equals("GeoStructHistoryAndCache")) {
            GdataCache event = (GdataCache)eventWrapper.get_cacheValue();
            eventMap = this.getGeoEventMap(event);
        } else if (eventType.equals("StateEventHistoryAndCache")) {
            StateCache event = (StateCache)eventWrapper.get_cacheValue();
            eventMap = this.getStateEventMap(event);
        } else if (eventType.equals("MeasurementHistoryAndCache")) {
            MeasurementCache event = (MeasurementCache)eventWrapper.get_cacheValue();
            eventMap = this.getMeasurementEventMap(event);
        } else if (eventType.equals("KeepAlive")) {
            KeepAliveEvent event = (KeepAliveEvent)eventWrapper.get_cacheValue();
            eventMap = this.getKeepaliveEventMap(event);
        } else if (eventType.equals("InfomanMessages")) {
            ScanmanMsgHistory event = (ScanmanMsgHistory)eventWrapper.get_cacheValue();
            eventMap = this.getInfomanEventMap(event);
        } else if (eventType.equals("InfomanNotifyMessages")) {
            NotifyEvent event = (NotifyEvent)eventWrapper.get_cacheValue();
            eventMap = this.getNotifyEventMap(event);
        } else if (eventType.equals("UseEvent")) {
            UseEvent event = (UseEvent)eventWrapper.get_cacheValue();
            eventMap = this.getUseEventMap(event);
        } else {
            log.error((Object)(method + "Cannot create fitting event map, found unknown event type '" + eventType + "' in SerializableEventWrapper!"));
        }
        return eventMap;
    }

    public Map<String, Object> createFittingStandEventMap(SerializableEventWrapper eventWrapper) {
        String method = "createFittingStandEventMap(): ";
        Map<String, Object> eventMap = null;
        String eventType = eventWrapper.get_typeOfEvent();
        if (eventType.equals("StandEvent")) {
            StandStateCacheValue event = (StandStateCacheValue)eventWrapper.get_cacheValue();
            eventMap = this.getStandEventMap(event);
        } else {
            log.error((Object)(method + "Cannot create fitting event map, found unknown event type '" + eventType + "' in SerializableEventWrapper!"));
        }
        return eventMap;
    }

    private HashMap<String, Object> getGeoEventMap(GdataCache gdataCache) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "GeoStruct", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", gdataCache.getUnitId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GeoBegin", gdataCache.getBeginTime(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GpsRmc", gdataCache.getRmcRec(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GpsGga", gdataCache.getGgaRec(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GpsTrusted", gdataCache.getTrusted(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GpsLatMsec", gdataCache.getLatMsec(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "GpsLongMsec", gdataCache.getLongMsec(), false);
        String areaName = "-";
        String areaDesc = "(not defined)";
        Integer areaId = gdataCache.getAreaId();
        if (areaId != null && areaId > -1) {
            Map<String, String> area = DataCache.getInstance().getCachedArea(areaId);
            if (area != null) {
                String desc;
                String name = area.get("Area");
                if (name != null && name.trim().length() != 0) {
                    areaName = name;
                }
                if ((desc = area.get("AreaName")) != null && desc.trim().length() != 0) {
                    areaDesc = desc;
                }
            } else {
                log.error((Object)("Could not find area with id '" + areaId + "' in area cache."));
            }
        } else {
            log.trace((Object)("Empty area in CURRENT_GDATA_CACHE for unitId '" + gdataCache.getUnitId() + "'. Seems like GSE is out of space."));
        }
        MapUtil.getInstance().mapPutNullCheck(valueMap, "Area", areaName, false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "AreaName", areaDesc, false);
        return valueMap;
    }

    private HashMap getKeepaliveEventMap(KeepAliveEvent keepAliveEvent) {
        long timeStamp = keepAliveEvent.getCreateTimestamp();
        boolean timeout = false;
        if (System.currentTimeMillis() - timeStamp > this.infomanKeepaliveTimeoutMillis) {
            timeout = true;
        }
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "KeepAliveEvent", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", keepAliveEvent.getUnitId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "KeepaliveTimestamp", timeStamp, false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "KeepaliveTimeout", timeout, false);
        return valueMap;
    }

    private HashMap getNotifyEventMap(NotifyEvent notifyEvent) {
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "data_type_notification_event", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "NotifyTimestamp", notifyEvent.getTimestamp(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "NotifyEntry", notifyEvent.isEntry(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "NotifyMessageID", notifyEvent.getMessageId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "NotifyMessage", notifyEvent.getMessage(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "NotifyReceiveTime", notifyEvent.getReceiveTime(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", notifyEvent.getUnitId(), false);
        return valueMap;
    }

    private HashMap getInfomanEventMap(ScanmanMsgHistory scanmanMsgHistoryValue) {
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "data_type_infoman_event", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", scanmanMsgHistoryValue.getUnitId(), false);
        if (scanmanMsgHistoryValue.getType() == 9 || scanmanMsgHistoryValue.getType() == 25 || scanmanMsgHistoryValue.getType() == 10) {
            if (scanmanMsgHistoryValue.getType() == 9) {
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmErrorTimestamp", scanmanMsgHistoryValue.getCreateTime(), false);
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmErrorMessage", scanmanMsgHistoryValue.getMessage(), true);
            } else if (scanmanMsgHistoryValue.getType() == 25) {
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmBootTimestamp", scanmanMsgHistoryValue.getCreateTime(), false);
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmBootMessage", scanmanMsgHistoryValue.getMessage(), true);
            } else if (scanmanMsgHistoryValue.getType() == 10) {
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmIpTimestamp", scanmanMsgHistoryValue.getCreateTime(), false);
                MapUtil.getInstance().mapPutNullCheck(valueMap, "SmIpMessage", scanmanMsgHistoryValue.getMessage(), true);
            }
        }
        return valueMap;
    }

    private HashMap getStateEventMap(StateCache stateEvent) {
        int stateModelId = stateEvent.getStateModelId();
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "StateEvent", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", stateEvent.getUnitId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "StateModelID", stateModelId, false);
        HashMap stateMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(stateMap, "StateId", stateEvent.getStateId(), false);
        MapUtil.getInstance().mapPutNullCheck(stateMap, "StateBegin", stateEvent.getBeginTime(), false);
        MapUtil.getInstance().mapPutNullCheck(stateMap, "StateRemark", stateEvent.getRemark(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "StateModel_" + stateModelId, stateMap, false);
        return valueMap;
    }

    private HashMap getMeasurementEventMap(MeasurementCache measurementEvent) {
        int measurementDefnId = measurementEvent.getMeasurementDefinitionId();
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "MeasurementEvent", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", measurementEvent.getUnitId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "MeasurementDefnID", measurementDefnId, false);
        HashMap measurementMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(measurementMap, "MeasurementValue", Float.valueOf(measurementEvent.getValue()), false);
        MapUtil.getInstance().mapPutNullCheck(measurementMap, "MeasurementBegin", measurementEvent.getBeginTime(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "Measurement_" + measurementDefnId, measurementMap, false);
        return valueMap;
    }

    public Map<String, Map<String, String>> getParametersForXMLSchemas(String schemasAndParametersString) throws Exception {
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        String[] schemasAndParametersArray = null;
        if (schemasAndParametersString == null) {
            schemasAndParametersArray = null;
        } else if (schemasAndParametersString.contains(",")) {
            schemasAndParametersArray = StringUtils.split((String)schemasAndParametersString, (String)",");
        } else if (schemasAndParametersString.trim().length() > 0) {
            schemasAndParametersArray = new String[]{schemasAndParametersString};
        }
        if (schemasAndParametersArray == null || schemasAndParametersArray.length == 0) {
            return ret;
        }
        for (String schemaAndParametersString : schemasAndParametersArray) {
            HashMap params = new HashMap();
            String schemaNamespace = schemaAndParametersString;
            if (schemaAndParametersString.contains("(")) {
                String[] namespaceAndParameters = StringUtils.split((String)schemaAndParametersString, (String)"(");
                schemaNamespace = namespaceAndParameters[0];
                if (namespaceAndParameters.length == 2) {
                    String[] parametersArray;
                    String parameters = namespaceAndParameters[1];
                    for (String p : parametersArray = StringUtils.split((String)parameters, (String)" ")) {
                        String[] param = StringUtils.split((String)p, (String)"=");
                        if (param.length == 2) {
                            MapUtil.getInstance().mapPutNullCheck(params, param[0], param[1], false);
                            continue;
                        }
                        log.error((Object)("Parameter could not be parsed: " + p));
                    }
                }
            }
            if (params.isEmpty()) {
                params = null;
            }
            MapUtil.getInstance().mapPutNullCheck(ret, schemaNamespace, params, true);
        }
        return ret;
    }

    private String getUnitTree(Set<Long> unitPermissions, boolean admin, long unitGroupId) throws UnsupportedEncodingException {
        UnitTreeNode rootUnitNode = this.unitTreeFacade.getAirportMapTreeModel(unitPermissions);
        UnitTreeNode unitGroupNode = this.findUnitGroupNode(rootUnitNode, unitGroupId);
        if (unitGroupNode != null) {
            rootUnitNode = unitGroupNode;
        }
        Map<Long, Map> unitTree = this.builUnitTreeMap(rootUnitNode, admin);
        return this.parseObjectToXMLString(unitTree);
    }

    private String getReplayUnitTree(Set<Long> unitPermissions, boolean admin, long unitGroupId) throws UnsupportedEncodingException {
        Map<Object, Object> unitTree = new HashMap();
        if (unitPermissions != null && !unitPermissions.isEmpty()) {
            UnitTreeNode rootUnitNode = this.unitTreeFacade.getAirportMapReplayTreeModel(unitPermissions);
            UnitTreeNode unitGroupNode = this.findUnitGroupNode(rootUnitNode, unitGroupId);
            if (unitGroupNode != null) {
                rootUnitNode = unitGroupNode;
            }
            unitTree = this.builUnitTreeMap(rootUnitNode, admin);
        }
        return this.parseObjectToXMLString(unitTree);
    }

    private Map<String, Object> getStandEventMap(StandStateCacheValue standEvent) {
        StandStateCacheValue.PK primaryKey = standEvent.getPk();
        long stateModelId = primaryKey.getStateModelId();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "fstd", "Stand_" + primaryKey.getStand(), false);
        HashMap stateMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(stateMap, "stateId", standEvent.getStateId(), false);
        FISFlightValue inboundFlight = standEvent.getInbFlight();
        Map<String, Object> inboundFlightMap = this.getFlightMap(inboundFlight, true);
        FISFlightValue outboundFlight = standEvent.getOutbFlight();
        Map<String, Object> outboundFlightMap = this.getFlightMap(outboundFlight, false);
        MapUtil.getInstance().mapPutNullCheck(stateMap, "inbound", inboundFlightMap, false);
        MapUtil.getInstance().mapPutNullCheck(stateMap, "outbound", outboundFlightMap, false);
        String aircraftType = "";
        String registration = "";
        if (inboundFlight != null) {
            aircraftType = inboundFlight.getAircraftType();
            if (aircraftType == null) {
                aircraftType = "";
            }
            if ((registration = inboundFlight.getRegistration()) == null) {
                registration = "";
            }
            if (outboundFlight != null) {
                String tmpAircraftType = outboundFlight.getAircraftType();
                if (tmpAircraftType == null) {
                    tmpAircraftType = "";
                }
                if (aircraftType.trim().length() == 0) {
                    aircraftType = tmpAircraftType;
                } else if (tmpAircraftType.trim().length() != 0 && !tmpAircraftType.equals(aircraftType)) {
                    log.error((Object)("Different aircraft type in inbound and outbound flight! Inbound = '" + aircraftType + "' Outbound = '" + tmpAircraftType + "'. Assuming that inbound is correct ..."));
                }
                String tmpRegistration = outboundFlight.getRegistration();
                if (tmpRegistration == null) {
                    tmpRegistration = "";
                }
                if (registration.trim().length() == 0) {
                    registration = tmpRegistration;
                } else if (tmpRegistration.trim().length() != 0 && !tmpRegistration.equals(registration)) {
                    log.error((Object)("Different registration in inbound and outbound flight! Inbound = '" + registration + "' Outbound = '" + tmpRegistration + "'. Assuming that inbound is correct ..."));
                }
            }
        } else if (outboundFlight != null) {
            aircraftType = outboundFlight.getAircraftType();
            if (aircraftType == null) {
                aircraftType = "";
            }
            if ((registration = outboundFlight.getRegistration()) == null) {
                registration = "";
            }
        }
        MapUtil.getInstance().mapPutNullCheck(stateMap, "AircraftType", aircraftType, false);
        MapUtil.getInstance().mapPutNullCheck(stateMap, "reg", registration, false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "StateModel_" + stateModelId, stateMap, false);
        return valueMap;
    }

    private Map<String, Object> getFlightMap(FISFlightValue flightEvent, boolean inbound) {
        long bestTime = 0L;
        long estimatedTime = 0L;
        long scheduledTime = 0L;
        long onOffBlock = 0L;
        String flightNumber = "";
        String flightType = "";
        String movementType = "";
        String origin = "";
        String destination = "";
        if (flightEvent != null) {
            bestTime = flightEvent.getBestTime();
            estimatedTime = flightEvent.getEstimatedTime();
            scheduledTime = flightEvent.getScheduledTime();
            onOffBlock = flightEvent.getOnOffBlockTime();
            flightNumber = flightEvent.getFlightNumber();
            if (flightNumber == null) {
                flightNumber = "";
            }
            if ((flightType = flightEvent.getFlightNature()) == null) {
                flightType = "";
            }
            if ((movementType = flightEvent.getMovementType()) == null) {
                movementType = "";
            }
            if ((origin = flightEvent.getOrigin()) == null) {
                origin = "";
            }
            if ((destination = flightEvent.getDestination()) == null) {
                destination = "";
            }
        }
        HashMap<String, Object> flightMap = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(flightMap, "flightNo", flightNumber, false);
        MapUtil.getInstance().mapPutNullCheck(flightMap, "flightType", flightType, false);
        MapUtil.getInstance().mapPutNullCheck(flightMap, "movementType", movementType, false);
        MapUtil.getInstance().mapPutNullCheck(flightMap, "estimatedTime", estimatedTime, false);
        MapUtil.getInstance().mapPutNullCheck(flightMap, "scheduledTime", scheduledTime, false);
        MapUtil.getInstance().mapPutNullCheck(flightMap, "oBlock", onOffBlock, false);
        if (inbound) {
            MapUtil.getInstance().mapPutNullCheck(flightMap, "origin", origin, false);
            MapUtil.getInstance().mapPutNullCheck(flightMap, "starttime", bestTime, false);
        } else {
            MapUtil.getInstance().mapPutNullCheck(flightMap, "destination", destination, false);
            MapUtil.getInstance().mapPutNullCheck(flightMap, "endtime", bestTime, false);
        }
        return flightMap;
    }

    private HashMap getUseEventMap(UseEvent useEvent) {
        HashMap valueMap = new HashMap();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "EventType", "UseEvent", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventUserKey", useEvent.getUserKey(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventDriverName", useEvent.getUserName(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventPersonalNumber", useEvent.getPersonalNumber(), true);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UnitId", useEvent.getUnitId(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventTimestamp", useEvent.getTimestamp(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventLogin", useEvent.isLogin(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "UseEventReceiveTime", useEvent.getReceiveTime(), false);
        return valueMap;
    }

    public String getParameter(String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = defaultValue != null ? this.configurationClient.getParameter(key, defaultValue) : this.configurationClient.getParameter(key);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"getParameter runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
        return value;
    }

    public long getAirportId(String unitGroupIdFromParameters) {
        String method = "getUnitGroupId(): ";
        long unitGroupId = -1L;
        try {
            if (MapUtil.getInstance().isParameterConfigured("airport.groupId")) {
                Long airportId = Long.parseLong(MapUtil.getInstance().getParameter("airport.groupId", null));
                log.debug((Object)(method + "Use airport id '" + airportId + "' from configuration."));
                unitGroupId = airportId;
            }
        }
        catch (Throwable ex) {
            log.error((Object)(method + "Could not get configuration parameter \"airport.groupId\""), ex);
        }
        if (unitGroupId == -1L) {
            if (unitGroupIdFromParameters != null) {
                try {
                    unitGroupId = Long.valueOf(unitGroupIdFromParameters);
                    log.debug((Object)(method + "Given unit group ID is: '" + unitGroupId + "'"));
                }
                catch (Throwable ex) {
                    log.debug((Object)("Given unit group ID isn't a long value: '" + unitGroupIdFromParameters + "'"));
                }
            } else {
                log.warn((Object)(method + "Given unitGroupId from client request parameters was null, return '" + unitGroupId + "' as airport id."));
            }
        }
        return unitGroupId;
    }

    public boolean isStandsLogicEnabled() {
        return this.configurationClient.getBoolean("observable.stands.running", false);
    }

    public boolean isParameterConfigured(String key) {
        boolean value = false;
        try {
            value = this.configurationClient.isConfigured(key);
        }
        catch (Throwable e) {
            log.error((Object)"isParameterConfigured runs into", e);
        }
        return value;
    }

    public void mapPutNullCheck(Map map, Object key, Object value, boolean couldBeNull) {
        String method = "mapPutNullCheck(" + key + "): ";
        if (!couldBeNull && value == null) {
            log.warn((Object)(method + "Value for given key is null!"), (Throwable)new RuntimeException());
        }
        map.put(key, value);
    }

    private String parseObjectToXMLString(Object obj) throws UnsupportedEncodingException {
        ByteArrayOutputStream unitTreeXML = new ByteArrayOutputStream();
        XMLEncoder resultEncoder = new XMLEncoder(unitTreeXML);
        resultEncoder.setPersistenceDelegate(UnitTreeNode.class, new DefaultPersistenceDelegate(new String[]{"unitModelValue", "unitIdentityValue", "unitTypeIdentityValue"}));
        resultEncoder.writeObject(obj);
        resultEncoder.close();
        return new String(unitTreeXML.toByteArray(), "utf-8");
    }

    private Map<Long, Map> builUnitTreeMap(UnitTreeNode unitNode, boolean admin) {
        HashMap treeNodeMap = new HashMap<Long, Map>();
        if (unitNode == null) {
            return treeNodeMap;
        }
        UnitDTO unitDTO = (UnitDTO)unitNode.getData();
        UnitModel unitModelValue = unitDTO.getUnitModel();
        UnitIdentity unitIdentityValue = unitDTO.getUnitIdentity();
        UnitTypeIdentity unitTypeIdentityValue = unitDTO.getUnitTypeIdentity();
        long unitId = unitModelValue.getUnitId();
        String name = unitIdentityValue.getName();
        String imageName = unitIdentityValue.getImageName();
        if (imageName == null || imageName.trim().length() == 0) {
            imageName = unitTypeIdentityValue.getImageName();
        }
        if (!unitModelValue.getBasic()) {
            List children = unitNode.getChildren();
            HashMap value = new HashMap();
            MapUtil.getInstance().mapPutNullCheck(value, "name", name, false);
            MapUtil.getInstance().mapPutNullCheck(value, "imageName", imageName, true);
            MapUtil.getInstance().mapPutNullCheck(value, "allowsChildren", true, false);
            if (children != null) {
                ArrayList<Map<Long, Map>> childsList = new ArrayList<Map<Long, Map>>();
                for (UnitTreeNode childUnitNode : children) {
                    Map<Long, Map> childTreeNode = this.builUnitTreeMap(childUnitNode, admin);
                    childsList.add(childTreeNode);
                }
                MapUtil.getInstance().mapPutNullCheck(value, "children", childsList, false);
            }
            treeNodeMap = new HashMap();
            MapUtil.getInstance().mapPutNullCheck(treeNodeMap, unitId, value, false);
        } else {
            HashMap value = new HashMap();
            if (admin) {
                MapUtil.getInstance().mapPutNullCheck(value, "name", name + " (" + unitId + ")", false);
            } else {
                MapUtil.getInstance().mapPutNullCheck(value, "name", name, false);
            }
            MapUtil.getInstance().mapPutNullCheck(value, "imageName", imageName, true);
            MapUtil.getInstance().mapPutNullCheck(value, "allowsChildren", false, false);
            treeNodeMap = new HashMap();
            MapUtil.getInstance().mapPutNullCheck(treeNodeMap, unitId, value, false);
        }
        return treeNodeMap;
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode, long unitGroupId) {
        List children;
        if (unitNode == null || unitGroupId == -1L) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModel unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModel();
        long unitId = unitModelValue.getUnitId();
        if (unitId == unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode, unitGroupId);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }
}

