/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.timer;

import de.proveo.web.map.components.event.AbstractEventHandler;
import de.proveo.web.map.components.event.MapProxyFactory;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkUpdateTask
implements Runnable {
    private static final Log log = LogFactory.getLog(BulkUpdateTask.class);
    private AbstractEventHandler eventHandler = null;

    public BulkUpdateTask(AbstractEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void run() {
        if (this.eventHandler != null) {
            String method;
            block6: {
                String clientName = this.eventHandler.getClientName();
                method = "*[" + this.eventHandler.getName() + "]* ClientID='" + clientName + "' -> run(): ";
                try {
                    this.eventHandler.sendAllBulkDataToClient();
                }
                catch (IOException e) {
                    if (this.eventHandler.getMapProxy() != null && !this.eventHandler.getMapProxy().isShuttingDown()) {
                        log.error((Object)(method + "runs into IOException! Problems while sending scheduled bulk data for " + this.eventHandler.getName() + "! Shutdown client ..."), (Throwable)e);
                        MapProxyFactory.getInstance().removeProxy(this.eventHandler.getMapProxy());
                    }
                }
                catch (Throwable e) {
                    if (this.eventHandler.getMapProxy() == null || this.eventHandler.getMapProxy().isShuttingDown()) break block6;
                    log.error((Object)(method + "sending scheduled bulk data for " + this.eventHandler.getName() + " runs into unknown exception! Shutdown client ..."), e);
                    MapProxyFactory.getInstance().removeProxy(this.eventHandler.getMapProxy());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Timer sent bulk to the client!"));
            }
        }
    }
}

