/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.replay;

import de.proveo.web.map.communication.stream.HTTPConnection;
import de.proveo.web.map.components.replay.ReplayMapProxy;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayServlet
extends HttpServlet {
    private static final long serialVersionUID = -2985636220991187191L;
    private static final Log log = LogFactory.getLog(ReplayServlet.class);
    private static final String CONTENT_TYPE = "application/octet-stream";

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.warn((Object)"doGet(): use POST instead of GET !");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = "doPost(): ";
        response.setContentType(CONTENT_TYPE);
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        if (username == null || password == null) {
            log.warn((Object)(method + "username or password not given"));
        } else {
            try {
                Object accessPermittedObj;
                boolean accessPermitted = false;
                boolean isAdmin = false;
                boolean isSuperAdmin = false;
                boolean replayRole = false;
                LoginContextUtil lcu = new LoginContextUtil(username, password);
                lcu.fetchPermissions();
                HashMap responseMap = lcu.login4AirportMap();
                if (responseMap != null && (accessPermittedObj = responseMap.get("AccessPermitted")) != null && (accessPermitted = Boolean.valueOf(accessPermittedObj.toString()).booleanValue())) {
                    isSuperAdmin = lcu.isSuperAdmin();
                    isAdmin = isSuperAdmin;
                    if (!isAdmin) {
                        isAdmin = lcu.isUserInRole("section.airportmap_admin");
                    }
                    replayRole = lcu.isUserInRole("section.airportmap.replay");
                }
                if (accessPermitted) {
                    log.debug((Object)(method + "login done."));
                    this.handleRequest(request, response, username, isAdmin, isSuperAdmin, replayRole);
                } else {
                    log.debug(method + "login failed. Reason: " + responseMap != null ? responseMap.get("ReasonCode") : "unknown?!");
                }
            }
            catch (Throwable e1) {
                log.error((Object)(method + "Login in ReplayServlet failed"), e1);
            }
        }
    }

    private long getTimeParameter(HttpServletRequest request, String key) throws ServletException {
        String par = request.getParameter(key);
        if (par == null) {
            String msg = "URL parameter '" + key + "' missing !";
            log.error((Object)msg);
            throw new ServletException(msg);
        }
        long val = Long.parseLong(par);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response, String username, boolean isAdmin, boolean isSuperAdmin, boolean isInReplayRole) throws ServletException, IOException {
        String method = "handleRequest(): ";
        log.debug((Object)(method + "start"));
        String unitGroupIdStr = request.getParameter("unitGroupId");
        long unitGroupId = MapUtil.getInstance().getAirportId(unitGroupIdStr);
        long requestedBeginTime = this.getTimeParameter(request, "beginTime");
        long requestedEndTime = this.getTimeParameter(request, "endTime");
        if (requestedBeginTime <= 0L || requestedEndTime <= 0L || requestedBeginTime > requestedEndTime) {
            String returnMsg = "begin/end time combination not allowed ! (" + requestedBeginTime + "/" + requestedEndTime + ")";
            log.error((Object)returnMsg);
            throw new ServletException(returnMsg);
        }
        HTTPConnection connection = new HTTPConnection(request, response);
        ReplayMapProxy replayClient = new ReplayMapProxy(connection, unitGroupId, username, isAdmin, isSuperAdmin, isInReplayRole);
        log.debug((Object)(method + "ReplayClient started..."));
        replayClient.setTime(requestedBeginTime, requestedEndTime);
        replayClient.collectAndSendData();
        log.debug((Object)(method + "ReplayClient has sent data."));
        try {
            ReplayServlet replayServlet = this;
            synchronized (replayServlet) {
                while (replayClient.isRunning()) {
                    ((Object)((Object)this)).wait(1000L);
                }
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)(method + "runs into"), (Throwable)ex);
        }
        finally {
            log.debug((Object)"handleRequest ended...");
        }
    }
}

