/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.replay;

import de.proveo.util.date.DateUtil;
import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.web.map.communication.stream.Connection;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.web.map.timer.MapPingTask;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.ejb.dataOut.replay.ReplayDataFacadeRemote;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayMapProxy
implements PingThreadListener {
    private static final Log log = LogFactory.getLog(ReplayMapProxy.class);
    private final Object deleteLock = new Object();
    protected Connection connection = null;
    private boolean isReplayClientDeleted = false;
    private long toTime = 1L;
    private long fromTime = 1L;
    private ReplayDataFacadeRemote replayDataFacade;
    private long unitGroupId;
    private String username;
    private boolean isAdmin;
    private boolean isSuperAdmin;
    private boolean isInReplayRole;
    private ScheduledFuture pingTask = null;
    private ScheduledThreadPoolExecutor threadPoolExecutor = null;
    private int period = 15000;
    private boolean running = true;

    public ReplayMapProxy(Connection connection, long unitGroupId, String username, boolean isAdmin, boolean isSuperAdmin, boolean isInReplayRole) {
        this.connection = connection;
        this.username = username;
        this.isAdmin = isAdmin;
        this.isSuperAdmin = isSuperAdmin;
        this.isInReplayRole = isInReplayRole;
        this.unitGroupId = unitGroupId;
        this.threadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.startPingThread();
        try {
            InitialContext context = new InitialContext();
            this.replayDataFacade = (ReplayDataFacadeRemote)context.lookup("rts/ReplayDataFacade/remote");
            this.period = Integer.parseInt(MapUtil.getInstance().getParameter("observable.pingthread.latency", null));
        }
        catch (NamingException e) {
            log.error((Object)"ReplayClient() runs into NamingException: ", (Throwable)e);
        }
        catch (NumberFormatException e) {
            log.error((Object)"ReplayClient() runs into NumberFormatException: ", (Throwable)e);
        }
    }

    public void setTime(long from, long to) {
        this.fromTime = from;
        this.toTime = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAndSendData() {
        String method = "collectAndSendData: ";
        try {
            log.debug((Object)(method + "start."));
            boolean sendUnitsData = false;
            boolean sendNotifiesData = false;
            boolean sendUseMsgsData = false;
            boolean sendInfomanMsgsData = false;
            boolean sendStandsData = false;
            String typesOfInterest = this.connection.getServletParameters().getProperty("TypeOfInterest", "");
            if (typesOfInterest.indexOf("units") != -1) {
                sendUnitsData = true;
            }
            if (typesOfInterest.indexOf("notify_messages") != -1) {
                sendNotifiesData = true;
            }
            if (typesOfInterest.indexOf("use_messages") != -1) {
                sendUseMsgsData = true;
            }
            if (typesOfInterest.indexOf("infoman_messages") != -1) {
                sendInfomanMsgsData = true;
            }
            if (typesOfInterest.indexOf("stands") != -1 && !(sendStandsData = MapUtil.getInstance().isStandsLogicEnabled())) {
                log.warn((Object)"FIS server logic is deactivated but an airport map tries to retrieve FIS replay data!");
            }
            HashMap<String, Object> stamps = new HashMap<String, Object>();
            if (this.isAdmin || this.isInReplayRole) {
                if (this.fromTime < this.toTime) {
                    String sFrom = DateUtil.getDatestring4Timestamp((long)this.fromTime);
                    String sTo = DateUtil.getDatestring4Timestamp((long)this.toTime);
                    log.debug((Object)(method + "*** fetch ReplayData for time frame " + sFrom + " - " + sTo));
                    HashSet<Long> unitPermissions = new HashSet<Long>();
                    HashMap replayData = this.replayDataFacade.getReplayData(this.unitGroupId, this.fromTime, this.toTime, this.username, this.isAdmin, this.isSuperAdmin, sendUnitsData, sendNotifiesData, sendUseMsgsData, sendInfomanMsgsData, sendStandsData);
                    if (sendUnitsData) {
                        Object unitIdentitiesObj;
                        String stateModelSchemas = MapProxyFactory.getInstance().getXMLSchemas(this.connection);
                        try {
                            Map<String, Map<String, String>> stateModelNamespacesAndParameters = MapUtil.getInstance().getParametersForXMLSchemas(stateModelSchemas);
                            MapUtil.getInstance().addXMLData(stamps, stateModelNamespacesAndParameters);
                        }
                        catch (Throwable ex) {
                            log.error((Object)(method + "Could not parse state model schemas: " + stateModelSchemas), ex);
                        }
                        Map initialContext = (Map)replayData.get("InitialContext");
                        if (initialContext != null && (unitIdentitiesObj = initialContext.get("unitIdentityValues")) != null) {
                            HashMap unitIdentities = (HashMap)unitIdentitiesObj;
                            unitPermissions = new HashSet(unitIdentities.keySet());
                        }
                        try {
                            MapUtil.getInstance().addReplayTreeData(stamps, unitPermissions, this.unitGroupId, this.isAdmin);
                        }
                        catch (Throwable e) {
                            log.error((Object)(method + "Adding replay unit tree runs into"), e);
                        }
                    }
                    if (!sendStandsData && sendUnitsData && unitPermissions.isEmpty()) {
                        stamps.clear();
                        stamps.put("ReplayError", "ReplayErrorNoUnitPermissions");
                        log.error((Object)(method + "Current user has no unit permissions! Break."));
                    } else {
                        MapUtil.getInstance().addServerData(stamps);
                        stamps.putAll(replayData);
                    }
                } else {
                    stamps.put("ReplayError", "ReplayErrorInvalidTimeframe");
                    log.error((Object)(method + "Invalid timeframe (begin=" + this.fromTime + " / end=" + this.toTime + ")! Break."));
                }
            } else {
                stamps.put("ReplayError", "ReplayErrorUserNotInRole");
                log.error((Object)(method + "Replay not available for current user! Break."));
            }
            log.debug((Object)(method + "replay data will be send"));
            this.sendResponse(stamps);
            log.debug((Object)(method + "all data flushed"));
        }
        catch (RemoteException e) {
            log.error((Object)(method + "RemoteException occurs."), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)(method + "IOException occurs."), (Throwable)e);
        }
        finally {
            this.connection.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Calling deleteReplayClient() ..."));
            }
            this.deleteReplayClient();
        }
    }

    public void sendResponse(Object response) throws IOException {
        String method = "sendResponse(): ";
        this.connection.sendObject(response);
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Message sent to client."));
        }
    }

    public void ping() {
        try {
            this.sendResponse("p");
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ping() runs into IOException! Probably the client was shut down. ReplayClient will be shut down.");
            }
            this.deleteReplayClient();
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)"ping() runs into NullPointerException! ReplayClient will be shut down.");
            }
            this.deleteReplayClient();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.error((Object)"ping() runs into unknown exception! ReplayClient will be shut down.");
            }
            this.deleteReplayClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteReplayClient() {
        Object object = this.deleteLock;
        synchronized (object) {
            if (this.isReplayClientDeleted) {
                return;
            }
            this.isReplayClientDeleted = true;
        }
        try {
            if (this.pingTask != null) {
                this.pingTask.cancel(true);
                this.pingTask = null;
                this.threadPoolExecutor.purge();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ping timer task stopped.");
                }
                this.threadPoolExecutor.shutdown();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ping timer stopped.");
                }
            }
            this.replayDataFacade = null;
            this.connection = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Shutting down servletBlocker ...");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ReplayClient " + this.toString() + " deleted!"));
            }
        }
        catch (Throwable e) {
            log.error((Object)"deleteReplayClient runs into!", e);
            Object object2 = this.deleteLock;
            synchronized (object2) {
                this.isReplayClientDeleted = false;
            }
        }
        finally {
            if (this.isReplayClientDeleted) {
                this.running = false;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void startPingThread() {
        this.pingTask = this.threadPoolExecutor.scheduleAtFixedRate(new MapPingTask(this), 0L, this.period, TimeUnit.MILLISECONDS);
    }
}

