/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.login;

import de.proveo.util.connection.LoginResponse;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeRemote;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(LoginServlet.class);
    protected static final String INIT_PARAM_USERADMIN_JNDI_NAME = "UserAdminJNDI";
    private UserAdminFacadeRemote userAdminFacade;

    public void destroy() {
    }

    public String getServletInfo() {
        return "Authentication Servlet of proveo.wwt system";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String jndiName = config.getInitParameter(INIT_PARAM_USERADMIN_JNDI_NAME);
        if (jndiName == null) {
            throw new ServletException("parameter UserAdminJNDI does not exist");
        }
        try {
            InitialContext context = new InitialContext();
            this.userAdminFacade = (UserAdminFacadeRemote)context.lookup("rts/UserAdminFacade/remote");
        }
        catch (NamingException ex) {
            log.error((Object)"naming problem", (Throwable)ex);
            throw new ServletException("naming problem", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.warn((Object)"doGet(): don't use GET because of security reasons.");
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.userAdminFacade == null) {
            throw new ServletException("ejb remote interface missing. init problem");
        }
        ObjectOutputStream outputStream = null;
        try {
            boolean jaas;
            String clientId = request.getParameter("clientId");
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String str_jaas = request.getParameter("jaas");
            String logout = request.getParameter("logout");
            boolean isLogout = false;
            boolean bl = jaas = str_jaas != null && str_jaas.equals("true");
            if (username == null || username.length() == 0) {
                throw new ServletException("parameter 'username' missing or empty");
            }
            if (password == null || password.length() == 0) {
                throw new ServletException("parameter 'password' missing or empty");
            }
            if (logout == null || logout.length() == 0) {
                isLogout = false;
            } else {
                isLogout = Boolean.parseBoolean(logout);
                log.debug((Object)("processRequest(): isLogout='" + isLogout + "'"));
            }
            Object responseObj = !isLogout ? this.doLogin(jaas, username, password) : this.doLogout(jaas, clientId, username, password);
            outputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());
            outputStream.writeObject(responseObj);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    log.warn((Object)"Could not close output stream of servlet response");
                }
            }
            log.debug((Object)"Cleaning up servlet connection ...");
            if (!response.isCommitted()) {
                try {
                    response.reset();
                    log.debug((Object)"Servlet connection cleaned up.");
                }
                catch (IllegalStateException ex) {
                    log.debug((Object)"Servlet connection was already cleaned up.");
                }
            } else {
                log.debug((Object)"Servlet connection was already cleaned up.");
            }
        }
    }

    private Object doLogin(boolean jaas, String username, String password) throws ServletException {
        Object responseObj = !jaas ? this.getLoginResponse(username, password) : this.getXMLLoginResponse(username, password);
        return responseObj;
    }

    private Object doLogout(boolean jaas, String clientId, String username, String password) throws ServletException {
        String responseObj;
        if (!jaas) {
            log.error((Object)"doLogout(): only implemented for JAAS Systems");
            responseObj = "";
        } else {
            responseObj = this.getXMLLogoutResponse(username, password);
        }
        MapProxyFactory mapProxyFactory = MapProxyFactory.getInstance();
        MapProxy client = mapProxyFactory.getMapProxyByID(clientId);
        if (client != null) {
            log.debug((Object)("Client with clientId '" + clientId + "' logged out, removing client ..."));
            if (!client.isShuttingDown()) {
                mapProxyFactory.removeProxy(client);
            } else {
                log.debug((Object)("Client with clientId '" + clientId + "' was already removed."));
            }
        } else {
            log.debug((Object)("Client with clientId '" + clientId + "' logged out, but client not found. Maybe the client was in replay mode, otherwise waiting for self destruction ..."));
        }
        return responseObj;
    }

    private String getXMLLoginResponse(String username, String password) {
        HashMap responseMap = new HashMap();
        try {
            LoginContextUtil lcu = new LoginContextUtil(username, password);
            lcu.fetchPermissions();
            responseMap = lcu.login4AirportMap();
            responseMap.put("RTS_Version", MapUtil.getInstance().getWwtImplVersion());
        }
        catch (Throwable ex) {
            log.error((Object)"runs into", ex);
            responseMap.put("AccessPermitted", false);
            responseMap.put("ReasonCode", "applicationError");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLEncoder resultEncoder = new XMLEncoder(outputStream);
        resultEncoder.writeObject(responseMap);
        resultEncoder.flush();
        resultEncoder.close();
        String xml = null;
        try {
            xml = outputStream.toString("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            xml = outputStream.toString();
        }
        return xml;
    }

    private String getXMLLogoutResponse(String username, String password) {
        HashMap responseMap = new HashMap();
        try {
            LoginContextUtil lcu = new LoginContextUtil(username, password);
            lcu.fetchPermissions();
            responseMap = lcu.logout4AirportMap();
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            responseMap.put("LogoutSuccessful", false);
            responseMap.put("LogoutReasonCode", "LogoutApplicationError");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XMLEncoder resultEncoder = new XMLEncoder(outputStream);
        resultEncoder.writeObject(responseMap);
        resultEncoder.flush();
        resultEncoder.close();
        String xml = null;
        try {
            xml = outputStream.toString("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            xml = outputStream.toString();
        }
        return xml;
    }

    private LoginResponse getLoginResponse(String username, String password) throws ServletException {
        LoginResponse loginResponse = new LoginResponse(false);
        try {
            LoginContextUtil lcu = new LoginContextUtil(username, password);
            lcu.fetchPermissions();
            loginResponse = lcu.login();
            log.debug((Object)"jaas login ok");
        }
        catch (Throwable e1) {
            loginResponse = new LoginResponse(false);
        }
        password = null;
        return loginResponse;
    }
}

