/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event.error;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.components.event.AbstractEventHandler;
import de.proveo.web.map.components.event.MapProxy;
import de.proveo.web.map.util.MapUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(ErrorEventHandler.class);
    private static final String EVENT_HANDLER_NAME = "ErrorEventHandler";

    public ErrorEventHandler(MapProxy mapProxy) {
        super(mapProxy);
    }

    @Override
    public String getName() {
        return EVENT_HANDLER_NAME;
    }

    @Override
    public String getSelectorName() {
        return "server_errors";
    }

    @Override
    public Map<String, Object> handleMessage(SerializableEventWrapper eventWrapper) {
        return this.createValueMap(eventWrapper);
    }

    @Override
    protected void initProcessableEventTypes() {
        this.processableEventTypes = new HashSet();
        this.processableEventTypes.add("ServerErrorEvent");
        this.processableEventTypes.add("StandErrorEvent");
        this.processableEventTypes.add("UnitErrorEvent");
    }

    @Override
    public boolean isEventBufferActive() {
        return false;
    }

    @Override
    public void scheduleNextBulkUpdate() {
    }

    @Override
    public void sendAllBulkDataToClient() throws IOException {
    }

    @Override
    public void setEventBufferActive(boolean active) {
        String method = "ClientID='" + this.clientName + "' -> setEventBufferActive(): ";
        if (active && log.isDebugEnabled()) {
            log.debug((Object)(method + "Event buffer NOT activated, because there is no event buffer for error client!"));
        }
    }

    private HashMap<String, Object> createValueMap(SerializableEventWrapper eventWrapper) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        MapUtil.getInstance().mapPutNullCheck(valueMap, "DataType", "data_type_server_errors", false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "ErrorEvent", eventWrapper.get_cacheValue(), false);
        MapUtil.getInstance().mapPutNullCheck(valueMap, "ServerTime", System.currentTimeMillis(), false);
        return valueMap;
    }
}

