/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.components.event;

import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.util.observable.interfaces.TimestampListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.web.map.communication.stream.Connection;
import de.proveo.web.map.components.event.AbstractEventHandler;
import de.proveo.web.map.components.event.MapProxyFactory;
import de.proveo.web.map.components.event.error.ErrorEventHandler;
import de.proveo.web.map.components.event.fis.FISEventHandler;
import de.proveo.web.map.components.event.unit.UnitEventHandler;
import de.proveo.web.map.timer.MapPingTask;
import de.proveo.web.map.timer.MapTimestampPingTask;
import de.proveo.web.map.util.MapUtil;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSConnectionUtil;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapProxy
extends JMSMessageListener
implements PingThreadListener,
TimestampListener {
    private static final Log log = LogFactory.getLog(MapProxy.class);
    private Connection connection = null;
    private volatile String selector = "";
    private ConcurrentSkipListSet<AbstractEventHandler> eventHandlerList = null;
    private UnitEventHandler unitEventHandler = null;
    private volatile String clientName = null;
    private volatile boolean shuttingDown = false;
    private final Object shutdownLock = new Object();
    private volatile String username = "";
    private volatile String password = "";
    private volatile long unitGroupId = -1L;
    private volatile String typeOfClientInterest = "";
    private Map<String, Map<String, String>> namespacesAndParameters = null;
    private ScheduledFuture clientPingTimerTask = null;
    private ScheduledFuture clientTimestampTimerTask = null;
    private ScheduledThreadPoolExecutor threadPoolExecutor = null;
    private volatile long period = 0L;
    private volatile int eventsCounter = 0;
    private final Object eventsCounterLock = new Object();
    private volatile boolean initialDataSent = false;
    private JMSClient jmsClient = null;

    public MapProxy(String clientName, String username, String password, long unitGroupId, String selector, Connection connection) {
        this.clientName = clientName;
        String method = "ClientID='" + this.clientName + "' -> MapProxy(): ";
        this.username = username;
        this.password = password;
        this.unitGroupId = unitGroupId;
        this.selector = selector;
        this.connection = connection;
        this.eventsCounter = 0;
        this.initialDataSent = false;
        this.threadPoolExecutor = new ScheduledThreadPoolExecutor(3);
        this.period = Integer.parseInt(MapUtil.getInstance().getParameter("observable.pingthread.latency", null));
        this.typeOfClientInterest = MapProxyFactory.getInstance().getTypeOfInterest(this.connection);
        String xmlSchemas = MapProxyFactory.getInstance().getXMLSchemas(this.connection);
        try {
            this.namespacesAndParameters = MapUtil.getInstance().getParametersForXMLSchemas(xmlSchemas);
        }
        catch (Throwable ex) {
            this.namespacesAndParameters = null;
            log.error((Object)(method + "Could not parse state model schemas: " + xmlSchemas), ex);
        }
    }

    public void setup() {
        String method = "ClientID='" + this.clientName + "' -> setup(): ";
        this.unitEventHandler = new UnitEventHandler(this);
        this.eventHandlerList = new ConcurrentSkipListSet();
        this.eventHandlerList.add(this.unitEventHandler);
        this.eventHandlerList.add(new FISEventHandler(this));
        this.eventHandlerList.add(new ErrorEventHandler(this));
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "All event handlers created!"));
        }
        JMSConnectionUtil.getInstance().establishJMSConnection(this.clientName, (JMSMessageListener)this, this.selector, MapProxyFactory.getInstance().getInformantClient());
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "JMS connection established!"));
        }
        this.startPingSignalTimer();
        this.startTimestampTimer();
    }

    public void sendInitialData() {
        String method;
        block14: {
            method = "ClientID='" + this.clientName + "' -> sendInitialData(): ";
            if (this.isShuttingDown()) {
                log.warn((Object)(method + "Initial data could not be sent, because map proxy is already shutting down!"));
                return;
            }
            if (this.initialDataSent) {
                log.fatal((Object)(method + "Initial data was already sent!?! Break."));
                return;
            }
            this.initialDataSent = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Start ..."));
            }
            if (this.eventHandlerList != null) {
                try {
                    Iterator<AbstractEventHandler> ite = this.eventHandlerList.iterator();
                    while (!this.isShuttingDown() && ite.hasNext()) {
                        AbstractEventHandler eventHandler;
                        block13: {
                            eventHandler = ite.next();
                            if (this.isShuttingDown() || !eventHandler.isSendData()) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(method + "Sending initial bulk data for event handler: " + eventHandler.getName()));
                            }
                            try {
                                eventHandler.sendAllBulkDataToClient();
                            }
                            catch (IOException e) {
                                if (!this.isShuttingDown()) {
                                    log.error((Object)(method + "runs into IOException! Problems while sending initial data for " + eventHandler.getName() + "! Shutdown client ..."), (Throwable)e);
                                    MapProxyFactory.getInstance().removeProxy(this);
                                }
                            }
                            catch (Throwable e) {
                                if (this.isShuttingDown()) break block13;
                                log.error((Object)(method + "sending initial data for " + eventHandler.getName() + " runs into unknown exception! Shutdown client ..."), e);
                                MapProxyFactory.getInstance().removeProxy(this);
                            }
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(method + "Initial bulk data for event handler instance sent: " + eventHandler.toString()));
                    }
                }
                catch (Throwable ex) {
                    if (this.isShuttingDown()) break block14;
                    log.error((Object)(method + "runs into unexpected exception"), ex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Finished."));
        }
    }

    private void startPingSignalTimer() {
        this.stopPingTask();
        this.clientPingTimerTask = this.threadPoolExecutor.scheduleAtFixedRate(new MapPingTask(this), this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private void startTimestampTimer() {
        this.stopTimestampTask();
        this.clientTimestampTimerTask = this.threadPoolExecutor.scheduleAtFixedRate(new MapTimestampPingTask(this), 10000L, MapProxyFactory.getInstance().getTimestampPeriod(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEventNumber() {
        Object object = this.eventsCounterLock;
        synchronized (object) {
            return ++this.eventsCounter;
        }
    }

    public void onMessage(Message message) {
        String method = "ClientID='" + this.clientName + "' -> onMessage(): ";
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage oMessage = (ObjectMessage)message;
                Serializable _object = oMessage.getObject();
                if (_object instanceof SerializableEventWrapper) {
                    SerializableEventWrapper eventWrapper = (SerializableEventWrapper)_object;
                    this.forwardSingleMessage(eventWrapper);
                } else {
                    log.error((Object)(method + "Could not handle message. Object of ObjectMessage isn't a SerializableEventWrapper. Object=" + _object));
                }
            } else {
                log.error((Object)(method + "Could not handle message. Message isn't an instance of ObjectMessage. Message=" + message));
            }
            message.acknowledge();
        }
        catch (JMSException e) {
            log.error((Object)(method + "runs into JMSException: "), (Throwable)e);
        }
        catch (Throwable ex) {
            log.error((Object)(method + "runs into unknown exception"), ex);
        }
    }

    private void forwardSingleMessage(SerializableEventWrapper eventWrapper) {
        block10: {
            String method = "ClientID='" + this.clientName + "' -> forwardSingleMessage(): ";
            if (!this.isShuttingDown()) {
                try {
                    String eventType = eventWrapper.get_typeOfEvent();
                    boolean messageHandled = false;
                    if (this.eventHandlerList == null) break block10;
                    try {
                        Iterator<AbstractEventHandler> ite = this.eventHandlerList.iterator();
                        while (!this.isShuttingDown() && ite.hasNext()) {
                            AbstractEventHandler eventHandler = ite.next();
                            if (!eventHandler.canHandleEventType(eventType)) continue;
                            if (messageHandled) {
                                log.warn((Object)(method + "Received event with event type '" + eventType + "' could be handled from more than one EventHandler!"));
                            }
                            messageHandled = true;
                            eventHandler.forwardSingleMessage(eventWrapper);
                        }
                        if (!this.isShuttingDown() && !messageHandled) {
                            log.error((Object)(method + "Received event with event type '" + eventType + "' but no EventHandler can handle this type!"));
                        }
                    }
                    catch (Throwable ex) {
                        if (!this.isShuttingDown()) {
                            log.error((Object)(method + "runs into unexpected exception"), ex);
                        }
                    }
                }
                catch (Throwable ex) {
                    String errorMsg = method + "runs into unexpected exception";
                    log.error((Object)errorMsg, ex);
                    MapProxyFactory.getInstance().getInformantClient().notify(errorMsg + ": " + ex, "ServerErrorEvent");
                }
            } else {
                log.warn((Object)(method + "This MapProxy is shutting down or already closed. Client closed or Connection lost."));
            }
        }
    }

    public void ping() {
        String method = "ClientID='" + this.clientName + "' -> ping(): ";
        long lastExecute = System.currentTimeMillis() - this.connection.getLastSendingTime();
        if (lastExecute + 10L >= this.period) {
            boolean wasSend = this.sendResponse("p");
            if (log.isDebugEnabled()) {
                if (wasSend) {
                    log.debug((Object)(method + "request excecuted. (MapProxy: " + ((Object)((Object)this)).toString() + ")"));
                } else {
                    log.debug((Object)(method + "ping could not be sent to client. (MapProxy: " + ((Object)((Object)this)).toString() + ")"));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(method + "request NOT excecuted, because last message was sent only " + lastExecute + "ms ago! (MapProxy: " + ((Object)((Object)this)).toString() + ")"));
        }
    }

    public void scheduleNextBulkUpate() {
        block4: {
            String method = "ClientID='" + this.clientName + "' -> scheduleNextBulkUpate(): ";
            if (this.eventHandlerList != null) {
                try {
                    AbstractEventHandler eventHandler;
                    Iterator<AbstractEventHandler> ite = this.eventHandlerList.iterator();
                    while (!this.isShuttingDown() && ite.hasNext() && (eventHandler = ite.next()) != null) {
                        if (!eventHandler.isSendData()) continue;
                        eventHandler.scheduleNextBulkUpdate();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(method + "Next bulk update scheduled for " + eventHandler.getName()));
                    }
                }
                catch (Throwable ex) {
                    if (this.isShuttingDown()) break block4;
                    log.error((Object)(method + "runs into unexpected exception"), ex);
                }
            }
        }
    }

    public boolean sendResponse(Object response) {
        String method = "ClientID='" + this.clientName + "' -> sendResponse(): ";
        try {
            if (this.isShuttingDown()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Client is shutting down or already closed. Do not send response"));
                }
                return false;
            }
            if (response instanceof Map) {
                Map responseMap = (Map)response;
                MapUtil.getInstance().mapPutNullCheck(responseMap, "EventNumber", this.getEventNumber(), false);
                response = responseMap;
            }
            this.connection.sendObject(response);
            return true;
        }
        catch (IOException e) {
            log.error((Object)(method + "runs into IOException! Probably the client was shut down. Session will be unsubscribed!"));
            log.debug((Object)(method + "runs into IOException! Probably the client was shut down. Session will be unsubscribed!"), (Throwable)e);
            MapProxyFactory.getInstance().removeProxy(this);
            return false;
        }
        catch (Throwable e) {
            String errorMsg = method + " runs into unexpected exception!!! Will shutdown all Client Threads as a precaution! See log-files for further infos";
            log.error((Object)errorMsg, e);
            MapProxyFactory.getInstance().getInformantClient().notify(errorMsg + ": " + e, "ServerErrorEvent");
            MapProxyFactory.getInstance().removeProxy(this);
            return false;
        }
    }

    private boolean cleanUpEventHandler() {
        String method = "ClientID='" + this.clientName + "' -> cleanUpEventHandler(): ";
        boolean ret = true;
        if (this.eventHandlerList != null) {
            AbstractEventHandler eventHandler = this.eventHandlerList.pollFirst();
            while (eventHandler != null) {
                if (!eventHandler.cleanUp()) {
                    ret = false;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)(method + eventHandler.getName() + " cleaned up!"));
                }
                eventHandler = this.eventHandlerList.pollFirst();
            }
        }
        this.eventHandlerList = null;
        this.unitEventHandler = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteMapProxy() {
        String method = "ClientID='" + this.clientName + "' -> deleteMapProxy(): ";
        boolean success = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Deleting all connections in MapProxy"));
        }
        try {
            try {
                if (this.jmsClient != null) {
                    this.jmsClient.close();
                    this.jmsClient = null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + " JMS connection closed."));
                }
            }
            catch (Throwable ex) {
                log.error((Object)(method + "Could not close JMS connection"), ex);
                success = false;
            }
            if (!this.stopPingTask()) {
                success = false;
            }
            if (!this.stopTimestampTask()) {
                success = false;
            }
            if (!this.cleanUpEventHandler()) {
                success = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "All connections in MapProxy deleted!"));
            }
        }
        catch (Throwable e) {
            log.error((Object)(method + "runs into unexpected exception!"), e);
            MapProxyFactory.getInstance().getInformantClient().notify(method + "runs into unexpected exception!: " + e, "ServerErrorEvent");
            success = false;
        }
        finally {
            try {
                if (this.threadPoolExecutor != null) {
                    this.threadPoolExecutor.purge();
                    this.threadPoolExecutor.shutdown();
                    this.threadPoolExecutor = null;
                }
            }
            catch (Throwable e) {
                log.fatal((Object)(method + "Could not stop internal timer while shutting down client!?!"), e);
                MapProxyFactory.getInstance().getInformantClient().notify(method + "Could not stop internal timer while shutting down client!?!: " + e, "ServerErrorEvent");
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        String method = "ClientID='" + this.clientName + "' -> shutdown(): ";
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShuttingDown()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Session will already be shut down. Break."));
                }
                return;
            }
            this.shuttingDown = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Shutting down client ..."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "deleting MapProxy ..."));
        }
        boolean mapProxyDeleted = this.deleteMapProxy();
        while (!mapProxyDeleted) {
            log.warn((Object)(method + "Could not delete MapProxy! Try again ..."));
            mapProxyDeleted = this.deleteMapProxy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "MapProxy deleted."));
        }
        this.connection.close();
        this.connection = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "Client destroyed"));
        }
    }

    public ScheduledThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTypeOfClientInterest() {
        return this.typeOfClientInterest;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getJMSClientId() {
        String clientId = "disconnected";
        if (this.jmsClient != null) {
            clientId = this.jmsClient.getClientId();
        }
        return clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shuttingDown;
        }
    }

    public long getUnitGroupId() {
        return this.unitGroupId;
    }

    public UnitEventHandler getUnitEventHandler() {
        return this.unitEventHandler;
    }

    private boolean stopPingTask() {
        boolean ret = true;
        if (this.clientPingTimerTask != null) {
            boolean canceled;
            String method = "ClientID='" + this.clientName + "' -> stopPingTask(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Stopping previous ping timer task ..."));
            }
            if (!(canceled = this.clientPingTimerTask.cancel(true)) && !this.clientPingTimerTask.isDone()) {
                ret = false;
            } else {
                if (this.threadPoolExecutor != null) {
                    this.threadPoolExecutor.purge();
                }
                this.clientPingTimerTask = null;
            }
            if (ret) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Previous ping timer task has been canceled!"));
                }
            } else {
                log.warn((Object)(method + "Previous ping timer task could not be canceled!"));
            }
        }
        return ret;
    }

    private boolean stopTimestampTask() {
        boolean ret = true;
        if (this.clientTimestampTimerTask != null) {
            boolean canceled;
            String method = "ClientID='" + this.clientName + "' -> stopTimestampTask(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Stopping previous timestamp timer task ..."));
            }
            if (!(canceled = this.clientTimestampTimerTask.cancel(true)) && !this.clientTimestampTimerTask.isDone()) {
                ret = false;
            } else {
                if (this.threadPoolExecutor != null) {
                    this.threadPoolExecutor.purge();
                }
                this.clientTimestampTimerTask = null;
            }
            if (ret) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Previous timestamp timer task has been canceled!"));
                }
            } else {
                log.warn((Object)(method + "Previous timestamp timer task could not be canceled!"));
            }
        }
        return ret;
    }

    public void pingServerTime(long currentServerTime) {
        String method = "ClientID='" + this.clientName + "' -> pingServerTime(): ";
        boolean wasSend = this.sendResponse(currentServerTime);
        if (log.isDebugEnabled() && wasSend) {
            String pattern = "HH:mm:ss";
            SimpleDateFormat formater = new SimpleDateFormat(pattern);
            if (wasSend) {
                log.debug((Object)(method + "request excecuted, sent server time was " + formater.format(currentServerTime) + ". (MapProxy: " + ((Object)((Object)this)).toString() + ")"));
            } else {
                log.debug((Object)(method + "server time could not be sent to client. (MapProxy: " + ((Object)((Object)this)).toString() + ")"));
            }
        }
    }

    public String getSelector() {
        return this.selector;
    }

    public Map<String, Map<String, String>> getNamespacesAndParameters() {
        return this.namespacesAndParameters;
    }

    public void setJMSClient(JMSClient client) {
        this.jmsClient = client;
    }
}

