/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.web.map.communication.stream;

import de.proveo.web.map.communication.stream.Connection;
import de.proveo.wwt.logic.app.util.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPConnection
implements Connection {
    private static final Log log = LogFactory.getLog(HTTPConnection.class);
    private static final String CONTENT_TYPE = "application/octet-stream";
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ObjectOutputStream objectOutputStream = null;
    private Properties properties = null;
    private boolean dataCompressionEnabled = false;
    private Stopwatch stopwatch = null;
    private long lastSendObjectToClient = System.currentTimeMillis();

    public HTTPConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        this.response.setContentType(CONTENT_TYPE);
        this.objectOutputStream = new ObjectOutputStream((OutputStream)this.response.getOutputStream());
        this.properties = this.getPropertiesFromRequest(this.request);
        this.properties.setProperty("remoteAddress", this.request.getRemoteAddr());
        this.dataCompressionEnabled = Boolean.parseBoolean(this.properties.getProperty("compress"));
    }

    @Override
    public synchronized void sendObject(Object obj) throws IOException {
        this.lastSendObjectToClient = System.currentTimeMillis();
        if (this.dataCompressionEnabled) {
            this.objectOutputStream.writeObject(this.compressObj(obj));
        } else {
            this.objectOutputStream.writeObject(obj);
        }
        this.objectOutputStream.flush();
        this.objectOutputStream.reset();
        this.lastSendObjectToClient = System.currentTimeMillis();
    }

    private Object compressObj(Object obj) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        byte[] compressedObj = null;
        try {
            ObjectOutputStream oos1 = new ObjectOutputStream(new GZIPOutputStream(arrayOutputStream));
            oos1.writeObject(obj);
            oos1.flush();
            oos1.close();
            compressedObj = arrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            log.debug((Object)"compressObj() runs into IOException: ", (Throwable)e);
        }
        return compressedObj;
    }

    @Override
    public synchronized void close() {
        log.debug((Object)"Cleaning up servlet connection ...");
        if (!this.response.isCommitted()) {
            try {
                this.response.reset();
                log.debug((Object)"Servlet connection cleaned up.");
            }
            catch (IllegalStateException ex) {
                log.debug((Object)"Servlet connection was already cleaned up.");
            }
        } else {
            log.debug((Object)"Servlet connection was already cleaned up.");
        }
        try {
            this.objectOutputStream.close();
        }
        catch (Throwable ex) {
            log.debug((Object)"Could not close output stream");
        }
        this.objectOutputStream = null;
        this.properties = null;
        this.request = null;
        this.response = null;
    }

    @Override
    public Properties getServletParameters() {
        return this.properties;
    }

    private Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }

    @Override
    public long getLastSendingTime() {
        return this.lastSendObjectToClient;
    }
}

