/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.wiki;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.mylyn.util.WikiPanel;
import org.netbeans.modules.mylyn.util.WikiUtils;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class WikiEditPanel
extends WikiPanel {
    private String wikiFormatText;
    private String wikiLanguage;
    private String htmlFormatText;
    private final boolean switchable;
    private boolean editing;
    private static final ImageIcon ICON_EDIT = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mylyn/util/resources/edit.png", (boolean)true);
    private static final ImageIcon ICON_PREVIEW = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mylyn/util/resources/preview.png", (boolean)true);
    private static final Logger LOG = Logger.getLogger("org.netbeans.mylyn.utils.WikiEditPanel");
    private static final String CONTENT_HTML = "text/html";
    private static final String CONTENT_PLAIN = "text/plain";
    private JButton btnEditPreview;
    private JPanel jPanel1;
    private JLabel lblWarning;
    private JPanel pnlButtons;
    private JScrollPane scrollCode;
    private JScrollPane scrollPreview;
    private JTextPane textCode;
    private JTextPane textPreview;

    public WikiEditPanel(String wikiLanguage, boolean editing, boolean switchable) {
        this.wikiLanguage = wikiLanguage;
        this.switchable = switchable;
        this.wikiFormatText = "";
        this.htmlFormatText = "";
        this.initComponents();
        this.pnlButtons.setVisible(switchable);
        this.textCode.getDocument().addDocumentListener(new RevalidatingListener());
        this.textPreview.getDocument().addDocumentListener(new RevalidatingListener());
        this.textCode.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                WikiEditPanel.this.makeCaretVisible(WikiEditPanel.this.textCode);
            }
        });
        this.textCode.getDocument().addDocumentListener(new EnablingListener());
        UIUtils.fixFocusTraversalKeys((JComponent)this.textCode);
        UIUtils.issue163946Hack((JScrollPane)this.scrollCode);
        Spellchecker.register((JTextComponent)this.textCode);
        this.textPreview.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setEditing(editing);
    }

    @Override
    public String getWikiFormatText() {
        return this.textCode.getText();
    }

    @Override
    public void setWikiFormatText(String wikiFormatText) {
        String htmlText;
        this.wikiFormatText = wikiFormatText;
        String string = htmlText = Boolean.getBoolean("bugtracking.noWikiStyle") ? null : WikiUtils.getHtmlFormatText(wikiFormatText, this.wikiLanguage);
        if (htmlText != null) {
            this.htmlFormatText = htmlText;
            this.textPreview.setContentType(CONTENT_HTML);
        } else {
            this.htmlFormatText = wikiFormatText;
            this.textPreview.setContentType(CONTENT_PLAIN);
        }
        this.textCode.setText(wikiFormatText);
        this.textPreview.setText(this.htmlFormatText);
        this.repaint();
    }

    @Override
    public JLabel getWarningLabel() {
        return this.lblWarning;
    }

    @Override
    public void appendCodeText(String codeToAppend) {
        this.setWikiFormatText(this.getWikiFormatText() + codeToAppend);
        this.setEditing(true);
    }

    @Override
    public void clear() {
        this.wikiFormatText = "";
        this.htmlFormatText = "";
        this.textCode.setText(this.wikiFormatText);
        this.textPreview.setText(this.htmlFormatText);
        this.repaint();
    }

    @Override
    public void registerHighlights(JTextPane wikiPreviewPane) {
    }

    @Override
    public JTextPane getPreviewPane() {
        return this.textPreview;
    }

    @Override
    public JTextPane getCodePane() {
        return this.textCode;
    }

    private void initComponents() {
        this.pnlButtons = new JPanel();
        this.btnEditPreview = new JButton();
        this.lblWarning = new JLabel();
        this.jPanel1 = new JPanel();
        this.scrollPreview = new JScrollPane();
        this.textPreview = new JTextPane();
        this.scrollCode = new JScrollPane();
        this.textCode = new JTextPane();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.pnlButtons.setOpaque(false);
        this.btnEditPreview.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mylyn/util/resources/edit.png")));
        this.btnEditPreview.setVerticalAlignment(3);
        this.btnEditPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WikiEditPanel.this.btnEditPreviewActionPerformed(evt);
            }
        });
        this.lblWarning.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblWarning, (String)NbBundle.getMessage(WikiEditPanel.class, (String)"WikiEditPanel.lblWarning.text"));
        GroupLayout pnlButtonsLayout = new GroupLayout(this.pnlButtons);
        this.pnlButtons.setLayout(pnlButtonsLayout);
        pnlButtonsLayout.setHorizontalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, pnlButtonsLayout.createSequentialGroup().addComponent(this.btnEditPreview, -2, 30, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.lblWarning, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE));
        pnlButtonsLayout.setVerticalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlButtonsLayout.createSequentialGroup().addComponent(this.btnEditPreview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblWarning)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.pnlButtons, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.scrollPreview.setBorder(null);
        this.scrollPreview.setVerticalScrollBarPolicy(21);
        this.textPreview.setEditable(false);
        this.textPreview.setBorder(BorderFactory.createEmptyBorder());
        this.textPreview.setContentType(CONTENT_HTML);
        this.textPreview.setText(this.htmlFormatText);
        this.textPreview.setMargin(new Insets(0, 3, 3, 3));
        this.scrollPreview.setViewportView(this.textPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 11, 0);
        this.jPanel1.add((Component)this.scrollPreview, gridBagConstraints);
        this.scrollCode.setVerticalScrollBarPolicy(21);
        this.textCode.setText(this.wikiFormatText);
        this.scrollCode.setViewportView(this.textCode);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.scrollCode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnEditPreviewActionPerformed(ActionEvent evt) {
        this.setEditing(!this.editing);
    }

    private void setEditing(boolean editing) {
        if (editing) {
            this.btnEditPreview.setEnabled(this.textCode.getDocument().getLength() != 0);
            this.btnEditPreview.setIcon(ICON_PREVIEW);
            this.btnEditPreview.setToolTipText(NbBundle.getMessage(WikiEditPanel.class, (String)"TOOL_Preview"));
            this.textCode.setVisible(true);
            this.scrollCode.setVisible(true);
            this.textPreview.setVisible(false);
            this.scrollPreview.setVisible(false);
            this.textCode.requestFocus();
        } else {
            this.btnEditPreview.setEnabled(true);
            this.btnEditPreview.setIcon(ICON_EDIT);
            this.btnEditPreview.setToolTipText(NbBundle.getMessage(WikiEditPanel.class, (String)"TOOL_Edit"));
            this.textPreview.setVisible(true);
            this.scrollPreview.setVisible(true);
            this.textCode.setVisible(false);
            this.scrollCode.setVisible(false);
            if (this.editing != editing) {
                this.setWikiFormatText(this.textCode.getText());
            }
        }
        this.editing = editing;
        this.revalidate();
        this.repaint();
    }

    private void makeCaretVisible(JTextComponent textComponent) {
        int pos = textComponent.getCaretPosition();
        try {
            Rectangle rec = textComponent.getUI().modelToView(textComponent, pos);
            if (rec != null) {
                Point p = SwingUtilities.convertPoint(textComponent, rec.x, rec.y, this);
                this.scrollRectToVisible(new Rectangle(p.x, p.y, rec.width, rec.height));
            }
        }
        catch (BadLocationException blex) {
            LOG.log(Level.INFO, blex.getMessage(), blex);
        }
    }

    private class EnablingListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkButtonEnabled(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkButtonEnabled(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkButtonEnabled(e);
        }

        private void checkButtonEnabled(DocumentEvent e) {
            WikiEditPanel.this.btnEditPreview.setEnabled(e.getDocument().getLength() != 0);
        }
    }

    private class RevalidatingListener
    implements DocumentListener,
    Runnable {
        private boolean ignoreUpdate;

        private RevalidatingListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.ignoreUpdate) {
                return;
            }
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            WikiEditPanel.this.revalidate();
            WikiEditPanel.this.repaint();
            this.ignoreUpdate = false;
        }
    }
}

