/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskMigrationEvent;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.commands.CommandsAccessorImpl;
import org.netbeans.modules.mylyn.util.commands.GetAttachmentCommand;
import org.netbeans.modules.mylyn.util.commands.GetRepositoryTasksCommand;
import org.netbeans.modules.mylyn.util.commands.PostAttachmentCommand;
import org.netbeans.modules.mylyn.util.commands.SimpleQueryCommand;
import org.netbeans.modules.mylyn.util.commands.SubmitTaskCommand;
import org.netbeans.modules.mylyn.util.commands.SynchronizeQueryCommand;
import org.netbeans.modules.mylyn.util.commands.SynchronizeTasksCommand;
import org.netbeans.modules.mylyn.util.internal.Accessor;
import org.netbeans.modules.mylyn.util.internal.CommandsAccessor;

public final class CommandFactory {
    private static final Logger LOG;
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final TaskRepositoryManager taskRepositoryManager;
    private final RepositoryModel repositoryModel;

    CommandFactory(TaskList taskList, TaskDataManager taskDataManager, TaskRepositoryManager taskRepositoryManager, RepositoryModel repositoryModel) {
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.taskRepositoryManager = taskRepositoryManager;
        this.repositoryModel = repositoryModel;
    }

    public SynchronizeQueryCommand createSynchronizeQueriesCommand(TaskRepository taskRepository, IRepositoryQuery iquery) {
        assert (iquery instanceof RepositoryQuery);
        if (!(iquery instanceof RepositoryQuery)) {
            return null;
        }
        RepositoryQuery repositoryQuery = (RepositoryQuery)iquery;
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        return new SynchronizeQueryCommand(this.repositoryModel, repositoryConnector, taskRepository, this.taskList, this.taskDataManager, repositoryQuery);
    }

    public SubmitTaskCommand createSubmitTaskCommand(NbTaskDataModel model) throws CoreException {
        final ITask task = Accessor.getInstance().getITask(model);
        TaskRepository taskRepository = Accessor.getInstance().getTaskRepositoryFor(task);
        final AbstractRepositoryConnector repositoryConnector = task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW ? this.taskRepositoryManager.getRepositoryConnector(task.getAttribute("outgoingNewConnectorKind")) : this.taskRepositoryManager.getRepositoryConnector(task.getConnectorKind());
        SubmitTaskCommand command = new SubmitTaskCommand(this.taskDataManager, repositoryConnector, taskRepository, task, model.getLocalTaskData(), model.getChangedOldAttributes());
        command.setSubmitJobListener(new SubmitJobListener(){

            public void taskSubmitted(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
            }

            public void taskSynchronized(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
            }

            public void done(SubmitJobEvent event) {
                SubmitJob job = event.getJob();
                ITask newTask = job.getTask();
                if (newTask != null && newTask != task) {
                    CommandFactory.this.taskList.deleteTask(task);
                    CommandFactory.this.taskList.addTask(newTask);
                    repositoryConnector.migrateTask(new TaskMigrationEvent(task, newTask));
                    try {
                        CommandFactory.this.taskDataManager.deleteTaskData(task);
                    }
                    catch (CoreException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        });
        return command;
    }

    @Deprecated
    public SynchronizeTasksCommand createSynchronizeTasksCommand(TaskRepository taskRepository, Set<NbTask> tasks) {
        return this.createSynchronizeTasksCommand(taskRepository, tasks, true);
    }

    public SynchronizeTasksCommand createSynchronizeTasksCommand(TaskRepository taskRepository, Set<NbTask> tasks, boolean isUserAction) {
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        return new SynchronizeTasksCommand(repositoryConnector, taskRepository, this.repositoryModel, this.taskDataManager, this.taskList, tasks, isUserAction);
    }

    public GetRepositoryTasksCommand createGetRepositoryTasksCommand(TaskRepository taskRepository, Set<String> taskIds) throws CoreException {
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        GetRepositoryTasksCommand cmd = new GetRepositoryTasksCommand(repositoryConnector, taskRepository, taskIds, this.taskDataManager);
        return cmd;
    }

    public SimpleQueryCommand createSimpleQueryCommand(TaskRepository taskRepository, IRepositoryQuery query) throws CoreException {
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        return new SimpleQueryCommand(repositoryConnector, taskRepository, this.taskDataManager, query);
    }

    public PostAttachmentCommand createPostAttachmentCommand(TaskRepository taskRepository, NbTask task, TaskAttribute attAttribute, FileTaskAttachmentSource attachmentSource, String comment) {
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        return new PostAttachmentCommand(repositoryConnector, taskRepository, Accessor.getInstance().getDelegate(task), attAttribute, (AbstractTaskAttachmentSource)attachmentSource, comment);
    }

    public GetAttachmentCommand createGetAttachmentCommand(TaskRepository taskRepository, NbTask nbTask, TaskAttribute ta, OutputStream os) {
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        return new GetAttachmentCommand(repositoryConnector, taskRepository, Accessor.getInstance().getDelegate(nbTask), ta, os);
    }

    static {
        CommandsAccessor.INSTANCE = new CommandsAccessorImpl();
        LOG = Logger.getLogger(CommandFactory.class.getName());
    }
}

