/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.tasklist.todo.settings.CommentTags;
import org.netbeans.modules.tasklist.todo.settings.ExtensionIdentifier;
import org.netbeans.modules.tasklist.todo.settings.FileIdentifier;
import org.netbeans.modules.tasklist.todo.settings.IdentifierPickerPanel;
import org.netbeans.modules.tasklist.todo.settings.MimeIdentifier;
import org.netbeans.modules.tasklist.todo.settings.Settings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ToDoCustomizer
extends JPanel
implements DocumentListener {
    private boolean changed = false;
    private boolean isUpdating = false;
    private List<MimeIdentifier> mimeIdentifiers;
    private List<ExtensionIdentifier> extensionIdentifiers;
    private int selectedIndex = -1;
    private IdentifierModel identifierModel;
    private static final String ICON_NOT_VALID_PATH = "org/netbeans/modules/tasklist/todo/settings/error.png";
    private static final Icon NOT_VALID_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/tasklist/todo/settings/error.png", (boolean)true);
    private static final Icon EMPTY_ICON = new EmptyIcon();
    private boolean detailsValid;
    private static final Map<String, CommentTags> id2comments = new HashMap<String, CommentTags>();
    private JButton btnAdd;
    private JButton btnAddMime;
    private JButton btnChange;
    private JButton btnRemove;
    private JButton btnRemoveMime;
    private JCheckBox chbBlock;
    private JCheckBox chbLine;
    private JCheckBox checkScanCommentsOnly;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblBlockEnd;
    private JLabel lblBlockStart;
    private JLabel lblError;
    private JLabel lblExtensions;
    private JLabel lblExtensions1;
    private JLabel lblLine;
    private JLabel lblMimeName;
    private JLabel lblTodo;
    private JList listIdentifiers;
    private JPanel pnlExtensionDetails;
    private JSeparator sepExtension;
    private JSeparator sepExtension1;
    private JSeparator sepExtension2;
    private JSeparator sepTodo;
    private JTable table;
    private JTextField txtBlockEnd;
    private JTextField txtBlockStart;
    private JTextField txtLine;

    public ToDoCustomizer() {
        this.initComponents();
        this.lblError.setVisible(false);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ToDoCustomizer.this.enableButtons();
            }
        });
        this.jScrollPane1.getViewport().setOpaque(false);
        this.enableButtons();
    }

    private void enableButtons() {
        int selIndex = this.table.getSelectedRow();
        this.btnChange.setEnabled(selIndex >= 0);
        this.btnRemove.setEnabled(selIndex >= 0);
    }

    void cancel() {
        this.changed = false;
        id2comments.clear();
    }

    void update() {
        this.isUpdating = true;
        Collection<String> patterns = Settings.getDefault().getPatterns();
        this.table.setModel(this.createModel(patterns));
        this.table.setTableHeader(null);
        this.checkScanCommentsOnly.setSelected(Settings.getDefault().isScanCommentsOnly());
        this.initList();
        this.changed = false;
        this.isUpdating = false;
        id2comments.clear();
    }

    void applyChanges() {
        if (this.isChanged() && this.isDataValid()) {
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            ArrayList<String> patterns = new ArrayList<String>(model.getRowCount());
            for (int i = 0; i < model.getRowCount(); ++i) {
                String pattern;
                Object value = model.getValueAt(i, 0);
                if (value == null || (pattern = value.toString()).trim().isEmpty() || pattern.trim().equals(this.getDummyPattern())) continue;
                patterns.add(pattern);
            }
            Settings.getDefault().setPatterns(patterns);
            Settings.getDefault().setScanCommentsOnly(this.checkScanCommentsOnly.isSelected());
            for (String id : id2comments.keySet()) {
                FileIdentifier identifier;
                int i;
                CommentTags comments = id2comments.get(id);
                for (i = 0; i < this.extensionIdentifiers.size(); ++i) {
                    identifier = this.extensionIdentifiers.get(i);
                    if (!((ExtensionIdentifier)identifier).getId().equals(id)) continue;
                    this.updateCommentTags(identifier, comments);
                }
                for (i = 0; i < this.mimeIdentifiers.size(); ++i) {
                    identifier = this.mimeIdentifiers.get(i);
                    if (!((MimeIdentifier)identifier).getId().equals(id)) continue;
                    this.updateCommentTags(identifier, comments);
                }
            }
            Settings.getDefault().setIdentifiers(this.mimeIdentifiers, this.extensionIdentifiers);
            this.changed = false;
            id2comments.clear();
        }
    }

    private void updateCommentTags(FileIdentifier identifier, CommentTags comments) {
        CommentTags tag = identifier.getCommentTags();
        tag.setLineComment(comments.getLineComment());
        tag.setLineCommentEnabled(comments.isLineCommentEnabled());
        tag.setBlockCommentStart(comments.getBlockCommentStart());
        tag.setBlockCommentEnd(comments.getBlockCommentEnd());
        tag.setBlockCommentEnabled(comments.isBlockCommentEnabled());
    }

    boolean isDataValid() {
        boolean listValid = this.isListValid();
        this.listIdentifiers.repaint();
        this.lblError.setVisible(!listValid);
        return this.table.getRowCount() > 0 && listValid;
    }

    boolean isChanged() {
        return this.changed;
    }

    private void fireChanged() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        ArrayList<String> patterns = new ArrayList<String>(model.getRowCount());
        for (int i = 0; i < model.getRowCount(); ++i) {
            String pattern;
            Object value = model.getValueAt(i, 0);
            if (value == null || (pattern = value.toString()).trim().isEmpty() || pattern.trim().equals(this.getDummyPattern())) continue;
            patterns.add(pattern);
        }
        this.changed = !id2comments.isEmpty() || Settings.getDefault().isScanCommentsOnly() != this.checkScanCommentsOnly.isSelected() || Settings.getDefault().getPatterns().size() != patterns.size() || !Settings.getDefault().getPatterns().containsAll(patterns) || Settings.getDefault().getExtensionIdentifiers().size() != this.extensionIdentifiers.size() || !Settings.getDefault().getExtensionIdentifiers().containsAll(this.extensionIdentifiers) || Settings.getDefault().getMimeIdentifiers().size() != this.mimeIdentifiers.size() || !Settings.getDefault().getMimeIdentifiers().containsAll(this.mimeIdentifiers);
    }

    private boolean isListValid() {
        this.saveDetails(this.selectedIndex);
        if (this.mimeIdentifiers == null) {
            return false;
        }
        for (MimeIdentifier mimeIdentifier : this.mimeIdentifiers) {
            if (this.isCommentTagValid(mimeIdentifier)) continue;
            return false;
        }
        if (this.extensionIdentifiers == null) {
            return false;
        }
        for (ExtensionIdentifier extensionIdentifier : this.extensionIdentifiers) {
            if (this.isCommentTagValid(extensionIdentifier)) continue;
            return false;
        }
        return true;
    }

    private boolean isCommentTagValid(FileIdentifier identifier) {
        CommentTags commentTags = id2comments.get(identifier.getId());
        if (commentTags == null) {
            return identifier.isValid();
        }
        boolean lineCommentValid = this.chbLine.isSelected();
        boolean blockCommentValid = this.chbBlock.isSelected();
        if (!lineCommentValid && !blockCommentValid) {
            return false;
        }
        lineCommentValid = lineCommentValid ? !commentTags.getLineComment().isEmpty() && commentTags.isLineCommentEnabled() : true;
        blockCommentValid = blockCommentValid ? !commentTags.getBlockCommentStart().isEmpty() && !commentTags.getBlockCommentEnd().isEmpty() && commentTags.isBlockCommentEnabled() : true;
        return lineCommentValid && blockCommentValid;
    }

    private DefaultTableModel createModel(Collection<String> patterns) {
        DefaultTableModel model = new DefaultTableModel(new Object[]{NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.TableHeader")}, patterns.size());
        int row = 0;
        for (String p : patterns) {
            model.setValueAt(p, row++, 0);
        }
        return model;
    }

    private void initList() {
        this.mimeIdentifiers = Settings.getDefault().getMimeIdentifiers();
        this.extensionIdentifiers = Settings.getDefault().getExtensionIdentifiers();
        this.listIdentifiers.setCellRenderer(new IdentifierRenderer());
        this.updateListModel();
        this.listIdentifiers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ToDoCustomizer.this.listIdentifiers.getSelectedIndex();
                ToDoCustomizer.this.btnRemoveMime.setEnabled(index != -1 && index != 0 && index != ToDoCustomizer.this.mimeIdentifiers.size() + 1);
                ToDoCustomizer.this.updateMimeDetails(index);
            }
        });
    }

    private void updateMimeDetails(int index) {
        if (index == this.selectedIndex) {
            return;
        }
        this.removeDocumentListeners();
        this.saveDetails(index == -1 ? index : this.selectedIndex);
        this.loadDetails(index);
        this.addDocumentListeners();
        this.selectedIndex = index;
    }

    private boolean saveDetails(int index) {
        if (index == -1 || index == this.identifierModel.getSize()) {
            return false;
        }
        Object elementAt = this.identifierModel.getElementAt(index);
        if (elementAt instanceof FileIdentifier) {
            FileIdentifier identifier = (FileIdentifier)elementAt;
            CommentTags tag = identifier.getCommentTags();
            CommentTags commentTag = new CommentTags(this.chbLine.isSelected() ? this.txtLine.getText().trim() : "", this.chbBlock.isSelected() ? this.txtBlockStart.getText().trim() : "", this.chbBlock.isSelected() ? this.txtBlockEnd.getText().trim() : "");
            String id = identifier.getId();
            if (!(tag.isBlockCommentEnabled() == commentTag.isBlockCommentEnabled() && tag.isLineCommentEnabled() == commentTag.isLineCommentEnabled() && tag.getLineComment().equals(commentTag.getLineComment()) && tag.getBlockCommentStart().equals(commentTag.getBlockCommentStart()) && tag.getBlockCommentEnd().equals(commentTag.getBlockCommentEnd()))) {
                id2comments.put(id, commentTag);
            } else {
                id2comments.remove(id);
            }
            this.fireChanged();
            return this.isCommentTagValid(identifier);
        }
        return false;
    }

    private void loadDetails(int index) {
        if (index == -1 || !(this.identifierModel.getElementAt(index) instanceof FileIdentifier)) {
            this.disableDetails();
            return;
        }
        FileIdentifier identifier = (FileIdentifier)this.identifierModel.getElementAt(index);
        CommentTags tag = id2comments.containsKey(identifier.getId()) ? id2comments.get(identifier.getId()) : identifier.getCommentTags();
        this.lblMimeName.setText(identifier.getDisplayName() + " - " + NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblMimeName.text"));
        this.chbLine.setEnabled(true);
        this.chbLine.setSelected(this.isCommentTagValid(identifier) ? !tag.getLineComment().isEmpty() : true);
        this.updateEnableLine();
        this.txtLine.setText(tag.getLineComment());
        this.chbBlock.setEnabled(true);
        this.chbBlock.setSelected(this.isCommentTagValid(identifier) ? !tag.getBlockCommentStart().isEmpty() : true);
        this.updateEnableBlock();
        this.txtBlockStart.setText(tag.getBlockCommentStart());
        this.txtBlockEnd.setText(tag.getBlockCommentEnd());
        this.fireChanged();
    }

    private void disableDetails() {
        this.lblMimeName.setText(NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblMimeName.text"));
        this.chbLine.setSelected(false);
        this.chbLine.setEnabled(false);
        this.updateEnableLine();
        this.txtLine.setText("");
        this.chbBlock.setSelected(false);
        this.chbBlock.setEnabled(false);
        this.updateEnableBlock();
        this.txtBlockStart.setText("");
        this.txtBlockEnd.setText("");
    }

    private void updateListModel() {
        int index = this.mimeIdentifiers.isEmpty() ? -1 : 0;
        this.updateListModel(index);
    }

    private void updateListModel(int indextToSelect) {
        this.identifierModel = new IdentifierModel();
        this.listIdentifiers.setModel(this.identifierModel);
        this.listIdentifiers.setSelectedIndex(indextToSelect);
        this.listIdentifiers.ensureIndexIsVisible(indextToSelect);
        this.fireChanged();
    }

    private void addSelectedToModel(List<FileIdentifier> selectedIdentifiers) {
        boolean isMime = true;
        for (FileIdentifier fileIdentifier : selectedIdentifiers) {
            isMime = fileIdentifier.getType().equals((Object)FileIdentifier.Type.MIME);
            if (isMime) {
                this.mimeIdentifiers.add((MimeIdentifier)fileIdentifier);
                continue;
            }
            this.extensionIdentifiers.add((ExtensionIdentifier)fileIdentifier);
        }
        int indexToSelect = isMime ? this.mimeIdentifiers.size() : this.mimeIdentifiers.size() + this.extensionIdentifiers.size() + 1;
        this.updateListModel(indexToSelect);
        boolean oldChanged = this.changed;
        this.firePropertyChange("changed", oldChanged, true);
        this.firePropertyChange("valid", null, null);
    }

    private List<MimeIdentifier> loadMimeTypes() {
        Collection<String> mimeTypes = this.readMimeTypes();
        ArrayList<MimeIdentifier> mimeItems = new ArrayList<MimeIdentifier>(mimeTypes.size());
        for (String mimeType : mimeTypes) {
            MimeIdentifier mimeItem = new MimeIdentifier(mimeType, ToDoCustomizer.getLoaderDisplayName(mimeType));
            mimeItems.add(mimeItem);
        }
        Collections.sort(mimeItems);
        return mimeItems;
    }

    private Collection<String> readMimeTypes() {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        FileObject[] children = FileUtil.getConfigFile((String)"Loaders").getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject child = children[i];
            String mime1 = child.getNameExt();
            FileObject[] subchildren = child.getChildren();
            for (int j = 0; j < subchildren.length; ++j) {
                FileObject subchild = subchildren[j];
                FileObject factoriesFO = subchild.getFileObject("Factories");
                if (factoriesFO == null || factoriesFO.getChildren().length <= 0) continue;
                mimeTypes.add(mime1 + "/" + subchild.getNameExt());
            }
        }
        mimeTypes.remove("content/unknown");
        return mimeTypes;
    }

    private static String getLoaderDisplayName(String mimeType) {
        FileSystem filesystem = null;
        try {
            filesystem = FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        FileObject factoriesFO = FileUtil.getConfigFile((String)("Loaders/" + mimeType + "/Factories"));
        if (factoriesFO != null) {
            FileObject[] children;
            for (FileObject child : children = factoriesFO.getChildren()) {
                String displayName;
                String childName = child.getNameExt();
                if (childName.equals(displayName = filesystem.getStatus().annotateName(childName, Collections.singleton(child)))) continue;
                return displayName;
            }
        }
        return null;
    }

    private void initComponents() {
        this.lblExtensions1 = new JLabel();
        this.sepExtension1 = new JSeparator();
        this.btnAdd = new JButton();
        this.btnChange = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new MyTable();
        this.checkScanCommentsOnly = new JCheckBox();
        this.btnRemove = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listIdentifiers = new JList();
        this.lblExtensions = new JLabel();
        this.sepExtension = new JSeparator();
        this.lblTodo = new JLabel();
        this.sepTodo = new JSeparator();
        this.btnAddMime = new JButton();
        this.btnRemoveMime = new JButton();
        this.pnlExtensionDetails = new JPanel();
        this.lblBlockEnd = new JLabel();
        this.lblBlockStart = new JLabel();
        this.txtBlockEnd = new JTextField();
        this.chbLine = new JCheckBox();
        this.chbBlock = new JCheckBox();
        this.txtLine = new JTextField();
        this.txtBlockStart = new JTextField();
        this.lblMimeName = new JLabel();
        this.sepExtension2 = new JSeparator();
        this.lblLine = new JLabel();
        this.lblError = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lblExtensions1, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblExtensions1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnChange, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnChange.text"));
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnChangeActionPerformed(evt);
            }
        });
        this.jScrollPane1.setOpaque(false);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setOpaque(false);
        this.table.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.checkScanCommentsOnly, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.checkScanCommentsOnly.text"));
        this.checkScanCommentsOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkScanCommentsOnly.setMargin(new Insets(0, 0, 0, 0));
        this.checkScanCommentsOnly.setOpaque(false);
        this.checkScanCommentsOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ToDoCustomizer.this.scanCommentsOnlyChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnRemoveActionPerformed(evt);
            }
        });
        this.listIdentifiers.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1aaaaa", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listIdentifiers.setSelectionMode(0);
        this.listIdentifiers.setMinimumSize(new Dimension(120, 80));
        this.jScrollPane2.setViewportView(this.listIdentifiers);
        Mnemonics.setLocalizedText((JLabel)this.lblExtensions, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblExtensions.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblTodo, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblTodo.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddMime, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnAddMime.text"));
        this.btnAddMime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnAddMimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveMime, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnRemoveMime.text"));
        this.btnRemoveMime.setEnabled(false);
        this.btnRemoveMime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnRemoveMimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblBlockEnd, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblBlockEnd.text"));
        this.lblBlockEnd.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.lblBlockStart, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblBlockStart.text"));
        this.lblBlockStart.setEnabled(false);
        this.txtBlockEnd.setEnabled(false);
        this.txtBlockEnd.setMinimumSize(new Dimension(100, 20));
        Mnemonics.setLocalizedText((AbstractButton)this.chbLine, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.chbLine.text"));
        this.chbLine.setEnabled(false);
        this.chbLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.chbLineActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chbBlock, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.chbBlock.text"));
        this.chbBlock.setEnabled(false);
        this.chbBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.chbBlockActionPerformed(evt);
            }
        });
        this.txtLine.setEnabled(false);
        this.txtLine.setMinimumSize(new Dimension(100, 20));
        this.txtBlockStart.setEnabled(false);
        this.txtBlockStart.setMinimumSize(new Dimension(100, 20));
        this.lblMimeName.setFont(this.lblMimeName.getFont());
        Mnemonics.setLocalizedText((JLabel)this.lblMimeName, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblMimeName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblLine, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblLine.text"));
        this.lblLine.setEnabled(false);
        GroupLayout pnlExtensionDetailsLayout = new GroupLayout(this.pnlExtensionDetails);
        this.pnlExtensionDetails.setLayout(pnlExtensionDetailsLayout);
        pnlExtensionDetailsLayout.setHorizontalGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExtensionDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExtensionDetailsLayout.createSequentialGroup().addComponent(this.chbLine).addGap(0, 0, Short.MAX_VALUE)).addGroup(pnlExtensionDetailsLayout.createSequentialGroup().addComponent(this.chbBlock).addGap(243, 243, 243)).addGroup(pnlExtensionDetailsLayout.createSequentialGroup().addComponent(this.lblMimeName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepExtension2)).addGroup(pnlExtensionDetailsLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBlockStart).addComponent(this.lblBlockEnd).addComponent(this.lblLine)).addGap(18, 18, 18).addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtBlockStart, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.txtLine, -1, -1, Short.MAX_VALUE).addComponent(this.txtBlockEnd, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        pnlExtensionDetailsLayout.setVerticalGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlExtensionDetailsLayout.createSequentialGroup().addContainerGap().addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sepExtension2, -2, -1, -2).addComponent(this.lblMimeName)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chbLine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLine, -2, -1, -2).addComponent(this.lblLine)).addGap(18, 18, 18).addComponent(this.chbBlock).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBlockStart).addComponent(this.txtBlockStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExtensionDetailsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBlockEnd).addComponent(this.txtBlockEnd, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/tasklist/todo/settings/error.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblError, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.lblError.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblExtensions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepExtension)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblTodo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepTodo)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 514, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnChange, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnAdd, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemove, -1, 73, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkScanCommentsOnly).addGroup(layout.createSequentialGroup().addComponent(this.btnAddMime, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveMime))).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlExtensionDetails, -2, -1, -2)))).addComponent(this.lblError, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sepTodo, -2, -1, -2).addComponent(this.lblTodo)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove)).addComponent(this.jScrollPane1, -2, 109, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkScanCommentsOnly).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sepExtension, -2, -1, -2).addComponent(this.lblExtensions)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlExtensionDetails, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddMime).addComponent(this.btnRemoveMime)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblError)));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        TableCellEditor editor = this.table.getCellEditor();
        if (null != editor) {
            editor.cancelCellEditing();
        }
        boolean wasValid = this.isDataValid();
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.removeRow(selRow);
        if (selRow > model.getRowCount() - 1) {
            --selRow;
        }
        if (selRow >= 0) {
            this.table.getSelectionModel().setSelectionInterval(selRow, selRow);
        }
        boolean wasChanged = this.changed;
        this.fireChanged();
        this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
        this.firePropertyChange("valid", new Boolean(wasValid), new Boolean(this.isDataValid()));
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        final int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        final boolean wasChanged = this.changed;
        this.table.editCellAt(selRow, 0);
        final TableCellEditor editor = this.table.getCellEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                editor.removeCellEditorListener(this);
                ToDoCustomizer.this.table.setValueAt(editor.getCellEditorValue(), selRow, 0);
                ToDoCustomizer.this.fireChanged();
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                editor.removeCellEditorListener(this);
            }
        });
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        final DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addRow(new Object[]{this.getDummyPattern()});
        this.table.getSelectionModel().setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(model.getRowCount() - 1, 0, true)));
        final boolean wasChanged = this.changed;
        this.table.editCellAt(model.getRowCount() - 1, 0);
        final TableCellEditor editor = this.table.getCellEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                editor.removeCellEditorListener(this);
                ToDoCustomizer.this.table.setValueAt(editor.getCellEditorValue(), model.getRowCount() - 1, 0);
                ToDoCustomizer.this.fireChanged();
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                editor.removeCellEditorListener(this);
            }
        });
    }

    private void scanCommentsOnlyChanged(ItemEvent evt) {
        if (this.isUpdating) {
            return;
        }
        boolean wasChanged = this.changed;
        this.fireChanged();
        this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
    }

    private void btnAddMimeActionPerformed(ActionEvent evt) {
        List<MimeIdentifier> allMimeItems = this.loadMimeTypes();
        allMimeItems.removeAll(this.mimeIdentifiers);
        IdentifierPickerPanel picker = new IdentifierPickerPanel(allMimeItems, this.extensionIdentifiers);
        NotifyDescriptor extensionDialog = new NotifyDescriptor((Object)picker, NbBundle.getMessage(ToDoCustomizer.class, (String)"LBL_PickMime"), 2, -1, null, NotifyDescriptor.OK_OPTION);
        picker.addValidityListener(extensionDialog);
        if (DialogDisplayer.getDefault().notify(extensionDialog) == NotifyDescriptor.OK_OPTION) {
            this.addSelectedToModel(picker.getSelectedMimeTypes());
        }
    }

    private void btnRemoveMimeActionPerformed(ActionEvent evt) {
        int selected = this.listIdentifiers.getSelectedIndex();
        if (selected == 0 || selected == this.mimeIdentifiers.size() + 1) {
            return;
        }
        if (selected < this.mimeIdentifiers.size() + 1) {
            this.mimeIdentifiers.remove(selected - 1);
        } else {
            this.extensionIdentifiers.remove(selected - this.mimeIdentifiers.size() - 2);
        }
        int totalSize = this.mimeIdentifiers.size() + this.extensionIdentifiers.size() + 2;
        this.updateListModel(selected < totalSize ? selected : totalSize - 1);
        boolean oldChanged = this.changed;
        this.firePropertyChange("changed", oldChanged, true);
        this.firePropertyChange("valid", null, null);
    }

    private void chbLineActionPerformed(ActionEvent evt) {
        this.updateEnableLine();
        this.validateDetails();
    }

    private void chbBlockActionPerformed(ActionEvent evt) {
        this.updateEnableBlock();
        this.validateDetails();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateDetails();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateDetails();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateDetails();
    }

    private void validateDetails() {
        boolean oldValid = this.detailsValid;
        boolean oldChanged = this.changed;
        this.detailsValid = this.saveDetails(this.selectedIndex);
        this.fireChanged();
        if (!oldChanged) {
            this.firePropertyChange("changed", oldChanged, true);
        }
        if (oldValid != this.detailsValid) {
            this.firePropertyChange("valid", null, null);
        }
    }

    private void updateEnableBlock() {
        this.txtBlockStart.setEnabled(this.chbBlock.isSelected());
        this.lblBlockStart.setEnabled(this.chbBlock.isSelected());
        this.txtBlockEnd.setEnabled(this.chbBlock.isSelected());
        this.lblBlockEnd.setEnabled(this.chbBlock.isSelected());
    }

    private void updateEnableLine() {
        this.txtLine.setEnabled(this.chbLine.isSelected());
        this.lblLine.setEnabled(this.chbLine.isSelected());
    }

    private void addDocumentListeners() {
        this.txtLine.getDocument().addDocumentListener(this);
        this.txtBlockStart.getDocument().addDocumentListener(this);
        this.txtBlockEnd.getDocument().addDocumentListener(this);
    }

    private void removeDocumentListeners() {
        this.txtLine.getDocument().removeDocumentListener(this);
        this.txtBlockStart.getDocument().removeDocumentListener(this);
        this.txtBlockEnd.getDocument().removeDocumentListener(this);
    }

    private String getDummyPattern() {
        return NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.DefaultPattern");
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return NOT_VALID_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return NOT_VALID_ICON.getIconHeight();
        }
    }

    private class IdentifierModel
    extends AbstractListModel {
        private IdentifierModel() {
        }

        @Override
        public int getSize() {
            return ToDoCustomizer.this.mimeIdentifiers.size() + ToDoCustomizer.this.extensionIdentifiers.size() + 2;
        }

        @Override
        public Object getElementAt(int index) {
            if (index == 0) {
                return "---------- " + FileIdentifier.Type.MIME.getDisplayName() + " ----------";
            }
            if (index < ToDoCustomizer.this.mimeIdentifiers.size() + 1) {
                return ToDoCustomizer.this.mimeIdentifiers.get(index - 1);
            }
            if (index == ToDoCustomizer.this.mimeIdentifiers.size() + 1) {
                return "---------- " + FileIdentifier.Type.EXTENSION.getDisplayName() + " ----------";
            }
            return ToDoCustomizer.this.extensionIdentifiers.get(index - ToDoCustomizer.this.mimeIdentifiers.size() - 2);
        }
    }

    private class IdentifierRenderer
    extends DefaultListCellRenderer {
        private IdentifierRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JLabel) {
                JLabel jLabel = (JLabel)comp;
                if (value instanceof FileIdentifier) {
                    FileIdentifier identifier = (FileIdentifier)value;
                    if (ToDoCustomizer.this.isCommentTagValid(identifier)) {
                        jLabel.setIcon(EMPTY_ICON);
                    } else {
                        jLabel.setIcon(NOT_VALID_ICON);
                    }
                } else if (!isSelected) {
                    ((JLabel)comp).setForeground(UIManager.getColor("Label.disabledForeground"));
                }
            }
            return comp;
        }
    }

    private static class MyTable
    extends JTable {
        private MyTable() {
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component res = super.prepareEditor(editor, row, column);
            if (res instanceof JTextComponent) {
                final JTextComponent txt = (JTextComponent)res;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        txt.selectAll();
                        txt.requestFocusInWindow();
                    }
                });
            }
            return res;
        }
    }
}

