/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class EditorContextDispatcher {
    private static final Logger logger = Logger.getLogger(EditorContextDispatcher.class.getName());
    public static final String PROP_FILE = "file";
    public static final String PROP_EDITOR = "editor";
    private static EditorContextDispatcher context;
    private final RequestProcessor refreshProcessor;
    private final Lookup.Result<FileObject> resFileObject;
    private final PropertyChangeListener erListener;
    private final ThreadLocal<CoalescedChange> lookupCoalescedChange = new ThreadLocal();
    private final RequestProcessor ccrp = new RequestProcessor("Coalesced Change Request Processor", 1, false, false);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, PropertyChangeSupport> pcsByMIMEType = new HashMap<String, PropertyChangeSupport>();
    private String lastFiredMIMEType = null;
    private Map<String, Object> lastMIMETypeEvents = new HashMap<String, Object>();
    private static final Reference<FileObject> NO_FILE;
    private static final Reference<JTextComponent> NO_TEXT_COMPONENT;
    private static final Reference<FileChangeListener> NO_FILE_CHANGE;
    private String currentURL;
    private Reference<FileObject> currentFile = NO_FILE;
    private FileChangeListener currentFileChangeListener = null;
    private Reference<FileChangeListener> currentFileChangeListenerWeak = NO_FILE_CHANGE;
    private Reference<JTextComponent> currentTextComponent = NO_TEXT_COMPONENT;
    private Reference<FileObject> mostRecentFileRef = NO_FILE;
    private FileChangeListener mostRecentFileChangeListener = null;
    private Reference<FileChangeListener> mostRecentFileChangeListenerWeak = NO_FILE_CHANGE;

    public static synchronized EditorContextDispatcher getDefault() {
        if (context == null) {
            context = new EditorContextDispatcher();
        }
        return context;
    }

    private EditorContextDispatcher() {
        this.refreshProcessor = new RequestProcessor("Refresh Editor Context", 1);
        this.resFileObject = Utilities.actionsGlobalContext().lookupResult(FileObject.class);
        EditorLookupListener ell = new EditorLookupListener(FileObject.class);
        this.resFileObject.addLookupListener((LookupListener)ell);
        ell.lookupChanged(false);
        this.erListener = new EditorRegistryListener();
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this.erListener, EditorRegistry.class));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((EditorRegistryListener)EditorContextDispatcher.this.erListener).update(false);
            }
        });
    }

    public synchronized FileObject getCurrentFile() {
        return this.currentFile.get();
    }

    public synchronized String getCurrentURLAsString() {
        if (this.currentURL == null) {
            FileObject fo = this.getCurrentFile();
            if (fo != null) {
                this.currentURL = fo.toURL().toString();
            }
            if (this.currentURL == null) {
                this.currentURL = "";
            }
        }
        return this.currentURL;
    }

    private EditorCookie getCurrentEditorCookie() {
        Document document;
        DataObject dataObject;
        JEditorPane editor = this.getCurrentEditor();
        if (editor != null && (dataObject = NbEditorUtilities.getDataObject((Document)(document = editor.getDocument()))) != null) {
            EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            return ec;
        }
        return null;
    }

    public synchronized JEditorPane getCurrentEditor() {
        JTextComponent ctc = this.currentTextComponent.get();
        if (ctc instanceof JEditorPane) {
            return (JEditorPane)ctc;
        }
        return null;
    }

    public int getCurrentLineNumber() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    public Line getCurrentLine() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return null;
        }
        int lineNumber = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        Line.Set lineSet = e.getLineSet();
        try {
            assert (lineSet != null) : e;
            return lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public synchronized FileObject getMostRecentFile() {
        return this.mostRecentFileRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMostRecentFile(FileObject file) {
        FileObject oldFile;
        String MIMEType = null;
        EditorContextDispatcher editorContextDispatcher = this;
        synchronized (editorContextDispatcher) {
            oldFile = this.mostRecentFileRef.get();
            this.mostRecentFileRef = new WeakReference<FileObject>(file);
            if (file != null) {
                MIMEType = file.getMIMEType();
            }
        }
        this.refreshProcessor.post((Runnable)new EventFirer(PROP_EDITOR, oldFile, file, MIMEType));
    }

    public synchronized String getMostRecentURLAsString() {
        FileObject fo = this.getMostRecentFile();
        if (fo != null) {
            return fo.toURL().toString();
        }
        return "";
    }

    private EditorCookie getMostRecentEditorCookie() {
        Document document;
        DataObject dataObject;
        JEditorPane editor = this.getMostRecentEditor();
        if (editor != null && (dataObject = NbEditorUtilities.getDataObject((Document)(document = editor.getDocument()))) != null) {
            EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            return ec;
        }
        return null;
    }

    public JEditorPane getMostRecentEditor() {
        JTextComponent ctc = EditorRegistry.lastFocusedComponent();
        if (ctc instanceof JEditorPane) {
            return (JEditorPane)ctc;
        }
        return null;
    }

    public int getMostRecentLineNumber() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getMostRecentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    public Line getMostRecentLine() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = this.getMostRecentEditor();
        if (ep == null) {
            return null;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return null;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return null;
        }
        int lineNumber = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        Line.Set lineSet = e.getLineSet();
        try {
            return lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            HashSet<String> MIMETypes = new HashSet<String>(this.pcsByMIMEType.keySet());
            for (String MIMEType : MIMETypes) {
                PropertyChangeSupport _pcs = this.pcsByMIMEType.get(MIMEType);
                _pcs.removePropertyChangeListener(l);
                if (_pcs.getPropertyChangeListeners().length != 0) continue;
                this.pcsByMIMEType.remove(MIMEType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String MIMEType, PropertyChangeListener l) {
        PropertyChangeSupport _pcs;
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            _pcs = this.pcsByMIMEType.get(MIMEType);
            if (_pcs == null) {
                _pcs = new PropertyChangeSupport(this);
                this.pcsByMIMEType.put(MIMEType, _pcs);
            }
        }
        _pcs.addPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent evt, String preferredMIMEType) {
        block27: {
            Object object;
            block26: {
                HashMap<String, Object> lastEvents;
                this.pcs.firePropertyChange(evt);
                if (!PROP_FILE.equals(evt.getPropertyName())) break block26;
                FileObject oldFile = (FileObject)evt.getOldValue();
                FileObject newFile = (FileObject)evt.getNewValue();
                String oldMIMEType = oldFile != null ? oldFile.getMIMEType() : null;
                String newMIMEType = newFile != null ? newFile.getMIMEType() : null;
                PropertyChangeSupport pcsMIMEOld = null;
                PropertyChangeSupport pcsMIMENew = null;
                PropertyChangeEvent evtOld = null;
                PropertyChangeEvent evtNew = null;
                Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
                synchronized (map) {
                    if (oldMIMEType != null && oldMIMEType.equals(newMIMEType)) {
                        pcsMIMEOld = this.pcsByMIMEType.get(oldMIMEType);
                        evtOld = evt;
                    } else {
                        if (oldMIMEType != null && (pcsMIMEOld = this.pcsByMIMEType.get(oldMIMEType)) != null) {
                            evtOld = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), null);
                        }
                        if (newMIMEType != null && (pcsMIMENew = this.pcsByMIMEType.get(newMIMEType)) != null) {
                            evtNew = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), null, evt.getNewValue());
                        }
                    }
                }
                if (pcsMIMEOld != null) {
                    pcsMIMEOld.firePropertyChange(evtOld);
                }
                if (pcsMIMENew != null) {
                    pcsMIMENew.firePropertyChange(evtNew);
                }
                if (oldMIMEType == null || oldMIMEType.equals(newMIMEType) || pcsMIMEOld == null) break block27;
                EditorContextDispatcher editorContextDispatcher = this;
                synchronized (editorContextDispatcher) {
                    String lastMIMEType = this.lastFiredMIMEType;
                    lastEvents = new HashMap<String, Object>(this.lastMIMETypeEvents);
                    if (lastMIMEType != null && lastMIMEType.equals(oldMIMEType)) {
                        this.lastFiredMIMEType = null;
                        this.lastMIMETypeEvents.clear();
                    } else {
                        lastEvents = null;
                    }
                }
                if (lastEvents != null) {
                    for (String property : lastEvents.keySet()) {
                        pcsMIMEOld.firePropertyChange(property, lastEvents.get(property), null);
                    }
                }
                break block27;
            }
            PropertyChangeSupport pcsMIME = null;
            if (preferredMIMEType != null) {
                object = this.pcsByMIMEType;
                synchronized (object) {
                    pcsMIME = this.pcsByMIMEType.get(preferredMIMEType);
                }
                if (pcsMIME != null) {
                    pcsMIME.firePropertyChange(evt);
                }
            }
            object = this;
            synchronized (object) {
                if (pcsMIME != null) {
                    this.lastFiredMIMEType = preferredMIMEType;
                    this.lastMIMETypeEvents.put(evt.getPropertyName(), evt.getNewValue());
                } else {
                    this.lastFiredMIMEType = null;
                    this.lastMIMETypeEvents.clear();
                }
            }
        }
    }

    private void reAttachFileChangeListener(FileObject oldFile, FileObject newFile, boolean current) {
        assert (Thread.holdsLock(this));
        if (current) {
            FileChangeListener chw;
            if (oldFile != null && (chw = this.currentFileChangeListenerWeak.get()) != null) {
                AddRemoveFileListenerInEQThread.removeFileChangeListener(oldFile, chw);
                this.currentFileChangeListenerWeak = NO_FILE_CHANGE;
                this.currentFileChangeListener = null;
            }
            if (newFile != null) {
                this.currentFileChangeListener = new FileRenameListener();
                chw = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.currentFileChangeListener, (Object)newFile);
                AddRemoveFileListenerInEQThread.addFileChangeListener(newFile, chw);
                this.currentFileChangeListenerWeak = new WeakReference<FileChangeListener>(chw);
            }
        } else {
            FileChangeListener chw;
            if (oldFile != null && (chw = this.mostRecentFileChangeListenerWeak.get()) != null) {
                AddRemoveFileListenerInEQThread.removeFileChangeListener(oldFile, chw);
                this.mostRecentFileChangeListenerWeak = NO_FILE_CHANGE;
                this.mostRecentFileChangeListener = null;
            }
            if (newFile != null) {
                this.mostRecentFileChangeListener = new FileRenameListener();
                chw = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.mostRecentFileChangeListener, (Object)newFile);
                AddRemoveFileListenerInEQThread.addFileChangeListener(newFile, chw);
                this.mostRecentFileChangeListenerWeak = new WeakReference<FileChangeListener>(chw);
            }
        }
    }

    static {
        NO_FILE = new WeakReference<Object>(null);
        NO_TEXT_COMPONENT = new WeakReference<Object>(null);
        NO_FILE_CHANGE = new WeakReference<Object>(null);
    }

    private static final class AddRemoveFileListenerInEQThread
    implements Runnable {
        private static final Queue<Work> work = new LinkedList<Work>();
        private static final RequestProcessor rp = new RequestProcessor(AddRemoveFileListenerInEQThread.class.getName(), 1, false, false);
        private static RequestProcessor.Task t;
        private static final int TIMEOUT = 250;

        private AddRemoveFileListenerInEQThread() {
        }

        public static void addFileChangeListener(FileObject fo, FileChangeListener l) {
            AddRemoveFileListenerInEQThread.doWork(new Work(AddRemove.ADD, fo, l));
        }

        public static void removeFileChangeListener(FileObject fo, FileChangeListener l) {
            AddRemoveFileListenerInEQThread.doWork(new Work(AddRemove.REMOVE, fo, l));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doWork(Work w) {
            Class<AddRemoveFileListenerInEQThread> clazz = AddRemoveFileListenerInEQThread.class;
            synchronized (AddRemoveFileListenerInEQThread.class) {
                work.add(w);
                if (t == null) {
                    t = rp.create((Runnable)new AddRemoveFileListenerInEQThread());
                }
                t.schedule(0);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    w.waitFinished(250);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
        }

        private static synchronized Work getWork() {
            return work.poll();
        }

        @Override
        public void run() {
            Work w;
            while ((w = AddRemoveFileListenerInEQThread.getWork()) != null) {
                switch (w.ar) {
                    case ADD: {
                        w.fo.addFileChangeListener(w.l);
                        break;
                    }
                    case REMOVE: {
                        w.fo.removeFileChangeListener(w.l);
                    }
                }
                w.finished();
            }
        }

        private static enum AddRemove {
            ADD,
            REMOVE;

        }

        private static final class Work {
            AddRemove ar;
            FileObject fo;
            FileChangeListener l;
            boolean finished;

            Work(AddRemove ar, FileObject fo, FileChangeListener l) {
                this.ar = ar;
                this.fo = fo;
                this.l = l;
            }

            private synchronized void finished() {
                this.finished = true;
                this.notifyAll();
            }

            private synchronized void waitFinished(int timeout) throws InterruptedException {
                if (!this.finished) {
                    this.wait(timeout);
                }
            }
        }
    }

    private static final class CoalescedChange {
        private static final int NUM = 5;
        private static final long TD = 20L;
        private long lastTime = 0L;
        private int num = 0;

        public void done() {
            this.lastTime = System.currentTimeMillis();
        }

        private boolean isCoalescing() {
            this.num = System.currentTimeMillis() <= this.lastTime + 20L ? ++this.num : 0;
            return this.num > 5;
        }
    }

    private class EditorLookupListener
    implements LookupListener {
        private RequestProcessor.Task cctask;
        private Class type;

        public EditorLookupListener(Class type) {
            this.type = type;
        }

        public void resultChanged(LookupEvent ev) {
            this.coalescedLookupChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void coalescedLookupChanged() {
            CoalescedChange cc = (CoalescedChange)EditorContextDispatcher.this.lookupCoalescedChange.get();
            if (cc == null) {
                cc = new CoalescedChange();
                EditorContextDispatcher.this.lookupCoalescedChange.set(cc);
            }
            Collection fos = null;
            boolean doCoalescing = cc.isCoalescing();
            if (!doCoalescing && SwingUtilities.isEventDispatchThread() && this.type == FileObject.class && (fos = EditorContextDispatcher.this.resFileObject.allInstances()).size() > 1) {
                doCoalescing = true;
            }
            if (doCoalescing) {
                RequestProcessor.Task task;
                EditorLookupListener editorLookupListener = this;
                synchronized (editorLookupListener) {
                    if (this.cctask == null) {
                        this.cctask = EditorContextDispatcher.this.ccrp.create(new Runnable(){

                            @Override
                            public void run() {
                                EditorLookupListener.this.lookupChanged(true);
                            }
                        });
                    }
                    task = this.cctask;
                }
                task.schedule(2);
            } else {
                this.lookupChanged(true, fos);
            }
            cc.done();
        }

        private void lookupChanged(boolean doFire) {
            this.lookupChanged(doFire, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookupChanged(boolean doFire, Collection<? extends FileObject> fos) {
            if (this.type == FileObject.class) {
                FileObject oldFile;
                if (fos == null) {
                    fos = EditorContextDispatcher.this.resFileObject.allInstances();
                }
                FileObject newFile = fos.isEmpty() ? null : (fos.size() == 1 ? (FileObject)fos.iterator().next() : this.findPrimary(fos));
                EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
                synchronized (editorContextDispatcher) {
                    oldFile = (FileObject)EditorContextDispatcher.this.currentFile.get();
                    EditorContextDispatcher.this.currentFile = newFile == null ? NO_FILE : new WeakReference<FileObject>(newFile);
                    EditorContextDispatcher.this.currentURL = null;
                    if (newFile != null) {
                        EditorContextDispatcher.this.mostRecentFileRef = EditorContextDispatcher.this.currentFile;
                    }
                    EditorContextDispatcher.this.reAttachFileChangeListener(oldFile, newFile, true);
                }
                if (doFire && oldFile != newFile) {
                    EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_FILE, oldFile, newFile));
                }
            }
        }

        private FileObject findPrimary(Collection<? extends FileObject> fos) {
            for (FileObject fileObject : fos) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fileObject);
                    if (!fileObject.equals(dobj.getPrimaryFile())) continue;
                    return fileObject;
                }
                catch (DataObjectNotFoundException ex) {
                }
            }
            return fos.iterator().next();
        }
    }

    private class EditorRegistryListener
    implements PropertyChangeListener,
    FocusListener {
        private EditorRegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JRootPane root;
            Object newFocused;
            String propertyName = evt.getPropertyName();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("EditorRegistryListener.propertyChange(" + propertyName + ": " + evt.getOldValue() + " => " + evt.getNewValue() + ")");
            }
            if (propertyName.equals("focusLost") && (newFocused = evt.getNewValue()) instanceof JRootPane && (root = (JRootPane)newFocused).isAncestorOf((Component)evt.getOldValue())) {
                logger.fine("Focused root.");
                root.addFocusListener(this);
                return;
            }
            if (propertyName.equals("focusGained") || propertyName.equals("focusLost") || propertyName.equals("focusedDocument")) {
                this.update(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(boolean doFire) {
            JTextComponent newEditor;
            JTextComponent oldEditor;
            JTextComponent focusedComponent = EditorRegistry.focusedComponent();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("New focused component = " + focusedComponent);
            }
            String MIMEType = null;
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                oldEditor = (JTextComponent)EditorContextDispatcher.this.currentTextComponent.get();
                if (focusedComponent != null) {
                    EditorContextDispatcher.this.currentTextComponent = new WeakReference<JTextComponent>(focusedComponent);
                } else {
                    EditorContextDispatcher.this.currentTextComponent = NO_TEXT_COMPONENT;
                }
                newEditor = (JTextComponent)EditorContextDispatcher.this.currentTextComponent.get();
                FileObject f = (FileObject)EditorContextDispatcher.this.currentFile.get();
                if (f != null) {
                    if (newEditor != null) {
                        EditorContextDispatcher.this.reAttachFileChangeListener((FileObject)EditorContextDispatcher.this.mostRecentFileRef.get(), f, false);
                        EditorContextDispatcher.this.mostRecentFileRef = new WeakReference<FileObject>(f);
                    }
                    if (doFire && oldEditor != newEditor) {
                        this.lazyRetrieveMIMETypeAndFire(oldEditor, newEditor, f);
                        doFire = false;
                    }
                } else {
                    MIMEType = null;
                }
            }
            if (doFire && oldEditor != newEditor) {
                EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_EDITOR, oldEditor, newEditor, MIMEType));
            }
        }

        private void lazyRetrieveMIMETypeAndFire(final JTextComponent oldEditor, final JTextComponent newEditor, final FileObject f) {
            EditorContextDispatcher.this.refreshProcessor.post(new Runnable(){

                @Override
                public void run() {
                    String MIMEType = f.getMIMEType();
                    new EventFirer(EditorContextDispatcher.PROP_EDITOR, oldEditor, newEditor, MIMEType).run();
                }
            });
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Focus Lost from " + e.getComponent());
                logger.fine("  opposite component is: " + e.getOppositeComponent());
            }
            e.getComponent().removeFocusListener(this);
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                if (e.getOppositeComponent() == EditorContextDispatcher.this.currentTextComponent.get()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Opposite is current. No update.");
                    }
                    return;
                }
            }
            this.update(true);
        }
    }

    private final class EventFirer
    implements Runnable {
        private final PropertyChangeEvent evt;
        private final String MIMEType;

        public EventFirer(String propertyName, Object oldValue, Object newValue) {
            this(propertyName, oldValue, newValue, null);
        }

        public EventFirer(String propertyName, Object oldValue, Object newValue, String MIMEType) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("EventFirer(" + propertyName + ", " + oldValue + ", " + newValue + ")");
            }
            this.evt = new PropertyChangeEvent(EditorContextDispatcher.this, propertyName, oldValue, newValue);
            this.MIMEType = MIMEType;
        }

        @Override
        public void run() {
            EditorContextDispatcher.this.firePropertyChange(this.evt, this.MIMEType);
        }
    }

    private final class FileRenameListener
    extends FileChangeAdapter {
        private FileRenameListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileRenamed(FileRenameEvent fe) {
            boolean doFire;
            FileObject fo = (FileObject)fe.getSource();
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                FileObject currentFO = (FileObject)EditorContextDispatcher.this.currentFile.get();
                FileObject lastFO = (FileObject)EditorContextDispatcher.this.mostRecentFileRef.get();
                boolean bl = doFire = fo.equals(currentFO) || fo.equals(lastFO);
                if (doFire) {
                    EditorContextDispatcher.this.currentURL = null;
                }
            }
            if (doFire) {
                EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_FILE, null, fo, fo.getMIMEType()));
            }
        }
    }
}

