/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.modules.debugger.ui.views.debugging.DebuggingViewComponent;
import org.netbeans.modules.debugger.ui.views.debugging.KeyboardPopupSwitcher;
import org.netbeans.modules.debugger.ui.views.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.ui.views.debugging.ThreadsListener;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ThreadsHistoryAction
extends AbstractAction {
    public ThreadsHistoryAction() {
        this.putValue("Name", NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_ThreadsHistoryAction"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        KeyStroke keyStroke;
        List<DebuggingView.DVThread> threads = ThreadsHistoryAction.getThreads();
        int threadsCount = threads.size();
        if (threadsCount < 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!"immediately".equals(evt.getActionCommand()) && !(evt.getSource() instanceof JMenuItem) && (keyStroke = Utilities.stringToKey((String)evt.getActionCommand())) != null) {
            int triggerKey = keyStroke.getKeyCode();
            int releaseKey = 0;
            int modifiers = keyStroke.getModifiers();
            if ((2 & modifiers) != 0) {
                releaseKey = 17;
            } else if ((8 & modifiers) != 0) {
                releaseKey = 18;
            } else if ((4 & modifiers) != 0) {
                releaseKey = 4;
            }
            if (releaseKey != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    KeyboardPopupSwitcher.selectItem(ThreadsHistoryAction.createSwitcherItems(threads), releaseKey, triggerKey, true, true);
                }
                return;
            }
        }
        if (threadsCount == 1) {
            threads.get(0).makeCurrent();
        } else {
            int index = (evt.getModifiers() & 1) == 0 ? 1 : threadsCount - 1;
            threads.get(index).makeCurrent();
        }
    }

    public static SwitcherTableItem[] createSwitcherItems(List<DebuggingView.DVThread> threads) {
        Set deadlocks;
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        DebuggingView.DVSupport debugger = threadsListener.getDVSupport();
        DebuggingView.DVThread currentThread = debugger != null ? debugger.getCurrentThread() : null;
        Set set = deadlocks = debugger != null ? debugger.getDeadlocks() : Collections.EMPTY_SET;
        if (deadlocks == null) {
            deadlocks = Collections.EMPTY_SET;
        }
        HashSet<DebuggingView.DVThread> deadlockedThreads = new HashSet<DebuggingView.DVThread>();
        for (DebuggingView.Deadlock deadlock : deadlocks) {
            deadlockedThreads.addAll(deadlock.getThreads());
        }
        SwitcherTableItem[] items = new SwitcherTableItem[threads.size()];
        int i = 0;
        for (DebuggingView.DVThread thread : threads) {
            String name;
            String htmlName = name = debugger.getDisplayName(thread);
            String description = "";
            Image image = debugger.getIcon(thread);
            ThreadStatusIcon icon = null;
            if (image != null) {
                boolean isCurrent = thread == currentThread;
                boolean isAtBreakpoint = threadsListener.isBreakpointHit(thread);
                boolean isInDeadlock = deadlockedThreads.contains(thread);
                icon = new ThreadStatusIcon(image, isCurrent, isAtBreakpoint, isInDeadlock);
            }
            items[i] = new SwitcherTableItem(new ActivatableElement(thread), name, htmlName, icon, false, description != null ? description : name);
            ++i;
        }
        return items;
    }

    public static List<DebuggingView.DVThread> getThreads() {
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        if (threadsListener == null) {
            return Collections.emptyList();
        }
        List<DebuggingView.DVThread> history = threadsListener.getCurrentThreadsHistory();
        List<DebuggingView.DVThread> allThreads = threadsListener.getThreads();
        HashSet<DebuggingView.DVThread> hitsSet = new HashSet<DebuggingView.DVThread>();
        for (DebuggingView.DVThread hit : threadsListener.getHits()) {
            hitsSet.add(hit);
        }
        HashSet<DebuggingView.DVThread> set = new HashSet<DebuggingView.DVThread>(history);
        LinkedList<DebuggingView.DVThread> result = new LinkedList<DebuggingView.DVThread>();
        result.addAll(history);
        for (DebuggingView.DVThread thread : allThreads) {
            if (set.contains(thread) || !thread.isSuspended()) continue;
            result.add(thread);
        }
        if (result.size() > 1 && hitsSet.size() > 0) {
            int index = 1;
            int size = result.size();
            for (int x = 1; x < size; ++x) {
                DebuggingView.DVThread t = (DebuggingView.DVThread)result.get(x);
                if (!hitsSet.contains(t)) continue;
                if (x > index) {
                    result.remove(x);
                    result.add(index, t);
                }
                ++index;
            }
        }
        return result;
    }

    private static class ActivatableElement
    implements SwitcherTableItem.Activatable {
        DebuggingView.DVThread thread;

        private ActivatableElement(DebuggingView.DVThread thread) {
            this.thread = thread;
        }

        @Override
        public void activate() {
            this.thread.makeCurrent();
        }
    }

    private static class ThreadStatusIcon
    implements Icon {
        private Image image;
        private ImageIcon iconBase;
        private boolean isCurrent;
        private boolean isAtBreakpoint;
        private boolean isInDeadlock;

        ThreadStatusIcon(Image image, boolean isCurrent, boolean isAtBreakpoint, boolean isInDeadlock) {
            this.image = image;
            this.isCurrent = isCurrent;
            this.isAtBreakpoint = isAtBreakpoint;
            this.isInDeadlock = isInDeadlock;
            this.iconBase = new ImageIcon(image);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.iconBase.getIconWidth();
            int height = this.iconBase.getIconHeight();
            Color primaryColor = null;
            Color secondaryColor = null;
            if (this.isInDeadlock) {
                primaryColor = DebuggingViewComponent.deadlockColor;
            } else if (this.isCurrent) {
                primaryColor = DebuggingViewComponent.greenBarColor;
            } else if (this.isAtBreakpoint) {
                primaryColor = DebuggingViewComponent.hitsBarColor;
            }
            if (this.isCurrent && this.isInDeadlock) {
                secondaryColor = DebuggingViewComponent.greenBarColor;
            }
            Color originalColor = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(x, y, width, height);
            g.drawImage(this.image, x + width, y, this.iconBase.getImageObserver());
            if (primaryColor != null) {
                g.setColor(primaryColor);
                g.fillRect(x, y, 8, height);
            }
            if (secondaryColor != null) {
                g.setColor(secondaryColor);
                int w = 5;
                g.fillRect(x + 8 - w, y, w, height);
            }
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return 2 * this.iconBase.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.iconBase.getIconHeight();
        }
    }
}

