/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.debugger.ui.views.debugging.DebuggingViewComponent;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class DebugTreeView
extends BeanTreeView {
    private static final Logger logger = Logger.getLogger(DebugTreeView.class.getName());
    private int thickness = 0;
    private final Color highlightColor;
    private final Color currentThreadColor;
    private DebuggingView.DVThread focusedThread;
    private DebuggingView.DVSupport currentDVSupport;
    private boolean currentDVSupportSet;
    private final Object currentDVSupportLock = new Object();
    private DebuggerManagerListener dmListener;

    DebugTreeView() {
        int dl;
        Color tbc;
        Color c = UIManager.getColor("nb.debugger.debugging.currentThread");
        if (c == null) {
            c = new Color(233, 255, 230);
            tbc = this.tree.getBackground();
            dl = Math.abs(DebuggingViewComponent.luminance(c) - DebuggingViewComponent.luminance(tbc));
            if (dl > 125) {
                c = new Color(30, 80, 28);
            }
        }
        this.currentThreadColor = c;
        c = UIManager.getColor("nb.debugger.debugging.highlightColor");
        if (c == null) {
            c = new Color(233, 239, 248);
            tbc = this.tree.getBackground();
            dl = Math.abs(DebuggingViewComponent.luminance(c) - DebuggingViewComponent.luminance(tbc));
            if (dl > 125) {
                c = new Color(40, 60, 38);
            }
        }
        this.highlightColor = c;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Debugging view panel background color = " + UIManager.getDefaults().getColor("Panel.background"));
            logger.fine("Debugging view tree text background color = " + UIManager.getDefaults().getColor("Tree.textBackground"));
            logger.fine("Tree color = " + this.tree.getBackground() + ", tree is opaque = " + this.tree.isOpaque());
            logger.fine("Tree parent color = " + ((JComponent)this.tree.getParent()).getBackground() + ", tree parent is opaque = " + ((JComponent)this.tree.getParent()).isOpaque());
            logger.fine("Tree parent = " + this.tree.getParent());
            logger.fine("Current Thread Color = " + this.currentThreadColor);
            logger.fine("Thread Highlight Color = " + this.highlightColor);
        }
        DebugTreeNodeRenderer rend = new DebugTreeNodeRenderer();
        this.tree.setCellRenderer((TreeCellRenderer)((Object)rend));
        this.setBackground(this.tree.getBackground());
        if (!System.getProperty("java.version").startsWith("1.6") || !"GTK".equals(UIManager.getLookAndFeel().getID())) {
            this.tree.setOpaque(false);
            ((JComponent)this.tree.getParent()).setOpaque(false);
        }
        ((JComponent)this.tree.getParent()).setBackground(this.tree.getBackground());
        this.setWheelScrollingEnabled(false);
    }

    public JTree getTree() {
        return this.tree;
    }

    void resetSelection() {
        this.tree.getSelectionModel().clearSelection();
        DebugTreeView.clearSelectionCache(this.tree.getSelectionModel().getRowMapper());
        DebugTreeView.clearDrawingCache(this.tree);
        this.tree.repaint();
    }

    private static void clearSelectionCache(RowMapper rm) {
        if (rm instanceof FixedHeightLayoutCache) {
            try {
                Field infoField = rm.getClass().getDeclaredField("info");
                infoField.setAccessible(true);
                Object searchInfo = infoField.get(rm);
                if (searchInfo != null) {
                    Field nodeField = searchInfo.getClass().getDeclaredField("node");
                    nodeField.setAccessible(true);
                    nodeField.set(searchInfo, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void clearDrawingCache(JTree tree) {
        TreeUI tui = tree.getUI();
        if (tui instanceof BasicTreeUI) {
            try {
                Field drawingCacheField = BasicTreeUI.class.getDeclaredField("drawingCache");
                drawingCacheField.setAccessible(true);
                Map table = (Map)drawingCacheField.get(tui);
                table.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreePath> getVisiblePaths() {
        JTree jTree = this.tree;
        synchronized (jTree) {
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            int count = this.tree.getRowCount();
            for (int x = 0; x < count; ++x) {
                TreePath path = this.tree.getPathForRow(x);
                if (!this.tree.isVisible(path)) continue;
                result.add(path);
            }
            return result;
        }
    }

    public Object getThreadObject(TreePath path) {
        Node node = Visualizer.findNode((Object)path.getLastPathComponent());
        DebuggingView.DVThread dvThread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class);
        if (dvThread != null) {
            return dvThread;
        }
        DebuggingView.DVThreadGroup dvThreadGroup = (DebuggingView.DVThreadGroup)node.getLookup().lookup(DebuggingView.DVThreadGroup.class);
        return dvThreadGroup;
    }

    public int getUnitHeight() {
        return this.thickness;
    }

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        this.tree.addTreeExpansionListener(listener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener listener) {
        this.tree.removeTreeExpansionListener(listener);
    }

    void setExpansionModel(TreeExpansionModel model) {
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintStripes(g, (JComponent)((Object)this));
    }

    void paintStripes(Graphics g, JComponent comp) {
        int clipH;
        int clipW;
        int clipX;
        int clipY;
        Rectangle rect;
        List<TreePath> paths = this.getVisiblePaths();
        int linesNumber = paths.size();
        Rectangle rectangle = rect = paths.size() > 0 ? this.tree.getRowBounds(this.tree.getRowForPath(paths.get(0))) : null;
        if (rect != null) {
            this.thickness = (int)Math.round(rect.getHeight());
        }
        int rowHeight = this.thickness > 0 ? this.thickness : (this.tree.getRowHeight() > 0 ? this.tree.getRowHeight() + 2 : 18);
        int zebraHeight = linesNumber * rowHeight;
        int width = comp.getWidth();
        int height = comp.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Rectangle clipRect = g.getClipBounds();
        if (clipRect == null) {
            clipY = 0;
            clipX = 0;
            clipW = width;
            clipH = height;
        } else {
            clipX = clipRect.x;
            clipY = clipRect.y;
            clipW = clipRect.width;
            clipH = clipRect.height;
        }
        if (clipW > width) {
            clipW = width;
        }
        if (clipH > height) {
            clipH = height;
        }
        Color origColor = g.getColor();
        DebuggingView.DVThread currentThread = this.getCurrentThread();
        boolean isHighlighted = false;
        boolean isCurrent = false;
        Iterator<TreePath> iter = paths.iterator();
        int firstGroupNumber = clipY / rowHeight;
        for (int x = 0; x <= firstGroupNumber && iter.hasNext(); ++x) {
            Node node = Visualizer.findNode((Object)iter.next().getLastPathComponent());
            DebuggingView.DVThread thread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class);
            boolean bl = isHighlighted = this.focusedThread != null && thread == this.focusedThread;
            if (thread == null) continue;
            isCurrent = currentThread == thread;
        }
        int limit = Math.min(clipY + clipH - 1, zebraHeight);
        for (int sy = clipY / rowHeight * rowHeight; sy < limit; sy += rowHeight) {
            int y1 = Math.max(sy, clipY);
            int y2 = Math.min(clipY + clipH, y1 + rowHeight);
            if (isHighlighted || isCurrent) {
                g.setColor(isHighlighted ? this.highlightColor : this.currentThreadColor);
                g.fillRect(clipX, y1, clipW, y2 - y1);
            }
            if (iter.hasNext()) {
                Node node = Visualizer.findNode((Object)iter.next().getLastPathComponent());
                DebuggingView.DVThread thread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class);
                boolean bl = isHighlighted = this.focusedThread != null && thread == this.focusedThread;
                if (thread == null) continue;
                isCurrent = currentThread == thread;
                continue;
            }
            isHighlighted = false;
            isCurrent = false;
        }
        g.setColor(origColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebuggingView.DVSupport getCurrentDVsupport() {
        Object object = this.currentDVSupportLock;
        synchronized (object) {
            if (this.dmListener == null) {
                this.dmListener = new CurrentEngineListener();
                DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", this.dmListener);
            }
            if (this.currentDVSupportSet) {
                return this.currentDVSupport;
            }
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        DebuggingView.DVSupport dvSupport = currentEngine != null ? (DebuggingView.DVSupport)currentEngine.lookupFirst(null, DebuggingView.DVSupport.class) : null;
        Object object2 = this.currentDVSupportLock;
        synchronized (object2) {
            this.currentDVSupport = dvSupport;
            this.currentDVSupportSet = true;
        }
        return dvSupport;
    }

    private DebuggingView.DVThread getCurrentThread() {
        DebuggingView.DVThread currentThread = null;
        DebuggingView.DVSupport dvSupport = this.getCurrentDVsupport();
        if (dvSupport != null) {
            currentThread = dvSupport.getCurrentThread();
        }
        return currentThread;
    }

    boolean threadFocuseGained(DebuggingView.DVThread dvThread) {
        if (dvThread != null && this.focusedThread != dvThread) {
            this.focusedThread = dvThread;
            this.repaint();
            return true;
        }
        return false;
    }

    boolean threadFocuseLost(DebuggingView.DVThread dvThread) {
        if (dvThread != null && this.focusedThread == dvThread) {
            this.focusedThread = null;
            this.repaint();
            return true;
        }
        return false;
    }

    private class CurrentEngineListener
    extends DebuggerManagerAdapter {
        private CurrentEngineListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("currentEngine".equals(evt.getPropertyName())) {
                Object object = DebugTreeView.this.currentDVSupportLock;
                synchronized (object) {
                    DebugTreeView.this.currentDVSupport = null;
                    DebugTreeView.this.currentDVSupportSet = false;
                }
            }
        }
    }

    private class DebugTreeNodeRenderer
    extends NodeRenderer {
        private DebugTreeNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background = null;
            if (value instanceof TreeNode) {
                try {
                    Field fnode = value.getClass().getDeclaredField("node");
                    fnode.setAccessible(true);
                    value = fnode.get(value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (value instanceof Node) {
                DebuggingView.DVThread thread;
                Node node = (Node)value;
                do {
                    if ((thread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class)) != null) continue;
                    node = node.getParentNode();
                } while (thread == null && node != null);
                if (thread != null) {
                    boolean isCurrent;
                    DebuggingView.DVThread currentThread = DebugTreeView.this.getCurrentThread();
                    boolean isHighlighted = DebugTreeView.this.focusedThread != null && thread == DebugTreeView.this.focusedThread && node == value;
                    boolean bl = isCurrent = currentThread == thread;
                    if (isHighlighted || isCurrent) {
                        background = isHighlighted ? DebugTreeView.this.highlightColor : DebugTreeView.this.currentThreadColor;
                    }
                }
            }
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (background != null) {
                component.setBackground(background);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(true);
                }
            }
            return component;
        }
    }
}

