/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.modules.debugger.ui.views.ViewModelListener;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class View
extends TopComponent
implements HelpCtx.Provider {
    public static final String BREAKPOINTS_VIEW_NAME = "BreakpointsView";
    public static final String CALLSTACK_VIEW_NAME = "CallStackView";
    public static final String LOCALS_VIEW_NAME = "LocalsView";
    public static final String SESSIONS_VIEW_NAME = "SessionsView";
    public static final String THREADS_VIEW_NAME = "ThreadsView";
    public static final String WATCHES_VIEW_NAME = "WatchesView";
    public static final String SOURCES_VIEW_NAME = "SourcesView";
    public static final String RESULTS_VIEW_NAME = "ResultsView";
    private transient JComponent contentComponent;
    private transient ViewModelListener viewModelListener;
    protected String name;
    protected transient String helpID;
    protected transient String propertiesHelpID;
    private transient String displayNameResource;
    private transient String toolTipResource;

    protected View(String icon, String name, String helpID, String propertiesHelpID, String displayNameResource, String toolTipResource) {
        this.setIcon(ImageUtilities.loadImage((String)icon));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.name = name;
        this.helpID = helpID;
        this.propertiesHelpID = propertiesHelpID;
        this.displayNameResource = displayNameResource;
        this.toolTipResource = toolTipResource;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name;
    }

    protected void componentShowing() {
        JComponent buttonsPane;
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.contentComponent == null) {
            this.setLayout(new BorderLayout());
            this.contentComponent = new JPanel(new BorderLayout());
            if (this.toolTipResource != null) {
                this.contentComponent.setName(NbBundle.getMessage(View.class, (String)this.toolTipResource));
            }
            this.add(this.contentComponent, "Center");
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.setBorderPainted(true);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
            toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.background")), BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.foreground"))));
            this.add(toolBar, "West");
            buttonsPane = toolBar;
        } else {
            buttonsPane = (JComponent)((BorderLayout)this.getLayout()).getLayoutComponent("West");
        }
        this.viewModelListener = new ViewModelListener(this.name, this.contentComponent, buttonsPane, this.propertiesHelpID, this.getIcon());
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpID);
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.contentComponent == null) {
            return false;
        }
        if (this.contentComponent.getComponentCount() > 0) {
            return this.contentComponent.getComponent(0).requestFocusInWindow();
        }
        return this.contentComponent.requestFocusInWindow();
    }

    public void requestActive() {
        super.requestActive();
        if (this.contentComponent != null) {
            if (this.contentComponent.getComponentCount() > 0) {
                this.contentComponent.getComponent(0).requestFocusInWindow();
            } else {
                this.contentComponent.requestFocusInWindow();
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(View.class, (String)this.displayNameResource);
    }

    public String getToolTipText() {
        return NbBundle.getMessage(View.class, (String)this.toolTipResource);
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.name);
    }

    @Deprecated
    public static synchronized TopComponent getBreakpointsView() {
        return new View("org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint.gif", BREAKPOINTS_VIEW_NAME, "NetbeansDebuggerBreakpointNode", null, "CTL_Breakpoints_view", "CTL_Breakpoints_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getCallStackView() {
        return new View("org/netbeans/modules/debugger/resources/allInOneView/CallStack.gif", CALLSTACK_VIEW_NAME, "NetbeansDebuggerCallStackNode", null, "CTL_Call_stack_view", "CTL_Call_stack_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getLocalsView() {
        return new View("org/netbeans/modules/debugger/resources/localsView/local_variable_16.png", LOCALS_VIEW_NAME, "NetbeansDebuggerVariableNode", null, "CTL_Variables_view", "CTL_Locals_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getSessionsView() {
        return new View("org/netbeans/modules/debugger/resources/sessionsView/session_16.png", SESSIONS_VIEW_NAME, "NetbeansDebuggerSessionNode", "NetbeansDebuggerSessionsPropertiesSheet", "CTL_Sessions_view", "CTL_Sessions_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getThreadsView() {
        return new View("org/netbeans/modules/debugger/resources/threadsView/RunningThread.gif", THREADS_VIEW_NAME, "NetbeansDebuggerThreadNode", "NetbeansDebuggerThreadsPropertiesSheet", "CTL_Threads_view", "CTL_Threads_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getWatchesView() {
        return new View("org/netbeans/modules/debugger/resources/watchesView/watch_16.png", WATCHES_VIEW_NAME, "NetbeansDebuggerWatchNode", null, "CTL_Watches_view", "CTL_Watches_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getSourcesView() {
        return new View("org/netbeans/modules/debugger/resources/sourcesView/sources_16.png", SOURCES_VIEW_NAME, "NetbeansDebuggerSourcesNode", null, "CTL_Sources_view", "CTL_Sources_view_tooltip");
    }

    @Deprecated
    public static synchronized TopComponent getResultsView() {
        return new View("org/netbeans/modules/debugger/resources/sourcesView/sources_16.png", RESULTS_VIEW_NAME, "NetbeansDebuggerResultNode", null, "CTL_Result_view", "CTL_Result_view_tooltip");
    }

    private static TopComponent getView(String viewName) {
        if (viewName.equals(BREAKPOINTS_VIEW_NAME)) {
            return View.getBreakpointsView();
        }
        if (viewName.equals(CALLSTACK_VIEW_NAME)) {
            return View.getCallStackView();
        }
        if (viewName.equals(LOCALS_VIEW_NAME)) {
            return View.getLocalsView();
        }
        if (viewName.equals(SESSIONS_VIEW_NAME)) {
            return View.getSessionsView();
        }
        if (viewName.equals(THREADS_VIEW_NAME)) {
            return View.getThreadsView();
        }
        if (viewName.equals(WATCHES_VIEW_NAME)) {
            return View.getWatchesView();
        }
        if (viewName.equals(SOURCES_VIEW_NAME)) {
            return View.getSourcesView();
        }
        if (viewName.equals(RESULTS_VIEW_NAME)) {
            return View.getResultsView();
        }
        throw new IllegalArgumentException(viewName);
    }

    private static final class ResolvableHelper
    implements Externalizable {
        private String name;
        private static final long serialVersionUID = 1L;

        public ResolvableHelper(String name) {
            this.name = name;
        }

        public ResolvableHelper() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
        }

        public Object readResolve() {
            return View.getView(this.name);
        }
    }
}

