/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.registry;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.ColumnModelRegistration;
import org.netbeans.spi.debugger.ui.ColumnModelRegistrations;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class DebuggerProcessor
extends LayerGeneratingProcessor {
    public static final String SERVICE_NAME = "serviceName";

    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(AttachType.Registration.class.getCanonicalName(), BreakpointType.Registration.class.getCanonicalName(), ColumnModelRegistration.class.getCanonicalName(), ColumnModelRegistrations.class.getCanonicalName(), DebuggingView.DVSupport.Registration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        String path;
        String displayName;
        Annotation reg;
        if (env.processingOver()) {
            return false;
        }
        int cnt = 0;
        for (Element element : env.getElementsAnnotatedWith(AttachType.Registration.class)) {
            reg = element.getAnnotation(AttachType.Registration.class);
            displayName = reg.displayName();
            int position = reg.position();
            this.handleProviderRegistrationDisplayName(element, AttachType.class, displayName, null, position);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(BreakpointType.Registration.class)) {
            reg = element.getAnnotation(BreakpointType.Registration.class);
            displayName = reg.displayName();
            String path2 = reg.path();
            int position = reg.position();
            this.handleProviderRegistrationDisplayName(element, BreakpointType.class, displayName, path2, position);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(ColumnModelRegistration.class)) {
            reg = element.getAnnotation(ColumnModelRegistration.class);
            path = reg.path();
            int position = reg.position();
            this.handleProviderRegistration(element, ColumnModel.class, path, position);
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(ColumnModelRegistrations.class)) {
            ColumnModelRegistrations regs = element.getAnnotation(ColumnModelRegistrations.class);
            for (ColumnModelRegistration reg2 : regs.value()) {
                String path3 = reg2.path();
                int position = reg2.position();
                this.handleProviderRegistration(element, ColumnModel.class, path3, position);
            }
            ++cnt;
        }
        for (Element element : env.getElementsAnnotatedWith(DebuggingView.DVSupport.Registration.class)) {
            reg = element.getAnnotation(DebuggingView.DVSupport.Registration.class);
            path = reg.path();
            int position = reg.position();
            this.handleProviderRegistration(element, DebuggingView.DVSupport.class, path, position);
            ++cnt;
        }
        return cnt == annotations.size();
    }

    private void handleProviderRegistration(Element e, Class providerClass, String path, int position) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        LayerBuilder lb = this.layer(new Element[]{e});
        String basename = className.replace('.', '-');
        LayerBuilder.File f = lb.file(path + "/" + basename + ".instance");
        f.stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", providerClass.getName()).stringvalue("instanceOf", providerClass.getName()).methodvalue("instanceCreate", "org.netbeans.modules.debugger.ui.registry." + providerClass.getSimpleName() + "ContextAware", "createService").position(position).write();
    }

    private void handleProviderRegistrationDisplayName(Element e, Class providerClass, String displayName, String path, int position) throws IllegalArgumentException, LayerGenerationException {
        String className = this.instantiableClassOrMethod(e);
        if (!this.isClassOf(e, providerClass)) {
            throw new IllegalArgumentException("Annotated element " + e + " is not an instance of " + providerClass);
        }
        path = path != null && path.length() > 0 ? "Debugger/" + path : "Debugger";
        LayerBuilder lb = this.layer(new Element[]{e});
        String basename = className.replace('.', '-');
        LayerBuilder.File f = lb.file(path + "/" + basename + ".instance");
        f.stringvalue(SERVICE_NAME, className).stringvalue("serviceClass", providerClass.getName()).stringvalue("instanceOf", providerClass.getName()).bundlevalue("displayName", displayName).methodvalue("instanceCreate", providerClass.getName() + "$ContextAware", "createService").position(position).write();
    }

    private boolean isClassOf(Element e, Class providerClass) {
        switch (e.getKind()) {
            case CLASS: {
                TypeElement te = (TypeElement)e;
                TypeMirror superType = te.getSuperclass();
                if (superType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)superType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
            case METHOD: {
                TypeMirror retType = ((ExecutableElement)e).getReturnType();
                if (retType.getKind().equals((Object)TypeKind.NONE)) {
                    return false;
                }
                e = ((DeclaredType)retType).asElement();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (clazz.equals(providerClass.getName())) {
                    return true;
                }
                return this.isClassOf(e, providerClass);
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }

    private String instantiableClassOrMethod(Element e) throws IllegalArgumentException, LayerGenerationException {
        switch (e.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", e);
                }
                boolean hasDefaultCtor = false;
                boolean hasContextCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    List<? extends VariableElement> parameters = constructor.getParameters();
                    if (parameters.isEmpty()) {
                        hasDefaultCtor = true;
                        break;
                    }
                    if (parameters.size() != 1) continue;
                    String type = parameters.get(0).asType().toString();
                    if (!ContextProvider.class.getName().equals(type)) continue;
                    hasContextCtor = true;
                    break;
                }
                if (!hasDefaultCtor && !hasContextCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor or constuctor taking " + ContextProvider.class.getName() + " as a parameter.", e);
                }
                return clazz;
            }
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                String methodName = ee.getSimpleName().toString();
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)ee.getEnclosingElement()).toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(ee + " must be static", e);
                }
                if (ee.getParameters().size() > 0) {
                    throw new LayerGenerationException(ee + " must not have any parameters", e);
                }
                return clazz + "." + methodName + "()";
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
    }
}

