/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Vector;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.ui.models.BreakpointGroup;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakListeners;

public class BreakpointsTreeModel
implements TreeModel {
    private static Logger logger = Logger.getLogger(BreakpointsTreeModel.class.getName());
    private Listener listener;
    private Vector listeners = new Vector();
    private Properties bpProperties = Properties.getDefault().getProperties("Breakpoints");
    private PropertyChangeListener pchl;
    private PropertyChangeListener oppchl;
    private Reference<Object[]> lastGroupsAndBreakpoints = new SoftReference<Object>(null);
    private final Object lastGroupsAndBreakpointsLock = new Object();

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Object[] groupsAndBreakpoints;
            boolean openProjectsOnly;
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (this.pchl == null) {
                this.pchl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        BreakpointsTreeModel.this.fireTreeChanged();
                    }
                };
                this.bpProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pchl, (Object)this.bpProperties));
            }
            if (openProjectsOnly = this.bpProperties.getBoolean("fromOpenProjects", true)) {
                this.oppchl = WeakListeners.propertyChange((PropertyChangeListener)this.pchl, (Object)OpenProjects.getDefault());
                OpenProjects.getDefault().addPropertyChangeListener(this.oppchl);
            } else {
                if (this.oppchl != null) {
                    OpenProjects.getDefault().removePropertyChangeListener(this.oppchl);
                }
                this.oppchl = null;
            }
            Object object = this.lastGroupsAndBreakpointsLock;
            synchronized (object) {
                groupsAndBreakpoints = this.lastGroupsAndBreakpoints.get();
            }
            if (groupsAndBreakpoints == null) {
                groupsAndBreakpoints = BreakpointGroup.createGroups(this.bpProperties);
                object = this.lastGroupsAndBreakpointsLock;
                synchronized (object) {
                    this.lastGroupsAndBreakpoints = new SoftReference<Object[]>(groupsAndBreakpoints);
                }
            }
            if (to == 0 || to >= groupsAndBreakpoints.length && from == 0) {
                return groupsAndBreakpoints;
            }
            int n = groupsAndBreakpoints.length;
            to = Math.min(n, to);
            from = Math.min(n, from);
            Object[] r = new Object[to - from];
            System.arraycopy(groupsAndBreakpoints, from, r, 0, r.length);
            return r;
        }
        if (parent instanceof BreakpointGroup) {
            return ((BreakpointGroup)parent).getGroupsAndBreakpoints();
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        if (node instanceof BreakpointGroup) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Breakpoint) {
            return true;
        }
        if (node instanceof BreakpointGroup) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Object object = this.lastGroupsAndBreakpointsLock;
        synchronized (object) {
            this.lastGroupsAndBreakpoints = new SoftReference<Object>(null);
        }
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTreeChanged(ModelEvent me) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(me);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(BreakpointsTreeModel tm) {
            this.model = new WeakReference<BreakpointsTreeModel>(tm);
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private BreakpointsTreeModel getModel() {
            BreakpointsTreeModel m = (BreakpointsTreeModel)this.model.get();
            if (m == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                int k = bs.length;
                for (int i = 0; i < k; ++i) {
                    bs[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return m;
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (!(evt.getSource() instanceof Breakpoint)) {
                return;
            }
            if (evt.getPropertyName() == "groupName") {
                m.fireTreeChanged();
            } else {
                Breakpoint bp;
                String groupName;
                m.fireTreeChanged((ModelEvent)new ModelEvent.NodeChanged((Object)m, evt.getSource()));
                if (evt.getPropertyName() == "enabled" && (groupName = (bp = (Breakpoint)evt.getSource()).getGroupName()) != null) {
                    m.fireTreeChanged((ModelEvent)new ModelEvent.NodeChanged((Object)m, (Object)groupName));
                }
            }
        }
    }
}

