/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.swing.Action;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.action.ConnectAction;
import org.netbeans.modules.db.explorer.metadata.MetadataModelManager;
import org.netbeans.modules.db.explorer.node.Bundle;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModels;
import org.netbeans.modules.db.util.PropertiesEditor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class ConnectionNode
extends BaseNode {
    private static final String CONNECTEDICONBASE = "org/netbeans/modules/db/resources/connection.gif";
    private static final String DISCONNECTEDICONBASE = "org/netbeans/modules/db/resources/connectionDisconnected.gif";
    private static final String CONNECTIONPROPERTIES = "ConnectionProperties";
    private static final String CONNECTIONPROPERTIESDESC = "ConnectionPropertiesDescription";
    private static final String SEPARATESYSTEMTABLES = "SeparateSystemTables";
    private static final String SEPARATESYSTEMTABLESDESC = "SeparateSystemTablesDescription";
    private static final String USESCROLLABLECURSORS = "UseScrollableCursors";
    private static final String USESCROLLABLECURSORSDESC = "UseScrollableCursorsDescription";
    private static final String FOLDER = "Connection";
    private static final String NBDRIVER = "NBDriver";
    private static final String NBDRIVERDESC = "NBDriverDescription";
    private static final RequestProcessor RP = new RequestProcessor(ConnectionNode.class.getName());
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private PropertyChangeListener propertyChangeListener;

    public static ConnectionNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        ConnectionNode node = new ConnectionNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private ConnectionNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        lookup.add(DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this.connection));
    }

    @Override
    protected void initialize() {
        this.connection.addPropertyChangeListener(new PropertyChangeListener(){
            private final RequestProcessor.Task UPDATE = ConnectionNode.access$100().create(new Runnable(){

                @Override
                public void run() {
                    ConnectionNode.this.updateModel();
                }
            });

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.UPDATE.schedule(10);
            }
        });
        this.updateModel();
    }

    @Override
    public void setPropertyValue(Node.Property nps, Object val) {
        boolean refreshNode = true;
        if (nps.getName().equals("User")) {
            this.connection.setUser(val.toString());
        } else if (nps.getName().equals("RememberPassword")) {
            this.connection.setRememberPassword((Boolean)val);
            refreshNode = false;
        } else if (nps.getName().equals("DatabaseURL")) {
            this.connection.setDatabase(val.toString());
        } else if (nps.getName().equals(NBDRIVER)) {
            this.connection.setDriverName(val.toString());
        } else if (nps.getName().equals("DriverURL")) {
            this.connection.setDriver(val.toString());
        } else if (nps.getName().equals("Schema")) {
            this.connection.setSchema(val.toString());
            if (this.connection.getDefaultSchema() != null) {
                try {
                    this.connection.setDefaultSchema(val.toString());
                }
                catch (Exception ex) {}
            }
        } else if (nps.getName().equals("DefaultSchema")) {
            this.connection.setSchema(val.toString());
        } else if (nps.getName().equals("DisplayName")) {
            this.setDisplayName(val.toString());
            refreshNode = false;
        } else if (nps.getName().equals(CONNECTIONPROPERTIES)) {
            this.connection.setConnectionProperties((Properties)val);
        } else if (nps.getName().equals(SEPARATESYSTEMTABLES) && val instanceof Boolean) {
            this.connection.setSeparateSystemTables((Boolean)val);
            refreshNode = false;
        } else if (nps.getName().equals(USESCROLLABLECURSORS) && val instanceof Boolean) {
            this.connection.setUseScrollableCursors((Boolean)val);
            refreshNode = false;
        }
        super.setPropertyValue(nps, val);
        if (refreshNode) {
            this.refresh();
        }
    }

    private void updateLocalProperties() {
        try {
            this.clearProperties();
            boolean connected = !this.connection.getConnector().isDisconnected();
            this.addProperty("DisplayName", "DisplayNameDescription", String.class, true, this.connection.getDisplayName());
            this.addProperty("DatabaseURL", "DatabaseURLDescription", String.class, !connected, this.connection.getDatabase());
            this.addProperty(NBDRIVER, NBDRIVERDESC, String.class, !connected, this.connection.getDriverName());
            this.addProperty("DriverURL", "DriverURLDescription", String.class, !connected, this.connection.getDriver());
            this.addProperty("Schema", "SchemaDescription", String.class, !connected, this.connection.getSchema());
            this.addProperty("User", "UserDescription", String.class, !connected, this.connection.getUser());
            this.addProperty("RememberPassword", "RememberPasswordDescription", Boolean.class, !connected, this.connection.rememberPassword());
            this.addProperty(SEPARATESYSTEMTABLES, SEPARATESYSTEMTABLESDESC, Boolean.class, true, this.connection.isSeparateSystemTables());
            this.addProperty(USESCROLLABLECURSORS, USESCROLLABLECURSORSDESC, Boolean.class, true, this.connection.isUseScrollableCursors());
            this.addProperty(CONNECTIONPROPERTIES, CONNECTIONPROPERTIESDESC, Properties.class, !connected, this.connection.getConnectionProperties());
            Node.Property ps = this.getSheet().get("properties").get(CONNECTIONPROPERTIES);
            ps.setValue("canEditAsText", (Object)Boolean.FALSE);
            ps.setValue("NodePropertySupport.customEditor", PropertiesEditor.class);
            if (connected) {
                Specification spec = this.connection.getConnector().getDatabaseSpecification();
                DatabaseMetaData md = spec.getMetaData();
                this.addProperty("databaseProductName", null, String.class, false, md.getDatabaseProductName());
                this.addProperty("databaseProductVersion", null, String.class, false, md.getDatabaseProductVersion());
                this.addProperty("readOnly", null, Boolean.class, false, md.isReadOnly());
                this.addProperty("mixedCaseIdentifiers", null, Boolean.class, false, md.supportsMixedCaseIdentifiers());
                this.addProperty("mixedCaseQuotedIdentifiers", null, Boolean.class, false, md.supportsMixedCaseQuotedIdentifiers());
                this.addProperty("alterTableWithAddColumn", null, Boolean.class, false, md.supportsAlterTableWithAddColumn());
                this.addProperty("alterTableWithDropColumn", null, Boolean.class, false, md.supportsAlterTableWithDropColumn());
                this.addProperty("convert", null, Boolean.class, false, md.supportsConvert());
                this.addProperty("tableCorrelationNames", null, Boolean.class, false, md.supportsTableCorrelationNames());
                this.addProperty("tableCorrelationNames", null, Boolean.class, false, md.supportsDifferentTableCorrelationNames());
                this.addProperty("expressionsInOrderBy", null, Boolean.class, false, md.supportsExpressionsInOrderBy());
                this.addProperty("orderByUnrelated", null, Boolean.class, false, md.supportsOrderByUnrelated());
                this.addProperty("groupBy", null, Boolean.class, false, md.supportsGroupBy());
                this.addProperty("groupByUnrelated", null, Boolean.class, false, md.supportsGroupByUnrelated());
                this.addProperty("groupByBeyondSelect", null, Boolean.class, false, md.supportsGroupByBeyondSelect());
                this.addProperty("likeEscapeClause", null, Boolean.class, false, md.supportsLikeEscapeClause());
                this.addProperty("multipleResultSets", null, Boolean.class, false, md.supportsMultipleResultSets());
                this.addProperty("multipleTransactions", null, Boolean.class, false, md.supportsMultipleTransactions());
                this.addProperty("nonNullableColumns", null, Boolean.class, false, md.supportsNonNullableColumns());
                this.addProperty("minimumSQLGrammar", null, Boolean.class, false, md.supportsMinimumSQLGrammar());
                this.addProperty("coreSQLGrammar", null, Boolean.class, false, md.supportsCoreSQLGrammar());
                this.addProperty("extendedSQLGrammar", null, Boolean.class, false, md.supportsExtendedSQLGrammar());
                this.addProperty("ANSI92EntryLevelSQL", null, Boolean.class, false, md.supportsANSI92EntryLevelSQL());
                this.addProperty("ANSI92IntermediateSQL", null, Boolean.class, false, md.supportsANSI92IntermediateSQL());
                this.addProperty("ANSI92FullSQL", null, Boolean.class, false, md.supportsANSI92FullSQL());
                this.addProperty("IntegrityEnhancementFacility", null, Boolean.class, false, md.supportsIntegrityEnhancementFacility());
                this.addProperty("outerJoins", null, Boolean.class, false, md.supportsOuterJoins());
                this.addProperty("fullOuterJoins", null, Boolean.class, false, md.supportsFullOuterJoins());
                this.addProperty("limitedOuterJoins", null, Boolean.class, false, md.supportsLimitedOuterJoins());
                this.addProperty("schemasInDataManipulation", null, Boolean.class, false, md.supportsSchemasInDataManipulation());
                this.addProperty("schemasInProcedureCalls", null, Boolean.class, false, md.supportsSchemasInProcedureCalls());
                this.addProperty("schemasInTableDefinitions", null, Boolean.class, false, md.supportsSchemasInTableDefinitions());
                this.addProperty("schemasInIndexDefinitions", null, Boolean.class, false, md.supportsSchemasInIndexDefinitions());
                this.addProperty("schemasInPrivilegeDefinitions", null, Boolean.class, false, md.supportsSchemasInPrivilegeDefinitions());
                this.addProperty("catalogsInDataManipulation", null, Boolean.class, false, md.supportsCatalogsInDataManipulation());
                this.addProperty("catalogsInProcedureCalls", null, Boolean.class, false, md.supportsCatalogsInProcedureCalls());
                this.addProperty("catalogsInTableDefinitions", null, Boolean.class, false, md.supportsCatalogsInTableDefinitions());
                this.addProperty("catalogsInIndexDefinitions", null, Boolean.class, false, md.supportsCatalogsInIndexDefinitions());
                this.addProperty("catalogsInPrivilegeDefinitions", null, Boolean.class, false, md.supportsCatalogsInPrivilegeDefinitions());
                this.addProperty("positionedDelete", null, Boolean.class, false, md.supportsPositionedDelete());
                this.addProperty("positionedUpdate", null, Boolean.class, false, md.supportsPositionedUpdate());
                this.addProperty("selectForUpdate", null, Boolean.class, false, md.supportsSelectForUpdate());
                this.addProperty("storedProcedures", null, Boolean.class, false, md.supportsStoredProcedures());
                this.addProperty("subqueriesInComparisons", null, Boolean.class, false, md.supportsSubqueriesInComparisons());
                this.addProperty("subqueriesInExists", null, Boolean.class, false, md.supportsSubqueriesInExists());
                this.addProperty("subqueriesInIns", null, Boolean.class, false, md.supportsSubqueriesInIns());
                this.addProperty("subqueriesInQuantifieds", null, Boolean.class, false, md.supportsSubqueriesInQuantifieds());
                this.addProperty("correlatedSubqueries", null, Boolean.class, false, md.supportsCorrelatedSubqueries());
                this.addProperty("union", null, Boolean.class, false, md.supportsUnion());
                this.addProperty("unionAll", null, Boolean.class, false, md.supportsUnionAll());
                this.addProperty("openCursorsAcrossCommit", null, Boolean.class, false, md.supportsOpenCursorsAcrossCommit());
                this.addProperty("openCursorsAcrossRollback", null, Boolean.class, false, md.supportsOpenCursorsAcrossRollback());
                this.addProperty("openStatementsAcrossCommit", null, Boolean.class, false, md.supportsOpenStatementsAcrossCommit());
                this.addProperty("openStatementsAcrossRollback", null, Boolean.class, false, md.supportsOpenStatementsAcrossRollback());
                this.addProperty("transactions", null, Boolean.class, false, md.supportsTransactions());
                this.addProperty("dataDefinitionAndDataManipulationTransactions", null, Boolean.class, false, md.supportsDataDefinitionAndDataManipulationTransactions());
                this.addProperty("dataManipulationTransactionsOnly", null, Boolean.class, false, md.supportsDataManipulationTransactionsOnly());
                this.addProperty("batchUpdates", null, Boolean.class, false, md.supportsBatchUpdates());
                this.addProperty("catalogAtStart", null, Boolean.class, false, md.isCatalogAtStart());
                this.addProperty("columnAliasing", null, Boolean.class, false, md.supportsColumnAliasing());
                this.addProperty("dataDefinitionCausesTransactionCommit", null, Boolean.class, false, md.dataDefinitionCausesTransactionCommit());
                this.addProperty("dataDefinitionIgnoredInTransactions", null, Boolean.class, false, md.dataDefinitionIgnoredInTransactions());
                this.addProperty("differentTableCorrelationNames", null, Boolean.class, false, md.supportsDifferentTableCorrelationNames());
                this.addProperty("localFiles", null, Boolean.class, false, md.usesLocalFiles());
                this.addProperty("localFilePerTable", null, Boolean.class, false, md.usesLocalFilePerTable());
                this.addProperty("maxRowSizeIncludeBlobs", null, Boolean.class, false, md.doesMaxRowSizeIncludeBlobs());
                this.addProperty("nullPlusNonNullIsNull", null, Boolean.class, false, md.nullPlusNonNullIsNull());
                this.addProperty("proceduresAreCallable", null, Boolean.class, false, md.allProceduresAreCallable());
                this.addProperty("tablesAreSelectable", null, Boolean.class, false, md.allTablesAreSelectable());
                this.addProperty("maxBinaryLiteralLength", null, Integer.class, false, md.getMaxBinaryLiteralLength());
                this.addProperty("maxCharLiteralLength", null, Integer.class, false, md.getMaxCharLiteralLength());
                this.addProperty("maxColumnNameLength", null, Integer.class, false, md.getMaxColumnNameLength());
                this.addProperty("maxColumnsInGroupBy", null, Integer.class, false, md.getMaxColumnsInGroupBy());
                this.addProperty("maxColumnsInIndex", null, Integer.class, false, md.getMaxColumnsInIndex());
                this.addProperty("maxColumnsInOrderBy", null, Integer.class, false, md.getMaxColumnsInOrderBy());
                this.addProperty("maxColumnsInSelect", null, Integer.class, false, md.getMaxColumnsInSelect());
                this.addProperty("maxColumnsInTable", null, Integer.class, false, md.getMaxColumnsInTable());
                this.addProperty("maxConnections", null, Integer.class, false, md.getMaxConnections());
                this.addProperty("maxCursorNameLength", null, Integer.class, false, md.getMaxCursorNameLength());
                this.addProperty("maxIndexLength", null, Integer.class, false, md.getMaxIndexLength());
                this.addProperty("maxSchemaNameLength", null, Integer.class, false, md.getMaxSchemaNameLength());
                this.addProperty("maxProcedureNameLength", null, Integer.class, false, md.getMaxProcedureNameLength());
                this.addProperty("maxCatalogNameLength", null, Integer.class, false, md.getMaxCatalogNameLength());
                this.addProperty("maxRowSize", null, Integer.class, false, md.getMaxRowSize());
                this.addProperty("maxStatementLength", null, Integer.class, false, md.getMaxStatementLength());
                this.addProperty("maxStatements", null, Integer.class, false, md.getMaxStatements());
                this.addProperty("maxTableNameLength", null, Integer.class, false, md.getMaxTableNameLength());
                this.addProperty("maxTablesInSelect", null, Integer.class, false, md.getMaxTablesInSelect());
                this.addProperty("maxUserNameLength", null, Integer.class, false, md.getMaxUserNameLength());
                this.addProperty("defaultTransactionIsolation", null, Integer.class, false, md.getDefaultTransactionIsolation());
                this.addProperty("driverName", null, String.class, false, md.getDriverName());
                this.addProperty("driverVersion", null, String.class, false, md.getDriverVersion());
                this.addProperty("driverMajorVersion", null, Integer.class, false, md.getDriverMajorVersion());
                this.addProperty("driverMinorVersion", null, Integer.class, false, md.getDriverMinorVersion());
                this.addProperty("identifierQuoteString", null, String.class, false, md.getIdentifierQuoteString());
                this.addProperty("SQLKeywords", null, String.class, false, md.getSQLKeywords());
                this.addProperty("numericFunctions", null, String.class, false, md.getNumericFunctions());
                this.addProperty("stringFunctions", null, String.class, false, md.getStringFunctions());
                this.addProperty("systemFunctions", null, String.class, false, md.getSystemFunctions());
                this.addProperty("timeDateFunctions", null, String.class, false, md.getTimeDateFunctions());
                this.addProperty("searchStringEscape", null, String.class, false, md.getSearchStringEscape());
                this.addProperty("extraNameCharacters", null, String.class, false, md.getExtraNameCharacters());
                this.addProperty("schemaTerm", null, String.class, false, md.getSchemaTerm());
                this.addProperty("procedureTerm", null, String.class, false, md.getProcedureTerm());
                this.addProperty("catalogTerm", null, String.class, false, md.getCatalogTerm());
                this.addProperty("catalogSeparator", null, String.class, false, md.getCatalogSeparator());
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    private synchronized void updateModel() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                boolean connected;
                boolean bl = connected = !ConnectionNode.this.connection.getConnector().isDisconnected();
                if (connected) {
                    MetadataModel model = MetadataModels.createModel((Connection)ConnectionNode.this.connection.getConnection(), (String)ConnectionNode.this.connection.getSchema());
                    ConnectionNode.this.connection.setMetadataModel(model);
                    MetadataModelManager.update(ConnectionNode.this.connection.getDatabaseConnection(), model);
                    ConnectionNode.this.refresh();
                } else {
                    ConnectionNode.this.connection.setMetadataModel(null);
                    ConnectionNode.this.getNodeRegistry().removeAllNodes();
                    ConnectionNode.this.refresh();
                }
                ConnectionNode.this.updateLocalProperties();
            }
        });
    }

    @Override
    public boolean canDestroy() {
        boolean result = true;
        Connection conn = this.connection.getJDBCConnection();
        if (conn != null) {
            result = !DatabaseConnection.isVitalConnection(conn, this.connection);
        }
        return result;
    }

    @Override
    public void destroy() {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Confirm_Connection_Delete(this.connection.getName()), Bundle.MSG_Confirm_Connection_Delete_Title(), 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (!NotifyDescriptor.OK_OPTION.equals(result)) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionList.getDefault().remove(ConnectionNode.this.connection);
                }
                catch (DatabaseException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.connection.getDisplayName();
    }

    public void setName(String name) {
        String old = this.getName();
        this.connection.setDisplayName(name);
        this.fireNameChange(old, name);
    }

    public String getDisplayName() {
        return this.connection.getDisplayName();
    }

    public void setDisplayName(String name) {
        String old = this.getDisplayName();
        this.connection.setDisplayName(name);
        this.fireDisplayNameChange(old, name);
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    public String getIconBase() {
        boolean disconnected;
        boolean bl = disconnected = !DatabaseConnection.isVitalConnection(this.connection.getConnection(), null);
        if (disconnected) {
            return DISCONNECTEDICONBASE;
        }
        return CONNECTEDICONBASE;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public Transferable clipboardCopy() throws IOException {
        ExTransferable result = ExTransferable.create((Transferable)super.clipboardCopy());
        result.put(new ExTransferable.Single(DatabaseMetaDataTransfer.CONNECTION_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createConnectionData(ConnectionNode.this.connection.getDatabaseConnection(), ConnectionNode.this.connection.findJDBCDriver());
            }
        });
        return result;
    }

    public String getShortDescription() {
        if (!this.getName().equals(this.getDisplayName())) {
            return this.getName();
        }
        return NbBundle.getMessage(ConnectionNode.class, (String)"ND_Connection");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public Action getPreferredAction() {
        boolean disconnected;
        boolean bl = disconnected = !DatabaseConnection.isVitalConnection(this.connection.getConnection(), null);
        if (disconnected) {
            return SystemAction.get(ConnectAction.class);
        }
        return null;
    }

    static /* synthetic */ RequestProcessor access$100() {
        return RP;
    }
}

