/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

final class TestsuiteNodeChildren
extends ChildFactory<Testcase> {
    private Report report;
    private int filterMask;

    TestsuiteNodeChildren(Report report, int filterMask) {
        this.report = report;
        this.filterMask = filterMask;
    }

    protected boolean createKeys(List<Testcase> toPopulate) {
        if (this.report != null) {
            for (Testcase testcase : this.report.getTests()) {
                if (testcase.getStatus().isMaskApplied(this.filterMask)) continue;
                toPopulate.add(testcase);
            }
        }
        return true;
    }

    protected Node createNodeForKey(Testcase testcase) {
        if (testcase.getStatus().isMaskApplied(this.filterMask)) {
            return null;
        }
        return testcase.getSession().getNodeFactory().createTestMethodNode(testcase, this.report.getProject());
    }

    void setReport(Report report) {
        this.report = report;
    }

    void notifyTestSuiteFinished() {
        this.refresh(false);
    }

    void setFilterMask(int filterMask) {
        int diff = this.filterMask ^ filterMask;
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        if (this.report != null) {
            for (Testcase testcase : this.report.getTests()) {
                if (!testcase.getStatus().isMaskApplied(diff)) continue;
                this.refresh(false);
                break;
            }
        }
    }
}

