/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.testrunner.plugin.RootsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class TestCreatorProvider {
    public abstract boolean enable(Node[] var1);

    public abstract void createTests(Context var1);

    public static SourceGroup getSourceGroup(FileObject file, Project prj) {
        SourceGroup[] srcGrps;
        Sources src = ProjectUtils.getSources((Project)prj);
        String type = "";
        Collection providers = Lookup.getDefault().lookupAll(RootsProvider.class);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            RootsProvider provider = (RootsProvider)i$.next();
            type = provider.getSourceRootType();
        }
        for (SourceGroup srcGrp : srcGrps = src.getSourceGroups(type)) {
            FileObject rootFolder = srcGrp.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcGrp.contains(file)) continue;
            return srcGrp;
        }
        return null;
    }

    public static final class Context {
        private boolean singleClass;
        private String testClassName;
        private FileObject targetFolder;
        private Node[] activatedNodes;
        private boolean integrationTests;

        public Context(Node[] activatedNodes) {
            this.activatedNodes = activatedNodes;
        }

        public Node[] getActivatedNodes() {
            return this.activatedNodes;
        }

        public boolean isSingleClass() {
            return this.singleClass;
        }

        public void setSingleClass(boolean singleClass) {
            this.singleClass = singleClass;
        }

        public FileObject getTargetFolder() {
            return this.targetFolder;
        }

        public void setTargetFolder(FileObject targetFolder) {
            this.targetFolder = targetFolder;
        }

        public String getTestClassName() {
            return this.testClassName;
        }

        public void setTestClassName(String testClassName) {
            this.testClassName = testClassName;
        }

        public boolean isIntegrationTests() {
            return this.integrationTests;
        }

        public void setIntegrationTests(boolean integrationTests) {
            this.integrationTests = integrationTests;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Registration {
        public String displayName();
    }
}

