/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.CommonTestsCfgOfCreate;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public final class TestCreatorPanelDisplayer {
    private static final TestCreatorPanelDisplayer INSTANCE = new TestCreatorPanelDisplayer();
    private static final RequestProcessor RP = new RequestProcessor(TestCreatorPanelDisplayer.class);

    private TestCreatorPanelDisplayer() {
    }

    public static TestCreatorPanelDisplayer getDefault() {
        return INSTANCE;
    }

    public void displayPanel(Node[] activatedNodes, Object location, String testingFramework) {
        DataObject[] modified = DataObject.getRegistry().getModified();
        CommonTestsCfgOfCreate cfg = new CommonTestsCfgOfCreate(activatedNodes);
        boolean isJ2MEProject = this.isJ2MEProject(activatedNodes);
        cfg.createCfgPanel(modified.length != 0, isJ2MEProject);
        ArrayList<String> testingFrameworks = new ArrayList<String>();
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        if (!isJ2MEProject) {
            for (Lookup.Item provider : providers) {
                testingFrameworks.add(provider.getDisplayName());
            }
        }
        cfg.addTestingFrameworks(testingFrameworks);
        cfg.setPreselectedLocation(location);
        cfg.setPreselectedFramework(testingFramework);
        if (!cfg.configure()) {
            return;
        }
        this.saveAll(modified);
        String selected = cfg.getSelectedTestingFramework();
        for (final Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals(selected)) continue;
            final TestCreatorProvider.Context context = new TestCreatorProvider.Context(activatedNodes);
            context.setSingleClass(cfg.isSingleClass());
            context.setTargetFolder(cfg.getTargetFolder());
            context.setTestClassName(cfg.getTestClassName());
            context.setIntegrationTests(cfg.isIntegrationTests());
            final Collection<? extends SourceGroup> createdSourceRoots = cfg.getCreatedSourceRoots();
            RP.execute(new Runnable(){

                @Override
                public void run() {
                    for (SourceGroup sg : createdSourceRoots) {
                        IndexingManager.getDefault().refreshIndexAndWait(sg.getRootFolder().toURL(), null);
                    }
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            ((TestCreatorProvider)provider.getInstance()).createTests(context);
                        }
                    });
                }
            });
            cfg = null;
            break;
        }
    }

    private boolean isJ2MEProject(Node[] activatedNodes) {
        Project p;
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dataObject != null && (p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile())) != null) {
            return p.getLookup().lookup(TestCreatorPanelDisplayerProjectServiceProvider.class) != null;
        }
        return false;
    }

    private void saveAll(DataObject[] dataObjects) {
        for (DataObject dataObject : dataObjects) {
            SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
            if (saveCookie == null) continue;
            try {
                saveCookie.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class TestCreatorPanelDisplayerProjectServiceProvider {
        public TestCreatorPanelDisplayerProjectServiceProvider(Project p) {
        }
    }
}

