/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.gsf.testrunner.api.StatisticsPanel;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResultWindow
extends TopComponent {
    private static final String ID = "gsf-testrunner-results";
    private static WeakReference<ResultWindow> instance = null;
    private Map<String, JSplitPane> viewMap = new HashMap<String, JSplitPane>();
    private Map<String, InputOutput> ioMap = new HashMap<String, InputOutput>();
    private static JTabbedPane tabPane;
    private JPopupMenu pop;
    private PopupListener popL;
    private CloseListener closeL;
    private boolean activated;
    private JComponent outputComp;
    private JComponent outputTab;
    private IOContainer ioContainer;

    public static ResultWindow getInstance() {
        final ResultWindow[] result = new ResultWindow[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = ResultWindow.getResultWindow();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            result[0] = ResultWindow.getResultWindow();
        }
        return result[0];
    }

    private static synchronized ResultWindow getResultWindow() {
        ResultWindow result = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (result == null) {
            result = ResultWindow.getDefault();
        }
        return result;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow window;
        ResultWindow resultWindow = window = instance != null ? (ResultWindow)((Object)instance.get()) : null;
        if (window == null) {
            window = new ResultWindow();
            window.initActions();
            instance = new WeakReference<ResultWindow>(window);
        }
        return window;
    }

    private void initActions() {
        ActionMap actions = this.getActionMap();
        actions.put("jumpNext", new PrevNextFailure(true));
        actions.put("jumpPrev", new PrevNextFailure(false));
    }

    public ResultWindow() {
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage(ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.popL = new PopupListener();
        this.closeL = new CloseListener();
        tabPane = TabbedPaneFactory.createCloseButtonTabbedPane();
        tabPane.setMinimumSize(new Dimension(0, 0));
        tabPane.addMouseListener((MouseListener)((Object)this.popL));
        tabPane.addPropertyChangeListener(this.closeL);
        this.add(tabPane);
    }

    public void addDisplayComponent(JSplitPane displayComp, InputOutput io) {
        int frequency;
        assert (EventQueue.isDispatchThread());
        String key = displayComp.getToolTipText();
        boolean alwaysOpenNewTab = NbPreferences.forModule(StatisticsPanel.class).getBoolean("alwaysOpenNewTab", false);
        if (alwaysOpenNewTab && (frequency = this.getFrequency(this.viewMap.keySet(), key)) > 0) {
            key = key.concat(" #").concat(Integer.toString(frequency));
            displayComp.setToolTipText(key);
        }
        JSplitPane prevComp = this.viewMap.put(key, displayComp);
        InputOutput prevIo = this.ioMap.put(key, io);
        if (alwaysOpenNewTab || prevComp == null) {
            this.addView(displayComp);
        } else {
            this.replaceView(prevComp, displayComp);
            if (prevIo != null) {
                prevIo.closeInputOutput();
            }
        }
        this.revalidate();
    }

    private int getFrequency(Set<String> c, String tooltip) {
        int result = 0;
        int max = 0;
        for (String key : c) {
            if (!key.startsWith(tooltip)) continue;
            ++result;
            int index = key.indexOf(" #");
            if (index == -1) continue;
            max = Math.max(max, Integer.parseInt(key.substring(index + 2)));
        }
        return result == 0 ? 0 : Math.max(max + 1, result);
    }

    public void updateOptionStatus(String property, boolean selected) {
        NbPreferences.forModule(StatisticsPanel.class).putBoolean(property, selected);
        for (int i = 0; i < tabPane.getTabCount(); ++i) {
            StatisticsPanel sp = (StatisticsPanel)((JSplitPane)tabPane.getComponentAt(i)).getLeftComponent();
            sp.updateOptionStatus(property, selected);
        }
    }

    private void addView(JSplitPane view) {
        assert (EventQueue.isDispatchThread());
        view.setMinimumSize(new Dimension(0, 0));
        tabPane.addTab(view.getToolTipText(), view);
        tabPane.setSelectedComponent(view);
        tabPane.validate();
    }

    private void replaceView(JSplitPane oldView, JSplitPane newView) {
        for (int i = 0; i < tabPane.getTabCount(); ++i) {
            if (!oldView.equals(tabPane.getComponentAt(i))) continue;
            tabPane.setComponentAt(i, newView);
            tabPane.setSelectedComponent(newView);
            tabPane.validate();
            this.copyFilterMask(oldView, newView);
        }
    }

    private void copyFilterMask(JSplitPane oldView, JSplitPane newView) {
        StatisticsPanel oldSP = (StatisticsPanel)oldView.getLeftComponent();
        StatisticsPanel newSP = (StatisticsPanel)newView.getLeftComponent();
        newSP.copyFilterMask(oldSP);
    }

    public void promote() {
        assert (EventQueue.isDispatchThread());
        this.open();
        this.requestVisible();
    }

    public void setOrientation(int orientation) {
        for (JSplitPane view : this.viewMap.values()) {
            if (view.getOrientation() == orientation) continue;
            view.setOrientation(orientation);
        }
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }

    IOContainer getIOContainer() {
        if (this.ioContainer == null) {
            this.ioContainer = IOContainer.create((IOContainer.Provider)new IOContainerImpl());
        }
        return this.ioContainer;
    }

    void setOutputComp(JComponent comp) {
        this.outputComp = comp;
    }

    protected void componentActivated() {
        this.activated = true;
    }

    protected void componentDeactivated() {
        this.activated = false;
    }

    private static JSplitPane getCurrentResultView() {
        if (tabPane == null) {
            return null;
        }
        return (JSplitPane)tabPane.getSelectedComponent();
    }

    public boolean requestFocusInWindow() {
        JSplitPane view = ResultWindow.getCurrentResultView();
        if (view == null) {
            return super.requestFocusInWindow();
        }
        Component left = view.getLeftComponent();
        if (left == null) {
            return super.requestFocusInWindow();
        }
        return left.requestFocusInWindow();
    }

    private void closeAll(boolean butCurrent) {
        Component current = tabPane.getSelectedComponent();
        Component[] c = tabPane.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (butCurrent && c[i] == current || !(c[i] instanceof JSplitPane)) continue;
            this.removeView((JSplitPane)c[i]);
        }
    }

    protected void componentClosed() {
        this.closeAll(false);
        super.componentClosed();
    }

    private void removeView(JSplitPane view) {
        if (view == null && (view = (JSplitPane)tabPane.getSelectedComponent()) == null) {
            return;
        }
        tabPane.remove(view);
        this.viewMap.remove(view.getToolTipText());
        InputOutput io = this.ioMap.remove(view.getToolTipText());
        if (io != null) {
            io.closeInputOutput();
        }
        this.validate();
    }

    private static StatisticsPanel getStatisticsPanel() {
        JSplitPane view = ResultWindow.getCurrentResultView();
        if (view == null || !(view.getLeftComponent() instanceof StatisticsPanel)) {
            return null;
        }
        return (StatisticsPanel)view.getLeftComponent();
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ResultWindow.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultWindow.this.removeView(null);
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ResultWindow.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultWindow.this.closeAll(false);
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ResultWindow.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultWindow.this.closeAll(true);
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                ResultWindow.this.removeView((JSplitPane)evt.getNewValue());
            }
        }
    }

    private class IOContainerImpl
    implements IOContainer.Provider {
        private IOContainerImpl() {
        }

        public void remove(JComponent comp) {
            ResultWindow.this.outputTab = null;
            ResultWindow.this.outputComp.remove(comp);
        }

        public void select(JComponent comp) {
        }

        public JComponent getSelected() {
            return ResultWindow.this.outputTab;
        }

        public boolean isActivated() {
            return ResultWindow.this.activated;
        }

        public void open() {
        }

        public void requestActive() {
        }

        public void requestVisible() {
        }

        public void setIcon(JComponent comp, Icon icon) {
        }

        public void setTitle(JComponent comp, String name) {
        }

        public void setToolTipText(JComponent comp, String name) {
        }

        public void add(JComponent comp, IOContainer.CallBacks cb) {
            ResultWindow.this.outputTab = comp;
            ResultWindow.this.outputComp.add(comp);
        }

        public void setToolbarActions(JComponent comp, Action[] toolbarActions) {
        }

        public boolean isCloseable(JComponent comp) {
            return false;
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            ResultWindow.this.pop.show((Component)((Object)ResultWindow.this), e.getX(), e.getY());
        }
    }

    private final class PrevNextFailure
    extends AbstractAction {
        private final boolean next;

        public PrevNextFailure(boolean next) {
            this.next = next;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSplitPane view = ResultWindow.getCurrentResultView();
            if (view == null || !(view.getLeftComponent() instanceof StatisticsPanel)) {
                return;
            }
            StatisticsPanel statisticsPanel = (StatisticsPanel)view.getLeftComponent();
            if (this.next) {
                statisticsPanel.selectNextFailure();
            } else {
                statisticsPanel.selectPreviousFailure();
            }
        }
    }

    public static final class Rerun
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            StatisticsPanel statisticsPanel = ResultWindow.getStatisticsPanel();
            if (statisticsPanel != null) {
                statisticsPanel.rerun(false);
            }
        }
    }

    public static final class RerunFailed
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            StatisticsPanel statisticsPanel = ResultWindow.getStatisticsPanel();
            if (statisticsPanel != null) {
                statisticsPanel.rerun(true);
            }
        }
    }
}

