/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.netbeans.modules.gsf.testrunner.TestRunnerSettings;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.ResultPanelTree;
import org.netbeans.modules.gsf.testrunner.api.StatisticsPanel;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

final class ResultDisplayHandler {
    private static final Logger LOGGER = Logger.getLogger(ResultDisplayHandler.class.getName());
    private static ResourceBundle bundle = NbBundle.getBundle(ResultDisplayHandler.class);
    private ResultPanelTree treePanel;
    private JSplitPane displayComp;
    private JComponent outputComponent;
    private InputOutput inOut;
    private final TestSession session;
    private Lookup l;
    static final Object[] EMPTY_QUEUE = new Object[0];
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private String runningSuite;
    private final List<Report> reports = new ArrayList<Report>();
    private String message;
    boolean sessionFinished;
    private Map<String, Method> methodsMap = new HashMap<String, Method>();

    public ResultDisplayHandler(TestSession session) {
        this.session = session;
    }

    JComponent getOutputComponent() {
        if (this.outputComponent == null) {
            this.outputComponent = new JPanel(new BorderLayout());
            this.outputComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        }
        return this.outputComponent;
    }

    InputOutput createIO(IOContainer ioContainer) {
        this.inOut = IOProvider.getDefault().getIO("test-results", null, ioContainer);
        return this.inOut;
    }

    public TestSession getSession() {
        return this.session;
    }

    public JSplitPane getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private JSplitPane createDisplayComp() {
        TestRunnerSettings.DividerSettings dividerSettings = TestRunnerSettings.getDefault().getDividerSettings(null);
        return this.createDisplayComp(new StatisticsPanel(this), this.getOutputComponent(), dividerSettings.getOrientation(), dividerSettings.getLocation());
    }

    private JSplitPane createDisplayComp(Component left, Component right, int orientation, int location) {
        final JSplitPane splitPane = new JSplitPane(orientation, true, left, right);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerLocation(location);
        splitPane.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultPanelTree"));
        splitPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultPanelTree"));
        splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TestRunnerSettings.DividerSettings dividerSettings = new TestRunnerSettings.DividerSettings(splitPane.getOrientation(), splitPane.getDividerLocation());
                TestRunnerSettings.getDefault().setDividerSettings(dividerSettings);
            }
        });
        splitPane.addPropertyChangeListener("orientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TestRunnerSettings.DividerSettings dividerSettings = new TestRunnerSettings.DividerSettings(splitPane.getOrientation(), splitPane.getDividerLocation());
                TestRunnerSettings.getDefault().setDividerSettings(dividerSettings);
            }
        });
        splitPane.setToolTipText(this.session.getName());
        return splitPane;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    public void displayOutput(String text, boolean error) {
        if (this.inOut != null) {
            OutputWriter out = error ? this.inOut.getErr() : this.inOut.getOut();
            this.session.getOutputLineHandler().handleLine(out, text);
        } else {
            LOGGER.log(Level.WARNING, "Tried to display output before inOut was initialized. Output text: {0}", text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] passedQueue = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return passedQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySuiteRunning(String suiteName) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            assert (this.runningSuite == null);
            String string = suiteName = suiteName != null ? suiteName : TestSuite.ANONYMOUS_SUITE;
            if (this.treePanel == null) {
                this.runningSuite = suiteName;
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displaySuiteRunning", String.class), suiteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySuiteRunning(TestSuite suite) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            assert (this.runningSuite == null);
            TestSuite testSuite = suite = suite != null ? suite : TestSuite.ANONYMOUS_TEST_SUITE;
            if (this.treePanel == null) {
                this.runningSuite = suite.getName();
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displaySuiteRunning", TestSuite.class), suite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                if (!this.reports.contains(report)) {
                    this.reports.add(report);
                }
                this.runningSuite = null;
                return;
            }
            assert (this.runningSuite == null);
        }
        this.displayInDispatchThread(this.prepareMethod("displayReport", Report.class), report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayMessage(String msg) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = msg;
                return;
            }
        }
        this.displayInDispatchThread(this.prepareMethod("displayMsg", String.class), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayMessageSessionFinished(String msg) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = msg;
                return;
            }
            this.sessionFinished = true;
        }
        this.displayInDispatchThread(this.prepareMethod("displayMsgSessionFinished", String.class), msg);
    }

    private void displayInDispatchThread(final Method method, final Object param) {
        assert (method != null);
        final Method finalMethod = method;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Invoking: {0} with param: {1}", new Object[]{method.getName(), param});
                    }
                    finalMethod.invoke((Object)ResultDisplayHandler.this.treePanel, param);
                }
                catch (InvocationTargetException ex) {
                    ErrorManager.getDefault().notify(ex.getTargetException());
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                }
            }
        });
    }

    private synchronized Method prepareMethod(String methodName, Class paramType) {
        Method method = this.methodsMap.get(methodName + "_" + paramType.getName());
        if (method == null) {
            try {
                method = ResultPanelTree.class.getDeclaredMethod(methodName, paramType);
            }
            catch (Exception ex) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
            this.methodsMap.put(methodName + "_" + paramType.getName(), method);
        }
        return method;
    }

    synchronized void setTreePanel(ResultPanelTree treePanel) {
        assert (EventQueue.isDispatchThread());
        if (this.treePanel != null) {
            return;
        }
        this.treePanel = treePanel;
        if (this.message != null) {
            treePanel.displayMsg(this.message);
            this.message = null;
        }
        if (!this.reports.isEmpty()) {
            treePanel.displayReports(this.reports);
            this.reports.clear();
        }
        if (this.runningSuite != null) {
            treePanel.displaySuiteRunning(this.runningSuite != TestSuite.ANONYMOUS_SUITE ? this.runningSuite : null);
            this.runningSuite = null;
        }
        if (this.sessionFinished) {
            treePanel.displayMsgSessionFinished(this.message);
        }
    }

    void setLookup(Lookup l) {
        this.l = l;
    }

    Lookup getLookup() {
        return this.l;
    }
}

