/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public final class ClassNameTextField
extends JTextField {
    public static final int STATUS_VALID = 0;
    public static final int STATUS_EMPTY = 1;
    public static final int STATUS_INVALID = 2;
    public static final int STATUS_VALID_NOT_DEFAULT = 3;
    public static final int STATUS_VALID_END_NOT_TEST = 4;
    static final int STATUS_BEFORE_PART = 3;
    private TextListener documentListener;
    private int externalStatus = 0;
    private boolean externalStatusValid = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private String defaultText;

    public ClassNameTextField() {
        this(null);
        this.setupDocumentListener();
    }

    public ClassNameTextField(String text) {
        super(text == null ? "" : text);
        this.setupDocumentListener();
    }

    @Override
    protected Document createDefaultModel() {
        PlainDocument doc = (PlainDocument)super.createDefaultModel();
        doc.setDocumentFilter(new SpaceIgnoringDocumentFilter());
        return doc;
    }

    public void setDefaultText(String defaultText) {
        if (defaultText == null && this.defaultText == null || defaultText != null && defaultText.equals(this.defaultText)) {
            return;
        }
        this.defaultText = defaultText;
        if (defaultText != null || this.externalStatusValid && this.externalStatus == 3) {
            this.statusMaybeChanged();
        }
    }

    private void setupDocumentListener() {
        this.documentListener = new TextListener();
        this.getDocument().addDocumentListener(this.documentListener);
    }

    int determineStatus() {
        String text = this.getText();
        int status = 3;
        char[] chars = text.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (status) {
                case 3: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return 2;
                    }
                    status = 0;
                    continue block4;
                }
                case 0: {
                    if (c == '.') {
                        status = 3;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        status = 0;
                        continue block4;
                    }
                    return 2;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        return status;
    }

    public int getStatus() {
        if (!this.externalStatusValid) {
            this.updateExternalStatus();
        }
        return this.externalStatus;
    }

    private void updateExternalStatus() {
        assert (!this.externalStatusValid);
        int internalStatus = this.documentListener.status;
        switch (internalStatus) {
            case 0: {
                if (!this.getText().endsWith("Test") && !this.getText().endsWith("IT")) {
                    this.externalStatus = 4;
                    break;
                }
                if (this.defaultText != null && !this.defaultText.equals(this.getText())) {
                    this.externalStatus = 3;
                    break;
                }
                this.externalStatus = 0;
                break;
            }
            case 3: {
                this.externalStatus = this.getText().length() == 0 ? 1 : 2;
                break;
            }
            case 2: {
                this.externalStatus = 2;
                break;
            }
            default: {
                assert (false);
                this.externalStatus = 2;
            }
        }
        this.externalStatusValid = true;
    }

    public void setChangeListener(ChangeListener listener) {
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = listener;
    }

    private void statusMaybeChanged() {
        this.externalStatusValid = false;
        if (this.changeListener != null) {
            int prevExternalStatus = this.externalStatus;
            this.externalStatus = this.getStatus();
            if (this.externalStatus != prevExternalStatus) {
                this.changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    private static final class SpaceIgnoringDocumentFilter
    extends DocumentFilter {
        private SpaceIgnoringDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            String strToAdd = this.removeSpaces(string);
            if (strToAdd != null) {
                super.insertString(fb, offset, strToAdd, null);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String strToAdd = this.removeSpaces(text);
            if (strToAdd == null) {
                super.remove(fb, offset, length);
            } else {
                super.replace(fb, offset, length, strToAdd, null);
            }
        }

        private String removeSpaces(String str) {
            int length = str.length();
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return str.charAt(0) == ' ' ? null : str;
            }
            StringBuilder buf = null;
            for (int i = 0; i < length; ++i) {
                if (str.charAt(i) != ' ') {
                    if (buf == null) continue;
                    buf.append(str.charAt(i));
                    continue;
                }
                if (buf != null) continue;
                buf = new StringBuilder(str.length() - 1);
                buf.append(str.substring(0, i));
            }
            return buf == null ? str : (buf.length() != 0 ? buf.toString() : null);
        }
    }

    private final class TextListener
    implements DocumentListener {
        private int status;
        private int length;

        public TextListener() {
            this.status = ClassNameTextField.this.determineStatus();
            this.length = ClassNameTextField.this.getText().length();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.length = documentEvent.getDocument().getLength();
            int newStatus = ClassNameTextField.this.determineStatus();
            if (newStatus != this.status) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            int newStatus;
            boolean wasEmpty;
            boolean bl = wasEmpty = this.length == 0;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length) {
                this.length += documentEvent.getLength();
                newStatus = ClassNameTextField.this.determineStatus();
            } else {
                try {
                    char c = documentEvent.getDocument().getText(this.length++, 1).charAt(0);
                    switch (this.status) {
                        case 0: {
                            newStatus = c == '.' ? (newStatus = 3) : (Character.isJavaIdentifierPart(c) ? 0 : 2);
                            break;
                        }
                        case 3: {
                            newStatus = Character.isJavaIdentifierStart(c) ? 0 : 2;
                            break;
                        }
                        case 2: {
                            newStatus = ClassNameTextField.this.determineStatus();
                            break;
                        }
                        default: {
                            assert (false);
                            newStatus = ClassNameTextField.this.determineStatus();
                            break;
                        }
                    }
                }
                catch (BadLocationException ex) {
                    assert (false);
                    this.length = documentEvent.getDocument().getLength();
                    newStatus = ClassNameTextField.this.determineStatus();
                }
            }
            if (newStatus != this.status || wasEmpty) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            int newStatus;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length - 1) {
                this.length -= documentEvent.getLength();
                newStatus = ClassNameTextField.this.determineStatus();
            } else {
                --this.length;
                switch (this.status) {
                    case 0: {
                        try {
                            newStatus = this.length == 0 || documentEvent.getDocument().getText(this.length - 1, 1).charAt(0) == '.' ? 3 : 0;
                        }
                        catch (BadLocationException ex) {
                            assert (false);
                            newStatus = ClassNameTextField.this.determineStatus();
                            this.length = documentEvent.getDocument().getLength();
                        }
                        break;
                    }
                    case 3: {
                        newStatus = 0;
                        break;
                    }
                    case 2: {
                        newStatus = this.length == 0 ? 0 : ClassNameTextField.this.determineStatus();
                        break;
                    }
                    default: {
                        assert (false);
                        newStatus = ClassNameTextField.this.determineStatus();
                    }
                }
            }
            if (newStatus != this.status || this.length == 0) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }
    }
}

