/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;

public class PathUtils {
    private static final Logger log = Logger.getLogger(PathUtils.class.getName());

    private static List<String> getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        for (File r = f.getAbsoluteFile(); r != null; r = r.getParentFile()) {
            l.add(r.getName());
        }
        return l;
    }

    public static String getRelativePath(File file) {
        File userDirectory;
        if (file == null) {
            return "";
        }
        if (!file.exists() || !file.isFile()) {
            return file.getAbsolutePath();
        }
        String userDirectoryPath = System.getProperty("user.dir");
        try {
            userDirectory = new File(userDirectoryPath);
            if (!userDirectory.exists()) {
                throw new IOException("User directory '" + userDirectoryPath + "' doesn't exist");
            }
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Could not get user directory", ex);
            return file.getAbsolutePath();
        }
        return PathUtils.getRelativePath(userDirectory, file);
    }

    public static String getRelativePath(File directory, File file) {
        if (file == null) {
            return "";
        }
        if (!file.exists() || !file.isFile()) {
            return file.getAbsolutePath();
        }
        if (directory == null) {
            return file.getAbsolutePath();
        }
        String directoryPath = directory.getAbsolutePath();
        try {
            if (!directory.exists() || !directory.isDirectory()) {
                throw new IOException("Given directory '" + directory + "' doesn't exist or isn't a directory");
            }
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Could not get user directory", ex);
            return file.getAbsolutePath();
        }
        List<String> dirlist = PathUtils.getPathList(directory);
        List<String> filelist = PathUtils.getPathList(file);
        if (dirlist.isEmpty() || filelist.isEmpty()) {
            return file.getAbsolutePath();
        }
        String s = PathUtils.matchPathLists(dirlist, filelist);
        try {
            if (!directoryPath.endsWith(File.separator)) {
                directoryPath = directoryPath + File.separator;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                if (!new File(directoryPath + s).exists() || !new File(directoryPath + s).getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) {
                    log.log(Level.WARNING, "Relative path check failed, return absolute path. Relative path was: ''{0}'' (UserDir=''{1}''/ AbsolutePath=''{2}'')", new Object[]{s, directoryPath, file.getAbsolutePath()});
                    return file.getAbsolutePath();
                }
            } else if (!new File(directoryPath + s).exists() || !new File(directoryPath + s).getAbsolutePath().equals(file.getAbsolutePath())) {
                log.log(Level.WARNING, "Relative path check failed, return absolute path. Relative path was: ''{0}'' (UserDir=''{1}''/ AbsolutePath=''{2}'')", new Object[]{s, directoryPath, file.getAbsolutePath()});
                return file.getAbsolutePath();
            }
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "check relative path runs into", ex);
            return file.getAbsolutePath();
        }
        return s;
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }
}

