/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.openide.util.Utilities;

public class PackageUtils {
    private static final Logger log = Logger.getLogger(PackageUtils.class.getName());

    public static List<String> getClassNamesInPackage(String jarName, String packageName) {
        return PackageUtils.getFileNamesInPackage(jarName, packageName, "class");
    }

    private static List<String> getFileNamesInFolder(File rootFolder, File folder, String packageName, String fileExtension) {
        File[] subFiles;
        ArrayList<String> files = new ArrayList<String>();
        for (File f : subFiles = folder.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(PackageUtils.getFileNamesInFolder(rootFolder, f, packageName, fileExtension));
                continue;
            }
            String pName = StringUtils.removeStart((String)f.getParentFile().getAbsolutePath(), (String)(rootFolder.getAbsolutePath() + File.separator));
            String fileName = pName + File.separator + f.getName();
            if (!pName.equals(packageName) || !fileName.endsWith("." + fileExtension)) continue;
            String name = StringUtils.replace((String)fileName, (String)File.separator, (String)".");
            files.add(name);
        }
        return files;
    }

    public static List<String> getFileNamesInPackage(String jarName, String packageName, String fileExtension) {
        ArrayList<String> files = new ArrayList<String>();
        if (jarName != null) {
            files.addAll(PackageUtils.getFileNamesInPackageFromJar(jarName, packageName, fileExtension));
        } else {
            String[] classPaths;
            packageName = StringUtils.replace((String)packageName, (String)".", (String)File.separator);
            String classPath = System.getProperty("java.class.path");
            String pathSeparator = System.getProperty("path.separator");
            for (String cp : classPaths = StringUtils.split((String)classPath, (String)pathSeparator)) {
                if (cp.endsWith(".jar")) {
                    files.addAll(PackageUtils.getFileNamesInPackageFromJar(cp, packageName, fileExtension));
                    continue;
                }
                File cpRoot = new File(cp);
                if (!cpRoot.exists() || !cpRoot.isDirectory()) continue;
                files.addAll(PackageUtils.getFileNamesInFolder(cpRoot, cpRoot, packageName, fileExtension));
            }
        }
        return files;
    }

    public static List<String> getFileNamesInPackage(String packageName, String fileExtension) {
        try {
            return PackageUtils.getFileNamesInPackage(PackageUtils.getJarFileName(), packageName, fileExtension);
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getFileNamesInPackageFromJar(String jarName, String packageName, String fileExtension) {
        ArrayList<String> files = new ArrayList<String>();
        jarName = StringUtils.replace((String)jarName, (String)"%20", (String)" ");
        packageName = StringUtils.replace((String)packageName, (String)".", (String)"/");
        FileInputStream fis = null;
        JarInputStream jis = null;
        try {
            JarEntry jarEntry;
            fis = new FileInputStream(jarName);
            jis = new JarInputStream(fis);
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                String fileName;
                String jarEntryName = jarEntry.getName();
                String pName = StringUtils.removeEnd((String)jarEntryName, (String)(fileName = StringUtils.removeStart((String)jarEntryName, (String)packageName)));
                if (!pName.equals(packageName) || !jarEntryName.endsWith("." + fileExtension)) continue;
                String name = StringUtils.replace((String)jarEntryName, (String)"/", (String)".");
                files.add(name);
            }
        }
        catch (Throwable ex) {
            try {
                log.log(Level.SEVERE, "runs into", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jis);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)jis);
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)jis);
        IOUtils.closeQuietly((InputStream)fis);
        return files;
    }

    public static String getJarFileName() {
        try {
            String resourceName = "/" + PackageUtils.class.getName().replaceAll("\\.", "/") + ".class";
            String url = PackageUtils.class.getResource(resourceName).toString();
            String jarName = url.substring(url.indexOf("jar:file:") + 9, url.indexOf("!/"));
            return Utilities.toFile((URI)new URI("file://" + jarName)).getAbsolutePath();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

