/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.util;

import de.proveo.client.configuration.api.ConfigurationConstants;
import de.proveo.client.configuration.api.ConfigurationParametersProvider;
import de.proveo.client.configuration.api.parameter.type.Password;
import de.proveo.client.configuration.api.parameter.type.StateModel;
import de.proveo.client.configuration.util.PathUtils;
import java.awt.Color;
import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.openide.util.Lookup;

public class ConfigurationUtils {
    private static final Logger log = Logger.getLogger(ConfigurationUtils.class.getName());

    public static String colorToString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuilder strBuff = new StringBuilder();
        strBuff.append(color.getRed());
        strBuff.append(",");
        strBuff.append(color.getGreen());
        strBuff.append(",");
        strBuff.append(color.getBlue());
        return strBuff.toString();
    }

    public static <T> String getStoreableValue(Class<T> type, T value) {
        String ret;
        if (value == null) {
            ret = "";
        } else if (Color.class.isAssignableFrom(type)) {
            ret = ConfigurationUtils.colorToString((Color)value);
        } else if (Password.class.isAssignableFrom(type)) {
            ret = value instanceof Password ? ((Password)value).getPassword() : value.toString();
        } else if (value instanceof ConfigurationConstants.FunctionKey) {
            ret = ((ConfigurationConstants.FunctionKey)((Object)value)).toString();
        } else if (value instanceof ConfigurationConstants.Language) {
            ret = ((ConfigurationConstants.Language)((Object)value)).getLanguageCode();
        } else if (value instanceof ConfigurationConstants.MouseWheelAction) {
            ret = ((ConfigurationConstants.MouseWheelAction)((Object)value)).getName();
        } else if (value instanceof ConfigurationConstants.Protocol) {
            ret = ((ConfigurationConstants.Protocol)((Object)value)).toString();
        } else if (value instanceof ConfigurationConstants.SoundFile) {
            ret = ((ConfigurationConstants.SoundFile)value).getFilename();
        } else if (value instanceof ConfigurationConstants.AlertNotify) {
            ret = ((ConfigurationConstants.AlertNotify)((Object)value)).getName();
        } else if (value instanceof StateModel) {
            StateModel sm = (StateModel)value;
            ret = sm.getStateModelId() + "." + sm.getStateId();
        } else if (value instanceof File) {
            ret = PathUtils.getRelativePath((File)value);
        } else if (int[].class.isAssignableFrom(type) || Integer[].class.isAssignableFrom(type)) {
            int[] values = (int[])value;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                tmp.append(values[i]);
                if (i + 1 == values.length) continue;
                tmp.append(",");
            }
            ret = tmp.toString();
        } else if (long[].class.isAssignableFrom(type) || Long[].class.isAssignableFrom(type)) {
            long[] values = (long[])value;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                tmp.append(values[i]);
                if (i + 1 == values.length) continue;
                tmp.append(",");
            }
            ret = tmp.toString();
        } else if (float[].class.isAssignableFrom(type) || Float[].class.isAssignableFrom(type)) {
            float[] values = (float[])value;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                tmp.append(values[i]);
                if (i + 1 == values.length) continue;
                tmp.append(",");
            }
            ret = tmp.toString();
        } else if (double[].class.isAssignableFrom(type) || Double[].class.isAssignableFrom(type)) {
            double[] values = (double[])value;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                tmp.append(values[i]);
                if (i + 1 == values.length) continue;
                tmp.append(",");
            }
            ret = tmp.toString();
        } else {
            ret = value.toString();
        }
        return ret;
    }

    public static <T> T getVisualValue(Class<T> type, String value) throws Exception {
        Object ret;
        if (value == null || type == null) {
            ret = null;
        } else if (Boolean.class.isAssignableFrom(type)) {
            ret = Boolean.valueOf(value);
        } else if (Color.class.isAssignableFrom(type)) {
            ret = ConfigurationUtils.stringToColor(value);
        } else if (Password.class.isAssignableFrom(type)) {
            ret = new Password(value);
        } else if (ConfigurationConstants.FunctionKey.class.isAssignableFrom(type)) {
            ret = ConfigurationConstants.FunctionKey.valueOf(value);
        } else if (ConfigurationConstants.Language.class.isAssignableFrom(type)) {
            ret = ConfigurationConstants.Language.nameOf(value);
        } else if (ConfigurationConstants.MouseWheelAction.class.isAssignableFrom(type)) {
            ret = ConfigurationConstants.MouseWheelAction.nameOf(value);
        } else if (ConfigurationConstants.Protocol.class.isAssignableFrom(type)) {
            ret = ConfigurationConstants.Protocol.nameOf(value);
        } else if (ConfigurationConstants.SoundFile.class.isAssignableFrom(type)) {
            ret = new ConfigurationConstants.SoundFile(value);
        } else if (ConfigurationConstants.AlertNotify.class.isAssignableFrom(type)) {
            ret = ConfigurationConstants.AlertNotify.nameOf(value);
        } else if (StateModel.class.isAssignableFrom(type)) {
            ret = StateModel.stateModelOf(value);
        } else if (File.class.isAssignableFrom(type)) {
            ret = new File(value);
        } else if (int[].class.isAssignableFrom(type) || Integer[].class.isAssignableFrom(type)) {
            String[] values = StringUtils.split((String)value, (String)",");
            int[] tmp = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                tmp[i] = ConfigurationUtils.getVisualValue(Integer.class, values[i]);
            }
            ret = tmp;
        } else if (long[].class.isAssignableFrom(type) || Long[].class.isAssignableFrom(type)) {
            String[] values = StringUtils.split((String)value, (String)",");
            long[] tmp = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                tmp[i] = ConfigurationUtils.getVisualValue(Long.class, values[i]);
            }
            ret = tmp;
        } else if (float[].class.isAssignableFrom(type) || Float[].class.isAssignableFrom(type)) {
            String[] values = StringUtils.split((String)value, (String)",");
            float[] tmp = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                tmp[i] = ConfigurationUtils.getVisualValue(Float.class, values[i]).floatValue();
            }
            ret = tmp;
        } else if (double[].class.isAssignableFrom(type) || Double[].class.isAssignableFrom(type)) {
            String[] values = StringUtils.split((String)value, (String)",");
            double[] tmp = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                tmp[i] = ConfigurationUtils.getVisualValue(Double.class, values[i]);
            }
            ret = tmp;
        } else if (Integer.class.isAssignableFrom(type)) {
            try {
                ret = Integer.valueOf(value);
            }
            catch (Exception ex) {
                ret = null;
            }
        } else if (Long.class.isAssignableFrom(type)) {
            try {
                ret = Long.valueOf(value);
            }
            catch (Exception ex) {
                ret = null;
            }
        } else if (Float.class.isAssignableFrom(type)) {
            try {
                ret = Float.valueOf(value);
            }
            catch (Exception ex) {
                ret = null;
            }
        } else if (Double.class.isAssignableFrom(type)) {
            try {
                ret = Double.valueOf(value);
            }
            catch (Exception ex) {
                ret = null;
            }
        } else {
            try {
                ret = value;
            }
            catch (Exception ex) {
                ret = null;
            }
        }
        return (T)ret;
    }

    public static Color stringToColor(String rgb) throws Exception {
        if (rgb == null) {
            throw new IllegalArgumentException("rgb String cannot be null");
        }
        String[] rgbArray = rgb.split(",");
        int red = Integer.parseInt(rgbArray[0]);
        int green = Integer.parseInt(rgbArray[1]);
        int blue = Integer.parseInt(rgbArray[2]);
        return new Color(red, green, blue);
    }

    public static <T> T convertOldValueToNewValue(Class<T> newType, String key, String oldValueAsString) {
        Collection paramProviders = Lookup.getDefault().lookupAll(ConfigurationParametersProvider.class);
        for (ConfigurationParametersProvider paramProvider : paramProviders) {
            T newValue = paramProvider.convertOldValueToNewValue(newType, key, oldValueAsString);
            if (newValue == null) continue;
            return newValue;
        }
        return null;
    }
}

