/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.util;

import de.proveo.xml.fleet_management.meta_1.MetadataList;
import de.proveo.xml.fleet_management.resources_1.Resource;
import de.proveo.xml.fleet_management.resources_1.ResourceList;
import de.proveo.xml.fleet_management.statemodel_1.State;
import de.proveo.xml.fleet_management.statemodel_1.StateModel;
import de.proveo.xml.fleet_management.statemodel_1.StateModels;
import java.awt.Color;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class StatusModels {
    private static final Logger log = Logger.getLogger(StatusModels.class.getName());
    private static final String DEFAULT_RESOURCE_LOCALE = "en-US";
    private static final String DEFAULT_RESOURCE_VALUE = "[unknown]";
    private static final String DEFAULT_STATUS_COLOR = "#A0A0A0";
    private static final String DEFAULT_TEXT_COLOR = "#FF00FF";
    private List<StateModel> modelList = this.getDefaults();
    private HashMap<Integer, StateModel> modelsByID = null;
    private HashMap<String, State> statesByID = null;
    private HashMap<String, Map<String, String>> resources = null;
    private List<Integer> statusModelIdsSorted = null;
    private HashMap<Integer, List<Integer>> statusIdsSorted = null;
    private HashMap<Integer, List<Integer>> statusIdsChangeable = null;

    public StatusModels() {
        this.index();
    }

    public void setStatusModels(String xml) {
        this.modelList = this.getStateModelsFromXML(xml);
        this.index();
    }

    private void index() {
        String method = "index(): ";
        this.modelsByID = new HashMap();
        this.statesByID = new HashMap();
        this.resources = new HashMap();
        this.statusModelIdsSorted = new ArrayList<Integer>();
        this.statusIdsSorted = new HashMap();
        this.statusIdsChangeable = new HashMap();
        if (this.modelList == null) {
            log.log(Level.SEVERE, "{0}no status models defined!", method);
            this.modelList = new ArrayList<StateModel>();
            return;
        }
        TreeMap<Double, StateModel> modelsSorted = new TreeMap<Double, StateModel>();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}START indexing...", method);
        }
        for (StateModel model : this.modelList) {
            int modelId = model.getId();
            String modelName = ((Resource)model.getResources().getResource().get(0)).getValue();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}begin model {1} (''{2}'')", new Object[]{method, modelId, modelName});
            }
            String modelSortOrder = model.getSortOrder() + "." + modelId;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  put status model to ''modelsByID'' using ID {1}", new Object[]{method, modelId});
            }
            this.modelsByID.put(modelId, model);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  put status model to ''modelsSorted'' using sort order {1}", new Object[]{method, modelSortOrder});
            }
            modelsSorted.put(new Double(modelSortOrder), model);
            List res = model.getResources().getResource();
            Map<String, String> modelResources = this.extractResources(res);
            this.resources.put(Integer.toString(modelId), modelResources);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  all resources for model {1} finished", new Object[]{method, modelId});
            }
            List states = model.getStates().getState();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  state model {1} ''{2}'' contains {3} states:", new Object[]{method, model.getId(), modelName, states.size()});
            }
            TreeMap<Double, State> statesSorted = this.indexStates(states, modelId);
            this.setStatusIdsSorted(statesSorted, modelId);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "{0}end model {1} (''{2}'')", new Object[]{method, modelId, modelName});
        }
        this.setStatusModelIdsSorted(modelsSorted);
    }

    private TreeMap<Double, State> indexStates(List<State> states, int modelId) {
        String method = "indexStates(): ";
        TreeMap<Double, State> statesSorted = new TreeMap<Double, State>();
        for (State state : states) {
            int stateId = state.getId();
            String statusId = "" + modelId + stateId;
            String statusName = ((Resource)state.getResources().getResource().get(0)).getValue();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  BEGIN status {1} (''{2}'')", new Object[]{method, statusId, statusName});
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  put status to ''statesByID'' using ID {1}", new Object[]{method, statusId});
            }
            this.statesByID.put(statusId, state);
            String statusSortOrder = state.getSortOrder() + "." + statusId;
            if (stateId < 0) {
                statusSortOrder = state.getSortOrder() + "." + modelId + "0" + (stateId *= -1);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  put status to ''statesSorted'' using sort order {1}", new Object[]{method, statusSortOrder});
            }
            statesSorted.put(new Double(statusSortOrder), state);
            List res = state.getResources().getResource();
            Map<String, String> statusResources = this.extractResources(res);
            this.resources.put(statusId, statusResources);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}    all resources for status {1} finished", new Object[]{method, statusId});
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "{0}  END status {1} (''{2}'')", new Object[]{method, statusId, statusName});
        }
        return statesSorted;
    }

    private Map<String, String> extractResources(List<Resource> resources) {
        String method = "extractResources(): ";
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (Resource res : resources) {
            String lang = res.getLanguage();
            String text = res.getValue();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}    > found resource ''{1}''/''{2}''", new Object[]{method, lang, text});
            }
            resMap.put(lang, text);
        }
        return resMap;
    }

    private void setStatusModelIdsSorted(TreeMap<Double, StateModel> modelsSorted) {
        String method = "setStatusModelIdsSorted(): ";
        for (Double order : modelsSorted.keySet()) {
            StateModel stateModel = modelsSorted.get(order);
            int stateModelID = stateModel.getId();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}    -> sorted: ''{1}''/''{2}''", new Object[]{method, order, stateModelID});
            }
            this.statusModelIdsSorted.add(stateModelID);
        }
    }

    private void setStatusIdsSorted(TreeMap<Double, State> statesSorted, int model) {
        String method = "setStatusIdsSorted(): ";
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        ArrayList<Integer> changeable = new ArrayList<Integer>();
        for (Double order : statesSorted.keySet()) {
            State state = statesSorted.get(order);
            int stateID = state.getId();
            boolean isChangeable = state.isUserSettable();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}    -> sorted: order/stateID/changeable''{1}''/''{2}''/''{3}''", new Object[]{method, order, stateID, isChangeable});
            }
            sorted.add(stateID);
            if (!isChangeable) continue;
            changeable.add(stateID);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "{0}    *** stateID {1} is changeable!!!", new Object[]{method, stateID});
        }
        this.statusIdsSorted.put(model, sorted);
        this.statusIdsChangeable.put(model, changeable);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}    *** put {1} changable states to model {2}", new Object[]{method, changeable.size(), model});
        }
    }

    public List<Integer> getStatusModelIdsSorted() {
        return this.statusModelIdsSorted;
    }

    public boolean isStatusModelFilterIncludingSubStates(int modelId) {
        if (this.modelsByID.containsKey(modelId)) {
            return this.modelsByID.get(modelId).isFilterable();
        }
        return false;
    }

    public List<Integer> getStatusIdsSorted(int model) {
        if (this.statusIdsSorted.containsKey(model)) {
            return this.statusIdsSorted.get(model);
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> getStatusIdsChangeable(int model) {
        if (this.statusIdsChangeable.containsKey(model)) {
            return this.statusIdsChangeable.get(model);
        }
        return new ArrayList<Integer>();
    }

    public String getStatusModelName(int statusModel) {
        String resKey = Integer.toString(statusModel);
        return this.getResource(resKey);
    }

    public String getStatusName(int statusModel, int statusID) {
        String resKey = Integer.toString(statusModel) + Integer.toString(statusID);
        return this.getResource(resKey);
    }

    public String getStatusColorHTML(Integer statusModel, Integer statusID, boolean isText) {
        String method = "getStatusColorHTML(): ";
        String statusKey = "" + statusModel + statusID;
        if (statusID == null || !this.statesByID.containsKey(statusKey)) {
            if (statusID != null) {
                log.log(Level.SEVERE, "{0}Could not found color for status {1}/{2}, use default color!", new Object[]{method, statusModel, statusID});
            }
            if (isText) {
                return DEFAULT_TEXT_COLOR;
            }
            return DEFAULT_STATUS_COLOR;
        }
        return this.statesByID.get(statusKey).getColor();
    }

    public Color getStatusColor(int statusModel, int statusID) {
        return Color.decode(this.getStatusColorHTML(statusModel, statusID, false));
    }

    private String getResource(String resKey) {
        String method = "getResource(): ";
        if (!this.resources.containsKey(resKey)) {
            log.log(Level.SEVERE, "{0}Could not found a resource for ''{1}'' !", new Object[]{method, resKey});
            return DEFAULT_RESOURCE_VALUE;
        }
        Locale locale = Locale.getDefault();
        String localeKey = locale.getLanguage() + "-" + locale.getCountry();
        Map<String, String> res = this.resources.get(resKey);
        if (res.containsKey(localeKey)) {
            return res.get(localeKey);
        }
        log.log(Level.WARNING, "{0}Could not found a resource for ''{1}'' with Locale ''{2}''", new Object[]{method, resKey, localeKey});
        log.log(Level.INFO, "{0}try to find resource for ''{1}'' with default Locale ''en-US''...", new Object[]{method, resKey});
        if (res.containsKey(DEFAULT_RESOURCE_LOCALE)) {
            return res.get(DEFAULT_RESOURCE_LOCALE);
        }
        log.log(Level.SEVERE, "{0}Could not found a resource for ''{1}'' with Locale ''{2}'' either default Locale ''en-US''!", new Object[]{method, resKey, localeKey});
        return DEFAULT_RESOURCE_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StateModel> getStateModelsFromXML(String xml) {
        String method = "getStateModelsFromXML(): ";
        StringReader xmlReader = new StringReader(xml);
        try {
            List<StateModel> list = this.unmarshalXml(new StreamSource(xmlReader));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert given state models xml: " + xml, ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)xmlReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StateModel> getDefaults() {
        String method = "getDefaults(): ";
        InputStream is = StateModels.class.getResourceAsStream("statemodel-1.0.xml");
        try {
            List<StateModel> list = this.unmarshalXml(new StreamSource(is));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert state model defaults xml", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    private List<StateModel> unmarshalXml(StreamSource xmlSource) throws JAXBException, SAXException {
        String method = "unmarshalXml(): ";
        if (xmlSource == null) {
            log.log(Level.SEVERE, "{0}Can not convert null or empty source. Break", method);
            return null;
        }
        Source[] xsdSources = new Source[]{new StreamSource(MetadataList.class.getResourceAsStream("meta-1.0.xsd")), new StreamSource(ResourceList.class.getResourceAsStream("resources-1.0.xsd")), new StreamSource(StateModels.class.getResourceAsStream("statemodel-1.0.xsd"))};
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(xsdSources);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StateModels.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        StateModels stateModels = (StateModels)StateModels.class.cast(unmarshaller.unmarshal((Source)xmlSource));
        return stateModels.getStateModel();
    }
}

